<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

$active_world_events = get_active_world_events();

if (is_logged_in()) {
    $user = get_user_info($_SESSION['user_id']);
    $country = get_user_country($_SESSION['user_id']);
    $level_info = get_user_level_info($user['level']);
    $travel = is_traveling($_SESSION['user_id']);
    $random_mission = null;
    
    if (!$travel) {
        $random_mission = get_random_mission($user['level'], $user['country_id']);
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cergies - Un monde en guerre</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: white;
        }
        .hero {
            background-image: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('https://source.unsplash.com/random/1920x1080/?war,city');
            background-size: cover;
            background-position: center;
        }
        .card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <header class="bg-gray-900 text-white">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center">
                <h1 class="text-2xl font-bold">CERGIES</h1>
            </div>
            <nav>
                <ul class="flex space-x-6">
                    <li><a href="index.php" class="hover:text-blue-300">Accueil</a></li>
                    <?php if (is_logged_in()): ?>
                        <li><a href="map.php" class="hover:text-blue-300">Carte</a></li>
                        <li><a href="communication.php" class="hover:text-blue-300">Communications</a></li>
                        <li><a href="system.php" class="hover:text-blue-300">Système</a></li>
                        <li><a href="inventory.php" class="hover:text-blue-300">Inventaire</a></li>
                        <li><a href="missions.php" class="hover:text-blue-300">Missions</a></li>
                        <?php if ($user['level'] >= 10): ?>
                            <li><a href="unions.php" class="hover:text-blue-300">Unions</a></li>
                        <?php endif; ?>
                        <li><a href="profile.php" class="hover:text-blue-300">Profil</a></li>
                        <li><a href="logout.php" class="hover:text-red-300">Déconnexion</a></li>
                    <?php else: ?>
                        <li><a href="login.php" class="hover:text-blue-300">Connexion</a></li>
                        <li><a href="register.php" class="hover:text-blue-300">Inscription</a></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </header>

    <section class="hero h-96 flex items-center justify-center text-center text-white">
        <div class="container mx-auto px-4">
            <h2 class="text-4xl font-bold mb-4">Bienvenue dans un monde en guerre</h2>
            <p class="text-xl mb-8">Entre dans l'univers de Cergies, où chaque décision peut changer le cours de l'histoire</p>
            <?php if (!is_logged_in()): ?>
                <div class="flex justify-center space-x-4">
                    <a href="register.php" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition-colors">Créer un compte</a>
                    <a href="login.php" class="bg-gray-700 hover:bg-gray-800 text-white font-bold py-3 px-6 rounded-lg transition-colors">Se connecter</a>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <?php if (is_logged_in() && $travel): ?>
        <section class="bg-yellow-50 border-t border-b border-yellow-100 py-4">
            <div class="container mx-auto px-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-yellow-800">
                            <span class="font-semibold">En déplacement:</span> 
                            Arrivée prévue le <?php echo format_datetime($travel['arrival_time']); ?>
                        </p>
                    </div>
                    <a href="travel.php" class="text-blue-600 hover:underline">Voir les détails</a>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if (!empty($active_world_events)): ?>
        <section class="bg-red-50 border-t border-b border-red-100 py-4">
            <div class="container mx-auto px-4">
                <h3 class="text-lg font-semibold text-red-800 mb-2">Événements mondiaux en cours</h3>
                <ul class="space-y-2">
                    <?php foreach($active_world_events as $event): ?>
                        <li class="flex items-start">
                            <span class="inline-block w-2 h-2 bg-red-500 rounded-full mt-2 mr-2"></span>
                            <div>
                                <p class="font-medium"><?php echo htmlspecialchars($event['title']); ?></p>
                                <p class="text-sm text-gray-600"><?php echo htmlspecialchars($event['description']); ?></p>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </section>
    <?php endif; ?>

    <main class="container mx-auto px-4 py-8">
        <?php if (is_logged_in()): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div class="card p-6">
                    <h3 class="text-xl font-semibold mb-4">Status de l'agent</h3>
                    <div class="space-y-3">
                        <p><span class="font-medium">Nom:</span> <?php echo htmlspecialchars($user['username']); ?></p>
                        <p><span class="font-medium">Niveau:</span> <?php echo $user['level']; ?> (<?php echo $level_info['title']; ?>)</p>
                        <p>
                            <span class="font-medium">Expérience:</span> 
                            <?php echo $user['experience']; ?> / <?php echo $level_info['max_exp']; ?>
                        </p>
                        <p><span class="font-medium">Pays:</span> <?php echo htmlspecialchars($country['name']); ?></p>
                        <p><span class="font-medium">Réputation:</span> <?php echo $user['reputation']; ?></p>
                        <div class="pt-2">
                            <a href="profile.php" class="text-blue-600 hover:underline">Voir le profil complet</a>
                        </div>
                    </div>
                </div>

                <div class="card p-6">
                    <h3 class="text-xl font-semibold mb-4">État du système national</h3>
                    <div class="space-y-3">
                        <p><span class="font-medium">Pays:</span> <?php echo htmlspecialchars($country['name']); ?></p>
                        <p>
                            <span class="font-medium">Niveau de sécurité:</span> 
                            <span class="inline-flex items-center">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <?php if ($i <= $country['system_security_level']): ?>
                                        <span class="h-3 w-3 bg-green-500 rounded-full mx-0.5"></span>
                                    <?php else: ?>
                                        <span class="h-3 w-3 bg-gray-300 rounded-full mx-0.5"></span>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span class="ml-2"><?php echo $country['system_security_level']; ?>/5</span>
                            </span>
                        </p>
                        <p>
                            <span class="font-medium">État économique:</span>
                            <?php
                                $status_colors = [
                                    'unstable' => 'text-red-600',
                                    'stable' => 'text-green-600',
                                    'very_stable' => 'text-blue-600',
                                    'growing' => 'text-purple-600'
                                ];
                                $status_text = [
                                    'unstable' => 'Instable',
                                    'stable' => 'Stable',
                                    'very_stable' => 'Très stable',
                                    'growing' => 'En croissance'
                                ];
                                $color = $status_colors[$country['economy_status']] ?? 'text-gray-600';
                                $text = $status_text[$country['economy_status']] ?? $country['economy_status'];
                            ?>
                            <span class="<?php echo $color; ?>"><?php echo $text; ?></span>
                        </p>
                        <div class="pt-2">
                            <a href="system.php" class="text-blue-600 hover:underline">Accéder au système</a>
                        </div>
                    </div>
                </div>

                <?php if ($random_mission): ?>
                    <div class="card p-6 border-l-4 border-blue-500">
                        <h3 class="text-xl font-semibold mb-4">Mission disponible</h3>
                        <div class="space-y-3">
                            <p class="font-medium text-lg"><?php echo htmlspecialchars($random_mission['title']); ?></p>
                            <p class="text-sm"><?php echo htmlspecialchars($random_mission['description']); ?></p>
                            <p>
                                <span class="font-medium">Difficulté:</span>
                                <?php
                                    $difficulty_colors = [
                                        'easy' => 'text-green-600',
                                        'medium' => 'text-yellow-600',
                                        'hard' => 'text-orange-600',
                                        'expert' => 'text-red-600'
                                    ];
                                    $difficulty_text = [
                                        'easy' => 'Facile',
                                        'medium' => 'Moyenne',
                                        'hard' => 'Difficile',
                                        'expert' => 'Expert'
                                    ];
                                    $color = $difficulty_colors[$random_mission['difficulty']] ?? 'text-gray-600';
                                    $text = $difficulty_text[$random_mission['difficulty']] ?? $random_mission['difficulty'];
                                ?>
                                <span class="<?php echo $color; ?>"><?php echo $text; ?></span>
                            </p>
                            <p><span class="font-medium">Récompense:</span> <?php echo $random_mission['reward_exp']; ?> XP</p>
                            <div class="pt-2">
                                <a href="missions.php?accept=<?php echo $random_mission['id']; ?>" class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded transition-colors">
                                    Accepter la mission
                                </a>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="card p-6">
                        <h3 class="text-xl font-semibold mb-4">Actions rapides</h3>
                        <div class="space-y-4">
                            <a href="map.php" class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center font-medium py-2 px-4 rounded transition-colors">
                                Explorer la carte
                            </a>
                            <a href="communication.php" class="block w-full bg-green-600 hover:bg-green-700 text-white text-center font-medium py-2 px-4 rounded transition-colors">
                                Communications
                            </a>
                            <a href="terminal.php" class="block w-full bg-gray-800 hover:bg-gray-900 text-white text-center font-medium py-2 px-4 rounded transition-colors">
                                Terminal système
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
                <div class="card p-6 flex flex-col items-center text-center">
                    <div class="text-5xl mb-4">🌍</div>
                    <h3 class="text-xl font-semibold mb-2">Monde en conflit</h3>
                    <p>Explore une carte mondiale où chaque pays lutte pour sa propre survie dans un environnement hostile.</p>
                </div>
                
                <div class="card p-6 flex flex-col items-center text-center">
                    <div class="text-5xl mb-4">👥</div>
                    <h3 class="text-xl font-semibold mb-2">Alliances stratégiques</h3>
                    <p>Rencontre d'autres agents, forme des alliances et communique en temps réel pour survivre.</p>
                </div>
                
                <div class="card p-6 flex flex-col items-center text-center">
                    <div class="text-5xl mb-4">🔐</div>
                    <h3 class="text-xl font-semibold mb-2">Systèmes et espionnage</h3>
                    <p>Protège le système central de ton pays ou infiltre celui des nations ennemies pour gagner l'avantage.</p>
                </div>
            </div>
            
            <div class="card p-8 max-w-3xl mx-auto">
                <h2 class="text-2xl font-bold mb-4">À propos de Cergies</h2>
                <p class="mb-4">Cergies est une plateforme immersive qui simule un monde en état de guerre. Les joueurs incarnent des agents travaillant pour leur pays, naviguant dans un environnement complexe de diplomatie, d'espionnage et de survie.</p>
                <p class="mb-4">Chaque agent peut explorer le monde, rencontrer d'autres joueurs, former des alliances ou devenir des rivaux. Les déplacements se font en temps réel, ce qui signifie qu'un voyage entre Paris et Barcelone prendra autant de temps que dans la réalité.</p>
                <p class="mb-6">En progressant, tu pourras rejoindre ou créer des unions, développer tes compétences, accomplir des missions et participer à des opérations d'infiltration pour protéger ton pays ou affaiblir tes ennemis.</p>
                <div class="flex justify-center">
                    <a href="register.php" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition-colors">Commence ton aventure</a>
                </div>
            </div>
        <?php endif; ?>
    </main>

    <footer class="bg-gray-900 text-white py-8">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-lg font-semibold mb-4">À propos</h3>
                    <p class="text-gray-400">Cergies est une plateforme d'immersion qui simule un monde en état de guerre permanent, créée par Imators.</p>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Liens rapides</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><a href="index.php" class="hover:text-white">Accueil</a></li>
                        <li><a href="map.php" class="hover:text-white">Carte du monde</a></li>
                        <li><a href="register.php" class="hover:text-white">Inscription</a></li>
                        <li><a href="login.php" class="hover:text-white">Connexion</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-lg font-semibold mb-4">Contactez-nous</h3>
                    <p class="text-gray-400">Pour toute question ou suggestion, n'hésite pas à nous contacter.</p>
                    <p class="text-gray-400">Email: contact@imators.com</p>
                </div>
            </div>
            <div class="border-t border-gray-800 mt-8 pt-6 text-center">
                <p class="text-gray-500">&copy; <?php echo date('Y'); ?> Imators. Tous droits réservés.</p>
            </div>
        </div>
    </footer>
</body>
</html>