<!DOCTYPE html>
<html lang="ar" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الدعم</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        .bg-image {
            background-image: url('IMG_7530.JPG');
            background-size: cover;
            background-position: center;
            filter: brightness(0.6);
        }
        .faq-item {
            margin-bottom: 1rem;
        }
        .faq-question {
            cursor: pointer;
            padding: 1rem 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            text-align: left;
            background: transparent;
            border: none;
            border-bottom: 1px solid #333;
            color: #fff;
        }
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
            padding: 0 1rem;
            opacity: 0;
            transform: translateY(-10px);
        }
        .faq-answer.active {
            max-height: 300px;
            opacity: 1;
            transform: translateY(0);
            transition: all 0.3s ease-in;
            padding: 1rem;
        }
        .contact-email-banner {
            background: linear-gradient(90deg, #3B82F6 0%, #2563EB 100%);
            color: white;
            padding: 0.75rem 1rem;
            text-align: center;
            font-weight: 500;
            margin-bottom: 0;
        }
        .contact-email-link {
            color: white;
            font-weight: 600;
            text-decoration: underline;
            transition: opacity 0.2s ease;
        }
        .contact-email-link:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <?php include 'src/header.php'; ?>
<!-- Email Banner -->

<header class="relative h-80">
    <div class="bg-image absolute inset-0"></div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
    <div class="container mx-auto px-4 h-full flex items-end pb-12 relative z-10">
        <h1 class="text-5xl font-light text-white tracking-wide">الدعم</h1>
    </div>
</header>

<main class="flex-grow container mx-auto px-4 py-16">
    <div class="max-w-4xl mx-auto space-y-16">
        <div class="text-center space-y-6">
            <h2 class="text-3xl text-white font-light">نحن هنا للمساعدة</h2>
            <p class="text-lg max-w-2xl mx-auto">
            فريق الدعم لدينا متاح على مدار 24 ساعة و 7 أيام في الأسبوع للإجابة على جميع استفساراتكم.
            كل ما عليك هو التواصل معنا عبر البريد الإلكتروني للحصول على المساعدة.
            </p>
        </div>

        <!-- FAQ Section (Commented Out)
        <section class="space-y-8">
            <h2 class="text-3xl text-white font-light text-center">الأسئلة المتكررة</h2>
            <div class="space-y-4 max-w-2xl mx-auto">
                [FAQ section content will be added in next part]
            </div>
        </section>  -->

	<div class="text-center space-y-4">
            <h2 class="text-3xl text-white font-light">الدعم لعملائنا</h2>
            <p class="text-lg">
            يمكن للعملاء الذين لديهم حساب Imators <a href="https://idsma.imators.com" class="underline text-white">إرسال طلبات الدعم من خلال مساحة التذاكر الخاصة بهم.</a>
            </p>
        </div>