<?php
// actions/hit.php
require_once '../config/db.php';
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$profile_id = intval($data['profileId']);
$user_id = $_SESSION['user_id'];

// Ajouter le hit
$insert_query = "INSERT INTO hits (user_id, hitter_id) VALUES (?, ?)";
$insert_stmt = $conn->prepare($insert_query);
$insert_stmt->bind_param("ii", $profile_id, $user_id);
$insert_stmt->execute();

// Récupérer le nouveau compte
$count_query = "SELECT COUNT(*) as count FROM hits WHERE user_id = ?";
$count_stmt = $conn->prepare($count_query);
$count_stmt->bind_param("i", $profile_id);
$count_stmt->execute();
$result = $count_stmt->get_result()->fetch_assoc();

echo json_encode([
    'success' => true,
    'newCount' => $result['count']
]);
?>