<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$userId = intval($data['userId']);
$friendId = intval($data['friendId']);

$sql = "INSERT INTO friends (user_id, friend_id) VALUES ($userId, $friendId)";

if ($conn->query($sql) === TRUE) {
    $userSql = "SELECT first_name, last_name FROM users WHERE id = $userId";
    $userResult = $conn->query($userSql);
    $user = $userResult->fetch_assoc();
    $userName = $user['first_name'] . ' ' . $user['last_name'];
    
    $notifData = [
        'userId' => strval($friendId),
        'title' => 'Nouvelle demande d\'ami',
        'message' => "$userName vous a ajouté comme ami !",
        'data' => [
            'type' => 'new_friend',
            'userId' => $userId
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://imators.systems/api-court/send_notification.php');
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notifData));
    curl_exec($ch);
    curl_close($ch);
    
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => $conn->error]);
}

$conn->close();
?>