<?php
session_start();
require_once 'db.php';

$lang = isset($_GET['lang']) ? $_GET['lang'] : 'fr';

$translations = [
    'fr' => [
        'title' => 'Réservation Petit Déjeuner - AktaHome Resort',
        'breakfast_booking' => 'Réservation Petit Déjeuner',
        'provided_by' => 'Fourni par Le Pain Quotidien',
        'select_items' => 'Sélectionnez vos articles',
        'cart' => 'Panier',
        'name_placeholder' => 'Votre nom',
        'validate_order' => 'Valider la commande',
        'empty_cart' => 'Votre panier est vide',
        'order_success' => 'Commande validée avec succès !',
        'add_to_cart' => 'Ajouter au panier',
        'remove' => 'Retirer',
        'apple_juice' => 'Jus de pomme',
        'grapefruit_juice' => 'Jus de pamplemousse',
        'carrot_juice' => 'Jus de carotte',
        'french_toast' => 'Pain Perdu',
        'scrambled_eggs' => 'Œuf brouillé',
        'eggplant_pesto_toast' => 'Toast au aubergine/pesto accompagné de poulet',
        'homemade_ice_tea' => 'Ice Tea Maison',
        'croissant' => 'Croissant',
        'pain_chocolat' => 'Pain au chocolat',
        'tortillon' => 'Tortillon',
        'close' => 'Fermer',
        'salon_hours' => 'Salon de Thé ouvert à 09h00',
        'delivery_time' => 'Livraison à 10h30',
        'quantity' => 'Quantité'
    ],
    'en' => [
        'title' => 'Breakfast Booking - AktaHome Resort',
        'breakfast_booking' => 'Breakfast Booking',
        'provided_by' => 'Provided by Le Pain Quotidien',
        'select_items' => 'Select your items',
        'cart' => 'Cart',
        'name_placeholder' => 'Your name',
        'validate_order' => 'Validate order',
        'empty_cart' => 'Your cart is empty',
        'order_success' => 'Order validated successfully!',
        'add_to_cart' => 'Add to cart',
        'remove' => 'Remove',
        'apple_juice' => 'Apple juice',
        'grapefruit_juice' => 'Grapefruit juice',
        'carrot_juice' => 'Carrot juice',
        'french_toast' => 'French toast',
        'scrambled_eggs' => 'Scrambled eggs',
        'eggplant_pesto_toast' => 'Eggplant/pesto toast with chicken',
        'homemade_ice_tea' => 'Homemade Ice Tea',
        'croissant' => 'Croissant',
        'pain_chocolat' => 'Pain au chocolat',
        'tortillon' => 'Tortillon',
        'close' => 'Close',
        'salon_hours' => 'Tea Salon open at 09:00 AM',
        'delivery_time' => 'Delivery at 10:30 AM',
        'quantity' => 'Quantity'
    ]
];

$t = $translations[$lang];

$items = [
    'apple_juice' => $t['apple_juice'],
    'grapefruit_juice' => $t['grapefruit_juice'],
    'carrot_juice' => $t['carrot_juice'],
    'french_toast' => $t['french_toast'],
    'scrambled_eggs' => $t['scrambled_eggs'],
    'eggplant_pesto_toast' => $t['eggplant_pesto_toast'],
    'homemade_ice_tea' => $t['homemade_ice_tea'],
    'croissant' => $t['croissant'],
    'pain_chocolat' => $t['pain_chocolat'],
    'tortillon' => $t['tortillon']
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['validate_order'])) {
        $name = $_POST['name'];
        $cart = json_decode($_POST['cart_data'], true);
        
        if (!empty($name) && !empty($cart)) {
            $stmt = $pdo->prepare("INSERT INTO breakfast_orders (name, items, order_date) VALUES (?, ?, NOW())");
            $stmt->execute([$name, json_encode($cart)]);
            $success = true;
            $_SESSION['cart'] = [];
        }
    }
}

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?></title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <div class="max-w-4xl mx-auto px-6 py-12">
        <div class="text-center mb-16">
            <h1 class="text-4xl font-light mb-4">AktaHome Resort</h1>
            <h2 class="text-xl text-gray-600 mb-4"><?php echo $t['breakfast_booking']; ?></h2>
            <p class="text-gray-500 mb-2"><?php echo $t['provided_by']; ?></p>
            <p class="text-sm text-gray-400 mb-2"><?php echo $t['salon_hours']; ?></p>
            <p class="text-sm text-gray-600 font-medium"><?php echo $t['delivery_time']; ?></p>
            <div class="mt-6">
                <a href="?lang=fr" class="text-gray-500 hover:text-gray-900 mr-4 <?php echo $lang === 'fr' ? 'font-bold' : ''; ?>">FR</a>
                <a href="?lang=en" class="text-gray-500 hover:text-gray-900 <?php echo $lang === 'en' ? 'font-bold' : ''; ?>">EN</a>
            </div>
        </div>

        <?php if (isset($success)): ?>
            <div class="bg-green-50 border border-green-200 text-green-800 px-6 py-4 rounded mb-8">
                <?php echo $t['order_success']; ?>
            </div>
        <?php endif; ?>

        <div class="space-y-4">
            <?php foreach ($items as $key => $name): ?>
                <div class="flex justify-between items-center py-6 border-b border-gray-100">
                    <span class="text-lg"><?php echo $name; ?></span>
                    <button onclick="addToCart('<?php echo $key; ?>', '<?php echo addslashes($name); ?>')" 
                            class="w-10 h-10 bg-black text-white rounded-full flex items-center justify-center hover:bg-gray-800 transition-colors">
                        <span class="text-xl">+</span>
                    </button>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <button onclick="openCartModal()" 
            class="fixed bottom-8 right-8 w-16 h-16 bg-black text-white rounded-full flex items-center justify-center hover:bg-gray-800 transition-colors z-50">
        <div class="text-center">
            <div class="text-sm">🛒</div>
            <div class="text-xs" id="cart-count">0</div>
        </div>
    </button>

    <div id="cart-modal" class="fixed inset-0 bg-black bg-opacity-20 hidden z-50">
        <div class="flex items-center justify-center min-h-screen p-6">
            <div class="bg-white rounded-lg w-full max-w-md">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl"><?php echo $t['cart']; ?></h3>
                        <button onclick="closeCartModal()" class="text-gray-400 hover:text-gray-600">
                            <span class="text-2xl">×</span>
                        </button>
                    </div>
                </div>
                
                <div class="max-h-80 overflow-y-auto">
                    <div id="cart-items" class="p-6">
                        <p class="text-gray-500 text-center py-8" id="empty-cart"><?php echo $t['empty_cart']; ?></p>
                    </div>
                </div>

                <div class="p-6 border-t border-gray-100 bg-gray-50" id="cart-footer" style="display: none;">
                    <div class="text-xs text-gray-500 mb-4 text-center">
                        <?php echo $t['delivery_time']; ?>
                    </div>
                    <form method="POST" id="order-form">
                        <input type="text" name="name" placeholder="<?php echo $t['name_placeholder']; ?>" 
                               class="w-full px-4 py-3 border border-gray-200 rounded mb-4 focus:outline-none focus:border-gray-400" required>
                        <input type="hidden" name="cart_data" id="cart-data">
                        <button type="submit" name="validate_order" 
                                class="w-full bg-black text-white py-3 rounded hover:bg-gray-800 transition-colors">
                            <?php echo $t['validate_order']; ?>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        let cart = {};

        function addToCart(key, name) {
            if (cart[key]) {
                cart[key].quantity++;
            } else {
                cart[key] = { name: name, quantity: 1 };
            }
            updateCartDisplay();
        }

        function removeFromCart(key) {
            if (cart[key]) {
                cart[key].quantity--;
                if (cart[key].quantity <= 0) {
                    delete cart[key];
                }
            }
            updateCartDisplay();
        }

        function updateCartDisplay() {
            const cartItems = document.getElementById('cart-items');
            const emptyCart = document.getElementById('empty-cart');
            const cartFooter = document.getElementById('cart-footer');
            const cartData = document.getElementById('cart-data');
            const cartCount = document.getElementById('cart-count');

            cartItems.innerHTML = '';
            
            let totalItems = 0;
            for (const item of Object.values(cart)) {
                totalItems += item.quantity;
            }
            cartCount.textContent = totalItems;

            if (Object.keys(cart).length === 0) {
                cartItems.appendChild(emptyCart);
                cartFooter.style.display = 'none';
            } else {
                cartFooter.style.display = 'block';
                
                for (const [key, item] of Object.entries(cart)) {
                    const div = document.createElement('div');
                    div.className = 'flex justify-between items-center py-4 px-6 border-b border-gray-50';
                    div.innerHTML = `
                        <div class="flex-1">
                            <div class="font-medium text-gray-900">${item.name}</div>
                            <div class="text-sm text-gray-500 mt-1"><?php echo $t['quantity']; ?>: ${item.quantity}</div>
                        </div>
                        <div class="flex items-center space-x-3">
                            <button onclick="removeFromCart('${key}')" 
                                    class="w-8 h-8 bg-gray-100 text-gray-600 rounded-full flex items-center justify-center hover:bg-gray-200 transition-colors">
                                <span class="text-lg">−</span>
                            </button>
                            <button onclick="addToCart('${key}', '${item.name.replace(/'/g, "\\'")}')" 
                                    class="w-8 h-8 bg-black text-white rounded-full flex items-center justify-center hover:bg-gray-800 transition-colors">
                                <span class="text-lg">+</span>
                            </button>
                        </div>
                    `;
                    cartItems.appendChild(div);
                }
            }

            cartData.value = JSON.stringify(cart);
        }

        function openCartModal() {
            document.getElementById('cart-modal').classList.remove('hidden');
        }

        function closeCartModal() {
            document.getElementById('cart-modal').classList.add('hidden');
        }

        document.getElementById('cart-modal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeCartModal();
            }
        });
    </script>
</body>
</html>