<?php
require_once 'db.php';

$lang = isset($_GET['lang']) ? $_GET['lang'] : 'fr';

$translations = [
    'fr' => [
        'title' => 'Administration - Commandes Petit Déjeuner',
        'admin_panel' => 'Panneau d\'Administration',
        'breakfast_orders' => 'Commandes Petit Déjeuner',
        'order_id' => 'ID',
        'customer_name' => 'Nom Client',
        'items_ordered' => 'Articles Commandés',
        'order_date' => 'Date Commande',
        'no_orders' => 'Aucune commande trouvée',
        'quantity' => 'Quantité',
        'total_orders' => 'Total des commandes',
        'delete' => 'Supprimer',
        'confirm_delete' => 'Êtes-vous sûr de vouloir supprimer cette commande ?',
        'order_deleted' => 'Commande supprimée avec succès',
        'export_csv' => 'Exporter CSV'
    ],
    'en' => [
        'title' => 'Administration - Breakfast Orders',
        'admin_panel' => 'Administration Panel',
        'breakfast_orders' => 'Breakfast Orders',
        'order_id' => 'ID',
        'customer_name' => 'Customer Name',
        'items_ordered' => 'Items Ordered',
        'order_date' => 'Order Date',
        'no_orders' => 'No orders found',
        'quantity' => 'Quantity',
        'total_orders' => 'Total orders',
        'delete' => 'Delete',
        'confirm_delete' => 'Are you sure you want to delete this order?',
        'order_deleted' => 'Order deleted successfully',
        'export_csv' => 'Export CSV'
    ]
];

$t = $translations[$lang];

if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $stmt = $pdo->prepare("DELETE FROM breakfast_orders WHERE id = ?");
    $stmt->execute([$_GET['delete']]);
    $success = $t['order_deleted'];
    header("Location: admin.php?lang=$lang&deleted=1");
    exit;
}

if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $stmt = $pdo->query("SELECT * FROM breakfast_orders ORDER BY order_date DESC");
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="breakfast_orders_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'Nom', 'Articles', 'Date']);
    
    foreach ($orders as $order) {
        $items = json_decode($order['items'], true);
        $itemsText = '';
        foreach ($items as $item) {
            $itemsText .= $item['name'] . ' (' . $item['quantity'] . '), ';
        }
        $itemsText = rtrim($itemsText, ', ');
        
        fputcsv($output, [
            $order['id'],
            $order['name'],
            $itemsText,
            $order['order_date']
        ]);
    }
    
    fclose($output);
    exit;
}

$stmt = $pdo->query("SELECT * FROM breakfast_orders ORDER BY order_date DESC");
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

$totalOrders = count($orders);
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?></title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <div class="max-w-7xl mx-auto px-6 py-12">
        <div class="text-center mb-12">
            <h1 class="text-4xl font-light mb-4">AktasHome Resort</h1>
            <h2 class="text-xl text-gray-600 mb-8"><?php echo $t['admin_panel']; ?></h2>
            <div class="mb-6">
                <a href="?lang=fr" class="text-gray-500 hover:text-gray-900 mr-4 <?php echo $lang === 'fr' ? 'font-bold' : ''; ?>">FR</a>
                <a href="?lang=en" class="text-gray-500 hover:text-gray-900 <?php echo $lang === 'en' ? 'font-bold' : ''; ?>">EN</a>
            </div>
        </div>

        <?php if (isset($_GET['deleted'])): ?>
            <div class="bg-green-50 border border-green-200 text-green-800 px-6 py-4 rounded mb-8 text-center">
                <?php echo $t['order_deleted']; ?>
            </div>
        <?php endif; ?>

        <div class="flex justify-between items-center mb-8">
            <div>
                <h3 class="text-2xl font-light"><?php echo $t['breakfast_orders']; ?></h3>
                <p class="text-gray-500"><?php echo $t['total_orders']; ?>: <?php echo $totalOrders; ?></p>
            </div>
            <a href="?export=csv&lang=<?php echo $lang; ?>" 
               class="bg-black text-white px-6 py-3 rounded hover:bg-gray-800 transition-colors">
                <?php echo $t['export_csv']; ?>
            </a>
        </div>

        <?php if (empty($orders)): ?>
            <div class="text-center py-16">
                <p class="text-gray-500 text-lg"><?php echo $t['no_orders']; ?></p>
            </div>
        <?php else: ?>
            <div class="space-y-6">
                <?php foreach ($orders as $order): ?>
                    <div class="border border-gray-200 rounded-lg p-6 hover:shadow-md transition-shadow">
                        <div class="flex justify-between items-start mb-4">
                            <div>
                                <h4 class="text-lg font-medium"><?php echo htmlspecialchars($order['name']); ?></h4>
                                <p class="text-sm text-gray-500">
                                    <?php echo $t['order_id']; ?>: #<?php echo $order['id']; ?> - 
                                    <?php echo date('d/m/Y H:i', strtotime($order['order_date'])); ?>
                                </p>
                            </div>
                            <button onclick="deleteOrder(<?php echo $order['id']; ?>)" 
                                    class="text-red-500 hover:text-red-700 text-sm">
                                <?php echo $t['delete']; ?>
                            </button>
                        </div>
                        
                        <div class="bg-gray-50 rounded p-4">
                            <h5 class="font-medium mb-3"><?php echo $t['items_ordered']; ?>:</h5>
                            <div class="grid md:grid-cols-2 gap-3">
                                <?php
                                $items = json_decode($order['items'], true);
                                foreach ($items as $item):
                                ?>
                                    <div class="flex justify-between items-center py-2 px-3 bg-white rounded">
                                        <span><?php echo htmlspecialchars($item['name']); ?></span>
                                        <span class="text-sm text-gray-500">
                                            <?php echo $t['quantity']; ?>: <?php echo $item['quantity']; ?>
                                        </span>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <script>
        function deleteOrder(id) {
            if (confirm('<?php echo $t['confirm_delete']; ?>')) {
                window.location.href = '?delete=' + id + '&lang=<?php echo $lang; ?>';
            }
        }
    </script>
</body>
</html>