<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db_comm.php';

$merchant_id = $_SESSION['merchant_id'];
$shop_name = trim($_POST['shop_name'] ?? '');
$shop_description = trim($_POST['shop_description'] ?? '');
$shop_address = trim($_POST['shop_address'] ?? '');
$shop_phone = trim($_POST['shop_phone'] ?? '');

$shop_ids = json_decode($_SESSION['shop_ids'], true);
if (!$shop_ids || empty($shop_ids)) {
    echo json_encode(['success' => false, 'message' => 'Aucun commerce associé à ce compte']);
    exit();
}

$shop_id = $shop_ids[0];

try {
    $updates_submitted = 0;
    
    if (!empty($shop_name)) {
        $stmt = $pdo_comm->prepare("INSERT INTO shop_updates (merchant_id, shop_id, field_name, new_value) VALUES (?, ?, 'name', ?)");
        $stmt->execute([$merchant_id, $shop_id, $shop_name]);
        $updates_submitted++;
    }
    
    if (!empty($shop_description)) {
        $stmt = $pdo_comm->prepare("INSERT INTO shop_updates (merchant_id, shop_id, field_name, new_value) VALUES (?, ?, 'description', ?)");
        $stmt->execute([$merchant_id, $shop_id, $shop_description]);
        $updates_submitted++;
    }
    
    if (!empty($shop_address)) {
        $stmt = $pdo_comm->prepare("INSERT INTO shop_updates (merchant_id, shop_id, field_name, new_value) VALUES (?, ?, 'address', ?)");
        $stmt->execute([$merchant_id, $shop_id, $shop_address]);
        $updates_submitted++;
    }
    
    if (!empty($shop_phone)) {
        $stmt = $pdo_comm->prepare("INSERT INTO shop_updates (merchant_id, shop_id, field_name, new_value) VALUES (?, ?, 'phone', ?)");
        $stmt->execute([$merchant_id, $shop_id, $shop_phone]);
        $updates_submitted++;
    }
    
    if ($updates_submitted > 0) {
        echo json_encode(['success' => true, 'message' => "{$updates_submitted} modification(s) soumise(s) pour validation"]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Aucune modification à soumettre']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la soumission des modifications']);
}
?>