<?php
if (!isset($_SESSION['user_id'])) {
    header('Location: /login');
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $db->prepare("SELECT fm.* FROM family_members fm WHERE fm.family_site_id = ? AND fm.user_id = ?");
$stmt->execute([$family_id, $user_id]);
$current_member = $stmt->fetch();

if (!$current_member) {
    session_destroy();
    header('Location: /login?error=not_member');
    exit;
}

$is_admin = ($current_member['role'] === 'admin');
$current_user = null;

if ($user_id) {
    $stmt = $db->prepare("SELECT id, username, email FROM utilisateurs WHERE id = ?");
    $stmt->execute([$user_id]);
    $current_user = $stmt->fetch();
}