<?php
session_start();

if (isset($_SESSION['merchant_id'])) {
    header('Location: ../dashboard/index.php');
    exit();
}

require_once '../config/db_comm.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $code = trim($_POST['code'] ?? '');
    
    if (strlen($code) === 8) {
        $stmt = $pdo_comm->prepare("SELECT id, shop_ids FROM merchants WHERE code_access = ? AND is_active = 1");
        $stmt->execute([$code]);
        $merchant = $stmt->fetch();
        
        if ($merchant) {
            $_SESSION['merchant_id'] = $merchant['id'];
            $_SESSION['merchant_code'] = $code;
            $_SESSION['shop_ids'] = $merchant['shop_ids'];
            header('Location: ../dashboard/index.php');
            exit();
        } else {
            $error = 'Code d\'accès invalide';
        }
    } else {
        $error = 'Le code doit contenir 8 caractères';
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comm Access - Connexion</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body class="min-h-screen flex items-center justify-center bg-white dark:bg-black text-black dark:text-white font-light transition-colors duration-300">
    <div class="w-full max-w-md p-8">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-light mb-2">Comm Access</h1>
            <p class="text-gray-600 dark:text-gray-400">Connectez-vous avec votre code d'accès</p>
        </div>
        
        <form method="POST" class="space-y-6">
            <div>
                <input 
                    type="text" 
                    name="code" 
                    placeholder="Code d'accès (8 caractères)"
                    maxlength="8"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black text-black dark:text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-400 transition-all"
                    required
                    autocomplete="off"
                >
            </div>
            
            <?php if ($error): ?>
                <div class="text-red-500 text-sm text-center"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <button 
                type="submit" 
                class="w-full py-3 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors font-light"
            >
                Se connecter
            </button>
        </form>
        
        <div class="mt-8 text-center text-xs text-gray-500 dark:text-gray-400">
            <p>© 2025 aktascorp. Tous droits réservés.</p>
            <a href="https://aktascorp.com/privacy" class="hover:underline">Politique de confidentialité</a>
        </div>
    </div>
</body>
</html>