<!doctype html>
<html lang="fr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<script src="https://cdn.tailwindcss.com"></script>
<title>AWPO Calculator</title>
</head>
<body class="bg-[#000080] min-h-screen flex items-center justify-center font-sans">
  <div class="w-[420px] border-2 border-[#000080] shadow-[5px_5px_0_rgba(64,64,64,1)] bg-[#ECE9D8]">
    <div class="bg-gradient-to-r from-[#000080] to-[#0000CD] text-white px-3 py-2 font-bold select-none flex items-center gap-3">
      <img src="cube.png" alt="" class="w-8 h-8 border border-gray-400 bg-white">
      <div>AWPO Calculator</div>
      <div class="ml-auto text-xs opacity-90">v1.0</div>
    </div>

    <div class="p-4">
      <div class="bg-white border border-gray-300 rounded px-3 py-2 mb-3">
        <div id="display" class="text-right text-2xl font-mono min-h-[44px] break-words select-none">0</div>
      </div>

      <div class="grid grid-cols-4 gap-2">
        <button class="calc-btn py-2 bg-[#E1E1E1] border border-gray-400 rounded text-sm" data-action="clear">C</button>
        <button class="calc-btn py-2 bg-[#E1E1E1] border border-gray-400 rounded text-sm" data-action="neg">±</button>
        <button class="calc-btn py-2 bg-[#E1E1E1] border border-gray-400 rounded text-sm" data-action="pct">%</button>
        <button class="calc-btn py-2 bg-[#FFD39B] border border-gray-400 rounded text-sm" data-value="/">÷</button>

        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="7">7</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="8">8</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="9">9</button>
        <button class="calc-btn py-2 bg-[#FFD39B] border border-gray-400 rounded text-sm" data-value="*">×</button>

        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="4">4</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="5">5</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="6">6</button>
        <button class="calc-btn py-2 bg-[#FFD39B] border border-gray-400 rounded text-sm" data-value="-">−</button>

        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="1">1</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="2">2</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value="3">3</button>
        <button class="calc-btn py-2 bg-[#FFD39B] border border-gray-400 rounded text-sm" data-value="+">+</button>

        <button class="calc-btn col-span-2 py-2 bg-white border border-gray-300 rounded text-lg" data-value="0">0</button>
        <button class="calc-btn py-2 bg-white border border-gray-300 rounded text-lg" data-value=".">.</button>
        <button id="equals" class="py-2 bg-[#E1E1E1] border border-gray-400 rounded text-lg">=</button>
      </div>
    </div>

    <div class="bg-[#D4D0C8] px-3 py-2 text-right text-xs">
      AWPO Calculator — usage local
    </div>
  </div>

<script>
const displayEl = document.getElementById('display');
let current = '';
let lastResult = null;

function updateDisplay(v){
  displayEl.textContent = v === '' ? '0' : v;
}

function safeEval(expr){
  if(!/^[0-9+\-*/(). %]+$/.test(expr)) throw 0;
  return Function('"use strict";return ('+expr.replace(/×/g,'*').replace(/÷/g,'/')+')')();
}

document.querySelectorAll('.calc-btn').forEach(btn=>{
  btn.addEventListener('click', ()=>{
    const val = btn.getAttribute('data-value');
    const action = btn.getAttribute('data-action');
    if(action === 'clear'){
      current = '';
      lastResult = null;
      updateDisplay('');
      return;
    }
    if(action === 'neg'){
      if(current === '' && lastResult !== null) current = String(-lastResult);
      else if(current) current = (current.startsWith('-') ? current.slice(1) : '-'+current);
      updateDisplay(current);
      return;
    }
    if(action === 'pct'){
      try{
        const v = safeEval(current || String(lastResult || 0));
        current = String(v/100);
        updateDisplay(current);
      }catch{ current = ''; updateDisplay('0'); }
      return;
    }
    if(val){
      if(val === '.' && current.includes('.')) return;
      current += val;
      updateDisplay(current);
    }
  });
});

document.getElementById('equals').addEventListener('click', ()=>{
  if(current === '' && lastResult === null) return;
  const expr = current === '' ? String(lastResult) : current;
  try{
    const rng = Math.random();
    if(rng < 0.01){
      displayEl.textContent = 'I see the sun';
      current = '';
      lastResult = null;
      return;
    }
    const res = safeEval(expr);
    const out = (Number.isFinite(res) && Math.abs(res) > 1e12) ? res.toExponential(6) : Math.round((res + Number.EPSILON) * 1e12)/1e12;
    lastResult = out;
    current = '';
    updateDisplay(String(out));
  }catch{
    displayEl.textContent = 'Error';
    current = '';
    lastResult = null;
  }
});

window.addEventListener('keydown', (e)=>{
  if((e.key >= '0' && e.key <= '9') || ['+','-','*','/','.','(',')','%'].includes(e.key)){
    current += e.key;
    updateDisplay(current);
    e.preventDefault();
    return;
  }
  if(e.key === 'Enter') { document.getElementById('equals').click(); e.preventDefault(); return; }
  if(e.key === 'Backspace'){ current = current.slice(0,-1); updateDisplay(current); e.preventDefault(); return; }
  if(e.key.toLowerCase() === 'c'){ current = ''; lastResult = null; updateDisplay(''); e.preventDefault(); return; }
});
</script>
</body>
</html>
