<?php
session_start();
include 'includes/mobile_error.php';

if (!isset($_SESSION['game_state'])) {
    $_SESSION['game_state'] = [
        'score' => 0,
        'filesProcessed' => 0,
        'spamsCaught' => 0,
        'errors' => 0,
        'notes' => '',
        'settings' => [
            'sound' => true,
            'notifications' => true
        ]
    ];
}

if (isset($_GET['app'])) {
    $app = $_GET['app'];
    $includePath = 'includes/' . $app . '.php';
    
    if (file_exists($includePath)) {
        include $includePath;
    } else {       
        include 'includes/error.php';
    }
    exit;
}
?>

<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AWPO - A Web Paranormal Office</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Tahoma&display=swap');

    * {
        font-family: 'Tahoma', sans-serif;
        font-size: 11px;
        user-select: none;
        cursor: default;
    }
    
    body {
        margin: 0;
        padding: 0;
        overflow: hidden;
        background: #008080;
    }
    
    .xp-window {
        position: absolute;
        background: #ECE9D8;
        border: 2px solid #0054E3;
        border-radius: 8px 8px 0 0;
        box-shadow: 2px 2px 5px rgba(0,0,0,0.3);
        display: none;
    }
    
    .xp-window.active {
        display: block;
    }
    
    .xp-titlebar {
        background: linear-gradient(to right, #0054E3, #4B9BFF);
        color: white;
        padding: 3px;
        border-radius: 6px 6px 0 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: move;
    }
    
    .xp-button {
        background: #ECE9D8;
        border: 1px solid #003C74;
        border-radius: 3px;
        padding: 1px 3px;
        margin: 0 1px;
        cursor: pointer;
        color: black;
        font-weight: bold;
        width: 20px;
        height: 20px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    .xp-button:hover {
        background: #FFC73C;
    }
    
    .xp-close {
        background: #E51400;
        color: white;
    }
    
    .desktop-icon {
        position: absolute;
        width: 80px;
        height: 90px;
        text-align: center;
        cursor: pointer;
        padding: 5px;
    }
    
    .desktop-icon:hover {
        background: rgba(10, 36, 106, 0.3);
        border: 1px dotted #fff;
    }
    
    .icon-image {
        width: 48px;
        height: 48px;
        margin: 0 auto 5px;
        background: #fff;
        border: 1px solid #000;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
    }
    
    .taskbar {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        height: 30px;
        background: linear-gradient(to bottom, #3169C6, #2559B1);
        border-top: 1px solid #4B9BFF;
        display: flex;
        align-items: center;
        z-index: 9999;
    }
    
    .start-button {
        background: linear-gradient(to bottom, #5AAC5A, #358B35);
        color: white;
        padding: 2px 15px;
        margin: 2px;
        border: 1px solid #000;
        border-radius: 3px;
        cursor: pointer;
        font-weight: bold;
    }
    
    .glitch {
        animation: glitch 0.3s infinite;
    }
    
    @keyframes glitch {
        0% { transform: translate(0); }
        20% { transform: translate(-2px, 2px); }
        40% { transform: translate(-2px, -2px); }
        60% { transform: translate(2px, 2px); }
        80% { transform: translate(2px, -2px); }
        100% { transform: translate(0); }
    }
    
    .boot-screen {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: #000;
        color: #fff;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        z-index: 10000;
    }
    
    .progress-bar {
        width: 300px;
        height: 20px;
        border: 1px solid #fff;
        margin-top: 20px;
    }
    
    .progress-fill {
        height: 100%;
        background: #fff;
        width: 0%;
        transition: width 0.1s;
    }
    
    .notification {
        position: fixed;
        top: 40px;
        right: 10px;
        background: #FFFFCC;
        border: 2px solid #000;
        padding: 10px;
        max-width: 300px;
        box-shadow: 2px 2px 5px rgba(0,0,0,0.5);
        z-index: 9998;
    }
    
    .error-screen {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: #0000AA;
        color: white;
        padding: 20px;
        font-family: 'Courier New', monospace;
        z-index: 10001;
        display: none;
    }
    
    #startMenuContainer {
        position: fixed;
        bottom: 30px;
        left: 0;
        z-index: 10000;
    }
</style>

</head>
<body>
    <audio id="bgMusic" loop>
        <source src="music.mp3" type="audio/mpeg">
    </audio>

<audio id="errorSound" preload="auto">
    <source src="data:audio/wav;base64,UklGRiQAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQAAAAA=" type="audio/wav">
</audio>

<div id="warningPopup" class="xp-window active" style="top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 10002; width: 420px; font-family: Tahoma, Geneva, sans-serif; border: 2px solid #000080; background: #ECE9D8; box-shadow: 5px 5px 0 #404040;">
    <div style="background: linear-gradient(to right, #000080, #0000CD); color: white; padding: 5px 10px; font-weight: bold; font-size: 14px; user-select: none;">
        AWPO OS - Avertissement
    </div>
    <div style="display: flex; gap: 15px; padding: 15px; align-items: flex-start;">
        <div style="flex: 1; font-size: 12px; line-height: 1.4em;">
            <pre style="font-size: 14px; margin: 0 0 10px 0; font-family: 'Courier New', monospace; white-space: pre;">
 █████╗ ██╗    ██╗██████╗  ██████╗ 
██╔══██╗██║    ██║██╔══██╗██╔═══██╗
███████║██║ █╗ ██║██████╔╝██║   ██║
██╔══██║██║███╗██║██╔═══╝ ██║   ██║
██║  ██║╚███╔███╔╝██║     ╚██████╔╝
╚═╝  ╚═╝ ╚══╝╚══╝ ╚═╝      ╚═════╝         
            </pre>
            Vous êtes sur le point d'accéder à AWPO OS, un système créé par ParanSysems.  
            La dernière mise à jour a eu lieu en Avril 1989.<br><br>
            L'expérience utilisateur peut donc contenir des éléments perturbants, des sons inattendus et des comportements système anormaux dus au manque de mise à jour depuis cette date.<br><br>
            Votre progression sera automatiquement sauvegardée.<br><br>
            Continuez à vos risques et périls.
        </div>
    </div>
    <div style="display: flex; justify-content: flex-end; padding: 10px; background: #D4D0C8;">
        <button onclick="acceptWarning()" style="padding: 3px 15px; background: #E1E1E1; border: 1px solid #808080; font-size: 12px; cursor: pointer;">
            J'accepte
        </button>
    </div>
</div>


<div id="bootScreen" class="boot-screen" style="display: none;">
    <div style="font-family: 'Courier New', monospace;">
        <p>AWPO OS v1.0.0</p>
        <p>Loading paranormal drivers...</p>
        <p>Connected to the ParanSystems...</p>
        <p id="bootText">Initializing...</p>
    </div>
    <div class="progress-bar">
        <div id="bootProgress" class="progress-fill"></div>
    </div>
</div>

<div id="errorScreen" class="error-screen">
    <pre>

A problem has been detected and AWPO has been shut down to prevent damage
to your computer.

PARANORMALSYSTEMS_EXCEPTION_NOT_HANDLED

Technical information:

*** STOP: 0x0000666 (0xDEADBEEF, 0xC0FFEE, 0xBADC0DE, 0x1337)

Beginning dump of paranormal memory…
Physical memory dump complete.

The system will restart in 5 seconds…
</pre>
</div>

<div id="desktop" style="display: none; width: 100%; height: calc(100vh - 30px); background: #008080;">
    
    <div class="desktop-icon" style="top: 10px; left: 10px;" ondblclick="openApp('mail')">
        <div class="icon-image">📧</div>
        <div style="color: white; text-shadow: 1px 1px 2px black;">Mail</div>
    </div>
    
    <div class="desktop-icon" style="top: 10px; left: 100px;" ondblclick="openApp('messages')">
        <div class="icon-image">💬</div>
        <div style="color: white; text-shadow: 1px 1px 2px black;">Messages</div>
    </div>
    
    <div class="desktop-icon" style="top: 10px; left: 190px;" ondblclick="openApp('notes')">
        <div class="icon-image">📝</div>
        <div style="color: white; text-shadow: 1px 1px 2px black;">Notes</div>
    </div>
    
    <div class="desktop-icon" style="top: 110px; left: 10px;" ondblclick="openApp('settings')">
        <div class="icon-image">⚙️</div>
        <div style="color: white; text-shadow: 1px 1px 2px black;">Paramètres</div>
    </div>
    
    <div class="desktop-icon" style="top: 110px; left: 100px;" ondblclick="openApp('antivirus')">
        <div class="icon-image">🛡️</div>
        <div style="color: white; text-shadow: 1px 1px 2px black;">Anti-Virus</div>
    </div>
    
    
</div>

<div id="taskbar" class="taskbar" style="display: none;">
    <button class="start-button" onclick="toggleStartMenu()">Navigation</button>
    <div style="flex: 1;"></div>
    <div style="color: white; padding: 0 10px;">
        <span id="clock">00:00</span>
    </div>
</div>

<div id="startMenuContainer"></div>
<div id="notificationContainer"></div>

<script>
    let gameState = <?php echo json_encode($_SESSION['game_state']); ?>;
    let windowZIndex = 1000;
    let openWindows = {};

    function loadStartMenu() {
        fetch('index.php?app=start_menu')
            .then(response => response.text())
            .then(html => {
                document.getElementById('startMenuContainer').innerHTML = html;
                const scripts = document.getElementById('startMenuContainer').getElementsByTagName('script');
                for (let script of scripts) {
                    eval(script.innerHTML);
                }
            });
    }

    function acceptWarning() {
        document.getElementById('warningPopup').classList.remove('active');
        document.getElementById('bootScreen').style.display = 'flex';
        startBoot();
    }

    function startBoot() {
        let progress = 0;
        const bootMessages = [
            "Loading paranormal drivers...",
            "Checking reality stability...",
            "Initializing quantum processors...",
            "Connecting to AWPO servers...",
            "Loading user profile...",
            "Restoring session...",
            "Starting desktop environment..."
        ];
        
        let messageIndex = 0;
        const bootInterval = setInterval(() => {
            progress += Math.random() * 15;
            if (progress > 100) progress = 100;
            
            document.getElementById('bootProgress').style.width = progress + '%';
            
            if (messageIndex < bootMessages.length) {
                document.getElementById('bootText').textContent = bootMessages[messageIndex];
                messageIndex++;
            }
            
            if (progress >= 100) {
                clearInterval(bootInterval);
                setTimeout(() => {
                    document.getElementById('bootScreen').style.display = 'none';
                    document.getElementById('desktop').style.display = 'block';
                    document.getElementById('taskbar').style.display = 'flex';
                    startDesktop();
                }, 500);
            }
        }, 300);
    }

    function startDesktop() {
        loadStartMenu();
        updateClock();
        setInterval(updateClock, 1000);
        setInterval(saveGame, 5000);
        setInterval(randomGlitch, 30000 + Math.random() * 60000);
        
        const bgMusic = document.getElementById('bgMusic');
        bgMusic.volume = 0.3;
        bgMusic.play().catch(e => console.log('Autoplay blocked'));
    }

    function updateClock() {
        const now = new Date();
        document.getElementById('clock').textContent = 
            now.getHours().toString().padStart(2, '0') + ':' + 
            now.getMinutes().toString().padStart(2, '0');
    }

    function randomGlitch() {
        if (Math.random() < 0.1) {
            document.body.classList.add('glitch');
            const bgMusic = document.getElementById('bgMusic');
            bgMusic.playbackRate = Math.random() * 0.5 + 0.5;
            
            setTimeout(() => {
                document.body.classList.remove('glitch');
                bgMusic.playbackRate = 1;
            }, 300);
        }
    }

    function saveGame() {
        const formData = new FormData();
        formData.append('action', 'save');
        formData.append('gameState', JSON.stringify(gameState));
        
        fetch('save_game.php', {
            method: 'POST',
            body: formData
        });
    }

    function showNotification(title, message, type = 'info') {
        if (!gameState.settings.notifications) return;
        
        const notification = document.createElement('div');
        notification.className = 'notification';
        notification.innerHTML = `
            <div style="font-weight: bold; margin-bottom: 5px;">${title}</div>
            <div>${message}</div>
            <button onclick="this.parentElement.remove()" style="margin-top: 5px; float: right;">OK</button>
        `;
        
        document.getElementById('notificationContainer').appendChild(notification);
        
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    function systemCrash() {
        document.getElementById('errorSound').play();
        document.getElementById('errorScreen').style.display = 'block';
        
        setTimeout(() => {
            document.getElementById('errorScreen').style.display = 'none';
            document.getElementById('bootScreen').style.display = 'flex';
            startBoot();
        }, 5000);
    }

    function openApp(appName) {
        if (openWindows[appName]) {
            const existingWindow = document.getElementById(openWindows[appName]);
            if (existingWindow) {
                existingWindow.style.zIndex = ++windowZIndex;
                return;
            }
        }
        
        const windowId = 'window-' + Date.now();
        openWindows[appName] = windowId;
        
        const appWindow = document.createElement('div');
        appWindow.id = windowId;
        appWindow.className = 'xp-window active';
        appWindow.style.cssText = `top: ${50 + Object.keys(openWindows).length * 20}px; 
                                   left: ${50 + Object.keys(openWindows).length * 20}px; 
                                   width: 700px; 
                                   height: 500px; 
                                   z-index: ${++windowZIndex};`;
        
        appWindow.innerHTML = `
            <div class="xp-titlebar" onmousedown="startDrag(event, '${windowId}')">
                <span>${appName.charAt(0).toUpperCase() + appName.slice(1)}</span>
                <div>
                    <button class="xp-button" onclick="minimizeWindow('${windowId}')">_</button>
                    <button class="xp-button" onclick="maximizeWindow('${windowId}')">□</button>
                    <button class="xp-button xp-close" onclick="closeWindow('${windowId}', '${appName}')">X</button>
                </div>
            </div>
            <div id="${windowId}-content" style="padding: 0; height: calc(100% - 30px); overflow: auto; background: white;">
                <div style="padding: 20px; text-align: center;">
                    <img src="data:image/gif;base64,R0lGODlhEAAQAPIAAAAAADMzM2ZmZpmZmczMzP///wAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAEAAQAAADMwi63P4wyklrE2MIOggZnAdOmGYJRbExwroUmcG2LmDEwnHQLVsYOd2mBzkYDAdKa+dIAAAh+QQJCgAAACwAAAAAEAAQAAADNAi63P5OjCEgG4QMu7DmikRxQlFUYDEZIGBMRVsaqHwctXXf7WEYB4Ag1xjihkMZsiUkKhIAIfkECQoAAAAsAAAAABAAEAAAAzYIujIjK8pByJDMlFYvBoVjHA70GU7xSUJhmKtwHPAKzLO9HMaoKwJZ7Rf8AYPDDzKpZBqfvwQAIfkECQoAAAAsAAAAABAAEAAAAzMIumIlK8oyhpHsnFZfhYumCYUhDAQxRIdhHBGqRoKw0R8DYlJd8z0fMDgsGo/IpHI5TAAAIfkECQoAAAAsAAAAABAAEAAAAzIIunInK0rnZBTwGPNMgQwmdsNgXGJUlIWEuR5oWUIpz8pAEAMe6TwfwyYsGo/IpFKSAAAh+QQJCgAAACwAAAAAEAAQAAADMwi6IMKQORfjdOe82p4wGccc4CEuQradylesojEMBgsUc2G7sDX3lQGBMLAJibufbSlKAAAh+QQJCgAAACwAAAAAEAAQAAADMgi63P7wCRHZnFVdmgHu2nFwlWCI3WGc3TSWhUFGxTAUkGCbtgENBMJAEJsxgMLWzpEAACH5BAkKAAAALAAAAAAQABAAAAMyCLrc/jDKSatlQtScKdceCAjDII7HcQ4EMTCpyrCuUBjCYRgHVtqlAiB1YhiCnlsRkAAAOwAAAAAAAAAAAA==" />
                    <p>Chargement de ${appName}...</p>
                </div>
            </div>
        `;
        
        document.body.appendChild(appWindow);
        
        fetch(`index.php?app=${appName}`)
            .then(response => response.text())
            .then(html => {
                document.getElementById(`${windowId}-content`).innerHTML = html;
                
                const scripts = document.getElementById(`${windowId}-content`).getElementsByTagName('script');
                for (let script of scripts) {
                    eval(script.innerHTML);
                }
            })
            .catch(error => {
                document.getElementById(`${windowId}-content`).innerHTML = `
                    <div style="padding: 20px; color: red;">
                        Erreur lors du chargement de l'application: ${error}
                    </div>
                `;
            });
    }

    function closeWindow(windowId, appName) {
        document.getElementById(windowId).remove();
        delete openWindows[appName];
    }

    function minimizeWindow(windowId) {
        const window = document.getElementById(windowId);
        window.style.display = window.style.display === 'none' ? 'block' : 'none';
    }

    function maximizeWindow(windowId) {
        const window = document.getElementById(windowId);
        if (window.dataset.maximized === 'true') {
            window.style.top = window.dataset.oldTop;
            window.style.left = window.dataset.oldLeft;
            window.style.width = window.dataset.oldWidth;
            window.style.height = window.dataset.oldHeight;
            window.dataset.maximized = 'false';
        } else {
            window.dataset.oldTop = window.style.top;
            window.dataset.oldLeft = window.style.left;
            window.dataset.oldWidth = window.style.width;
            window.dataset.oldHeight = window.style.height;
            
            window.style.top = '0';
            window.style.left = '0';
            window.style.width = '100%';
            window.style.height = 'calc(100% - 30px)';
            window.dataset.maximized = 'true';
        }
    }

    let draggedWindow = null;
    let dragOffset = { x: 0, y: 0 };

    function startDrag(event, windowId) {
        draggedWindow = document.getElementById(windowId);
        draggedWindow.style.zIndex = ++windowZIndex;
        dragOffset.x = event.clientX - draggedWindow.offsetLeft;
        dragOffset.y = event.clientY - draggedWindow.offsetTop;
        
        document.addEventListener('mousemove', dragWindow);
        document.addEventListener('mouseup', stopDrag);
    }

    function dragWindow(event) {
        if (draggedWindow) {
            draggedWindow.style.left = (event.clientX - dragOffset.x) + 'px';
            draggedWindow.style.top = (event.clientY - dragOffset.y) + 'px';
        }
    }

    function stopDrag() {
        draggedWindow = null;
        document.removeEventListener('mousemove', dragWindow);
        document.removeEventListener('mouseup', stopDrag);
    }

    function toggleStartMenu() {
        if (typeof window.toggleStartMenu === 'function') {
            window.toggleStartMenu();
        } else {
            showNotification("Menu Démarrer", "Chargement...", "info");
            loadStartMenu();
        }
    }

    window.addEventListener('beforeunload', (e) => {
        saveGame();
    });
</script>

</body>
</html>