<?php
session_start();

if (!isset($_SESSION['settings'])) {
    $_SESSION['settings'] = [
        'display' => [
            'resolution' => '1024x768',
            'colors' => '32bit',
            'refresh' => '60Hz',
            'theme' => 'classic'
        ],
        'sound' => [
            'master' => 75,
            'effects' => 80,
            'music' => 50,
            'notifications' => 100,
            'mute' => false
        ],
        'system' => [
            'autosave' => true,
            'autosave_interval' => 5,
            'startup_sound' => true,
            'animations' => true,
            'tooltips' => true,
            'language' => 'fr'
        ],
        'security' => [
            'paranormal_detection' => true,
            'reality_check' => true,
            'glitch_protection' => false,
            'max_crashes' => 3
        ],
        'performance' => [
            'cpu_limit' => 80,
            'ram_usage' => 'normal',
            'cache_size' => 256
        ],
        'network' => [
            'proxy' => false,
            'proxy_address' => '',
            'auto_update' => true,
            'connection_type' => 'broadband'
        ]
    ];
}

if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch($_POST['action']) {
        case 'save':
            $category = $_POST['category'];
            $setting = $_POST['setting'];
            $value = $_POST['value'];
            
            $_SESSION['settings'][$category][$setting] = $value;
            echo json_encode(['success' => true]);
            exit;
            
        case 'reset':
            session_destroy();
            echo json_encode(['success' => true]);
            exit;
            
        case 'apply':
            echo json_encode(['success' => true, 'message' => 'Paramètres appliqués']);
            exit;
    }
}
?>

<div style="height: 100%; display: flex; flex-direction: column; background: #ECE9D8;">
    
    <div style="background: white; border-bottom: 2px solid #919B9C; padding: 10px;">
        <div style="display: flex; align-items: center;">
            <span style="font-size: 24px; margin-right: 10px;">⚙️</span>
            <div>
                <div style="font-size: 16px; font-weight: bold;">Panneau de configuration</div>
                <div style="font-size: 11px; color: #666;">Système AWPO v1.0.666</div>
            </div>
        </div>
    </div>
    
    <div style="flex: 1; display: flex;">
        
        <div style="width: 180px; background: white; border-right: 1px solid #919B9C;">
            <div style="background: #F0F0F0; padding: 5px; font-weight: bold; font-size: 11px; border-bottom: 1px solid #919B9C;">
                Catégories
            </div>
            
            <div class="settings-menu-item" onclick="showSettingsTab('display')" data-tab="display">
                <span style="font-size: 16px;">🖥️</span> Affichage
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('sound')" data-tab="sound">
                <span style="font-size: 16px;">🔊</span> Sons
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('system')" data-tab="system">
                <span style="font-size: 16px;">💻</span> Système
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('security')" data-tab="security">
                <span style="font-size: 16px;">🔒</span> Sécurité
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('performance')" data-tab="performance">
                <span style="font-size: 16px;">⚡</span> Performances
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('network')" data-tab="network">
                <span style="font-size: 16px;">🌐</span> Réseau
            </div>
            <div class="settings-menu-item" onclick="showSettingsTab('about')" data-tab="about">
                <span style="font-size: 16px;">ℹ️</span> À propos
            </div>
        </div>
        
        <div style="flex: 1; padding: 15px; overflow-y: auto;">
            
            <div id="settings-display" class="settings-panel">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Paramètres d'affichage</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Résolution d'écran</div>
                    <div class="settings-group-content">
                        <select id="resolution" onchange="saveSetting('display', 'resolution', this.value)" style="width: 150px; padding: 2px;">
                            <option value="800x600" <?= $_SESSION['settings']['display']['resolution'] == '800x600' ? 'selected' : '' ?>>800 x 600</option>
                            <option value="1024x768" <?= $_SESSION['settings']['display']['resolution'] == '1024x768' ? 'selected' : '' ?>>1024 x 768</option>
                            <option value="1280x1024" <?= $_SESSION['settings']['display']['resolution'] == '1280x1024' ? 'selected' : '' ?>>1280 x 1024</option>
                            <option value="1920x1080" <?= $_SESSION['settings']['display']['resolution'] == '1920x1080' ? 'selected' : '' ?>>1920 x 1080</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            <label>Qualité des couleurs:</label>
                            <select onchange="saveSetting('display', 'colors', this.value)" style="width: 150px; padding: 2px;">
                                <option value="16bit" <?= $_SESSION['settings']['display']['colors'] == '16bit' ? 'selected' : '' ?>>Moyenne (16 bits)</option>
                                <option value="32bit" <?= $_SESSION['settings']['display']['colors'] == '32bit' ? 'selected' : '' ?>>Optimale (32 bits)</option>
                            </select>
                        </div>
                        
                        <div style="margin-top: 10px;">
                            <label>Fréquence de rafraîchissement:</label>
                            <select onchange="saveSetting('display', 'refresh', this.value)" style="width: 150px; padding: 2px;">
                                <option value="60Hz" <?= $_SESSION['settings']['display']['refresh'] == '60Hz' ? 'selected' : '' ?>>60 Hz</option>
                                <option value="75Hz" <?= $_SESSION['settings']['display']['refresh'] == '75Hz' ? 'selected' : '' ?>>75 Hz</option>
                                <option value="85Hz" <?= $_SESSION['settings']['display']['refresh'] == '85Hz' ? 'selected' : '' ?>>85 Hz</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">Apparence</div>
                    <div class="settings-group-content">
                        <label>Thème:</label>
                        <select onchange="changeTheme(this.value)" style="width: 200px; padding: 2px;">
                            <option value="classic" <?= $_SESSION['settings']['display']['theme'] == 'classic' ? 'selected' : '' ?>>Windows classique</option>
                            <option value="xp" <?= $_SESSION['settings']['display']['theme'] == 'xp' ? 'selected' : '' ?>>Style XP (Luna)</option>
                            <option value="dark" <?= $_SESSION['settings']['display']['theme'] == 'dark' ? 'selected' : '' ?>>Mode sombre</option>
                            <option value="paranormal" <?= $_SESSION['settings']['display']['theme'] == 'paranormal' ? 'selected' : '' ?>>PARANORMAL</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            <button class="settings-button" onclick="testDisplay()">Tester l'affichage</button>
                            <button class="settings-button" onclick="calibrateScreen()">Calibrer l'écran</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-sound" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Paramètres audio</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Volume</div>
                    <div class="settings-group-content">
                        <div class="volume-control">
                            <label>Volume principal:</label>
                            <input type="range" min="0" max="100" value="<?= $_SESSION['settings']['sound']['master'] ?>" 
                                   onchange="updateVolume('master', this.value)" style="width: 200px;">
                            <span id="volume-master"><?= $_SESSION['settings']['sound']['master'] ?>%</span>
                        </div>
                        
                        <div class="volume-control">
                            <label>Effets sonores:</label>
                            <input type="range" min="0" max="100" value="<?= $_SESSION['settings']['sound']['effects'] ?>" 
                                   onchange="updateVolume('effects', this.value)" style="width: 200px;">
                            <span id="volume-effects"><?= $_SESSION['settings']['sound']['effects'] ?>%</span>
                        </div>
                        
                        <div class="volume-control">
                            <label>Musique:</label>
                            <input type="range" min="0" max="100" value="<?= $_SESSION['settings']['sound']['music'] ?>" 
                                   onchange="updateVolume('music', this.value)" style="width: 200px;">
                            <span id="volume-music"><?= $_SESSION['settings']['sound']['music'] ?>%</span>
                        </div>
                        
                        <div class="volume-control">
                            <label>Notifications:</label>
                            <input type="range" min="0" max="100" value="<?= $_SESSION['settings']['sound']['notifications'] ?>" 
                                   onchange="updateVolume('notifications', this.value)" style="width: 200px;">
                            <span id="volume-notifications"><?= $_SESSION['settings']['sound']['notifications'] ?>%</span>
                        </div>
                        
                        <div style="margin-top: 15px;">
                            <label>
                                <input type="checkbox" <?= $_SESSION['settings']['sound']['mute'] ? 'checked' : '' ?> 
                                       onchange="toggleMute(this.checked)">
                                Couper tous les sons
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">Périphérique audio</div>
                    <div class="settings-group-content">
                        <select style="width: 250px; padding: 2px;">
                            <option>Realtek HD Audio (Par défaut)</option>
                            <option>Haut-parleurs USB</option>
                            <option>Casque Bluetooth</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            <button class="settings-button" onclick="testSound()">🔊 Tester le son</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-system" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Paramètres système</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Options générales</div>
                    <div class="settings-group-content">
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['system']['autosave'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('system', 'autosave', this.checked)">
                            Sauvegarde automatique
                        </label>
                        
                        <div style="margin-left: 20px; margin-bottom: 10px;">
                            Intervalle: 
                            <select onchange="saveSetting('system', 'autosave_interval', this.value)" style="width: 100px;">
                                <option value="1" <?= $_SESSION['settings']['system']['autosave_interval'] == 1 ? 'selected' : '' ?>>1 minute</option>
                                <option value="5" <?= $_SESSION['settings']['system']['autosave_interval'] == 5 ? 'selected' : '' ?>>5 minutes</option>
                                <option value="10" <?= $_SESSION['settings']['system']['autosave_interval'] == 10 ? 'selected' : '' ?>>10 minutes</option>
                            </select>
                        </div>
                        
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['system']['startup_sound'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('system', 'startup_sound', this.checked)">
                            Son au démarrage
                        </label>
                        
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['system']['animations'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('system', 'animations', this.checked)">
                            Animations des fenêtres
                        </label>
                        
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['system']['tooltips'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('system', 'tooltips', this.checked)">
                            Afficher les info-bulles
                        </label>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">Langue et région</div>
                    <div class="settings-group-content">
                        <label>Langue du système:</label>
                        <select onchange="changeLanguage(this.value)" style="width: 150px; padding: 2px;">
                            <option value="fr" <?= $_SESSION['settings']['system']['language'] == 'fr' ? 'selected' : '' ?>>Français</option>
                            <option value="en">English</option>
                            <option value="de">Deutsch</option>
                            <option value="es">Español</option>
                            <option value="??">█████████</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            Format de date: <strong>JJ/MM/AAAA</strong><br>
                            Format d'heure: <strong>24 heures</strong>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-security" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Paramètres de sécurité</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Protection paranormale</div>
                    <div class="settings-group-content">
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['security']['paranormal_detection'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('security', 'paranormal_detection', this.checked)">
                            Détection d'activité paranormale
                        </label>
                        
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['security']['reality_check'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('security', 'reality_check', this.checked)">
                            Vérification de la réalité
                        </label>
                        
                        <label style="display: block; margin: 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['security']['glitch_protection'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('security', 'glitch_protection', this.checked)">
                            Protection contre les glitchs
                        </label>
                        
                        <div style="margin-top: 10px; padding: 10px; background: #FFFFCC; border: 1px solid #CCCC00;">
                            <strong>⚠️ Avertissement:</strong><br>
                            Désactiver ces protections peut exposer votre système à des anomalies dimensionnelles.
                        </div>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">Limites de sécurité</div>
                    <div class="settings-group-content">
                        <label>Nombre maximum de crashs autorisés:</label>
                        <select onchange="saveSetting('security', 'max_crashes', this.value)" style="width: 100px;">
                            <option value="1" <?= $_SESSION['settings']['security']['max_crashes'] == 1 ? 'selected' : '' ?>>1</option>
                            <option value="3" <?= $_SESSION['settings']['security']['max_crashes'] == 3 ? 'selected' : '' ?>>3</option>
                            <option value="5" <?= $_SESSION['settings']['security']['max_crashes'] == 5 ? 'selected' : '' ?>>5</option>
                            <option value="999">Illimité</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            <button class="settings-button" onclick="runSecurityScan()">🔍 Analyser la sécurité</button>
                            <button class="settings-button" onclick="resetSecurity()">🔄 Réinitialiser</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-performance" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Performances</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Utilisation des ressources</div>
                    <div class="settings-group-content">
                        <div style="margin-bottom: 10px;">
                            <label>Limite CPU:</label>
                            <input type="range" min="20" max="100" value="<?= $_SESSION['settings']['performance']['cpu_limit'] ?>" 
                                   onchange="updatePerformance('cpu_limit', this.value)" style="width: 200px;">
                            <span id="cpu-limit"><?= $_SESSION['settings']['performance']['cpu_limit'] ?>%</span>
                        </div>
                        
                        <div style="margin-bottom: 10px;">
                            <label>Utilisation RAM:</label>
                            <select onchange="saveSetting('performance', 'ram_usage', this.value)" style="width: 150px;">
                                <option value="low" <?= $_SESSION['settings']['performance']['ram_usage'] == 'low' ? 'selected' : '' ?>>Faible</option>
                                <option value="normal" <?= $_SESSION['settings']['performance']['ram_usage'] == 'normal' ? 'selected' : '' ?>>Normale</option>
                                <option value="high" <?= $_SESSION['settings']['performance']['ram_usage'] == 'high' ? 'selected' : '' ?>>Élevée</option>
                            </select>
                        </div>
                        
                        <div style="margin-bottom: 10px;">
                            <label>Taille du cache:</label>
                            <select onchange="saveSetting('performance', 'cache_size', this.value)" style="width: 150px;">
                                <option value="128" <?= $_SESSION['settings']['performance']['cache_size'] == 128 ? 'selected' : '' ?>>128 MB</option>
                                <option value="256" <?= $_SESSION['settings']['performance']['cache_size'] == 256 ? 'selected' : '' ?>>256 MB</option>
                                <option value="512" <?= $_SESSION['settings']['performance']['cache_size'] == 512 ? 'selected' : '' ?>>512 MB</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">Optimisation</div>
                    <div class="settings-group-content">
                        <button class="settings-button" onclick="optimizeSystem()">⚡ Optimiser maintenant</button>
                        <button class="settings-button" onclick="clearCache()">🗑️ Vider le cache</button>
                        <button class="settings-button" onclick="defragment()">💾 Défragmenter</button>
                        
                        <div id="performance-status" style="margin-top: 10px; padding: 10px; background: #F0F0F0; border: 1px solid #919B9C;">
                            État: <span style="color: green;">Système optimisé</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-network" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">Paramètres réseau</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Connexion</div>
                    <div class="settings-group-content">
                        <label>Type de connexion:</label>
                        <select onchange="saveSetting('network', 'connection_type', this.value)" style="width: 200px;">
                            <option value="dial-up" <?= $_SESSION['settings']['network']['connection_type'] == 'dial-up' ? 'selected' : '' ?>>Connexion 56K</option>
                            <option value="broadband" <?= $_SESSION['settings']['network']['connection_type'] == 'broadband' ? 'selected' : '' ?>>Haut débit</option>
                            <option value="fiber" <?= $_SESSION['settings']['network']['connection_type'] == 'fiber' ? 'selected' : '' ?>>Fibre optique</option>
                            <option value="paranormal">Connexion paranormale</option>
                        </select>
                        
                        <div style="margin-top: 10px;">
                            <label style="display: block; margin: 5px 0;">
                                <input type="checkbox" <?= $_SESSION['settings']['network']['proxy'] ? 'checked' : '' ?> 
                                       onchange="toggleProxy(this.checked)">
                                Utiliser un serveur proxy
                            </label>
                            
                            <div id="proxy-settings" style="margin-left: 20px; display: <?= $_SESSION['settings']['network']['proxy'] ? 'block' : 'none' ?>;">
                                Adresse: <input type="text" value="<?= $_SESSION['settings']['network']['proxy_address'] ?>" style="width: 150px;">
                                Port: <input type="text" value="8080" style="width: 60px;">
                            </div>
                        </div>
                        
                        <label style="display: block; margin: 10px 0 5px 0;">
                            <input type="checkbox" <?= $_SESSION['settings']['network']['auto_update'] ? 'checked' : '' ?> 
                                   onchange="saveSetting('network', 'auto_update', this.checked)">
                            Mises à jour automatiques
                        </label>
                    </div>
                </div>
                
                <div class="settings-group">
                    <div class="settings-group-title">État de la connexion</div>
                    <div class="settings-group-content">
                        <div>Adresse IP: <strong>192.168.1.<?= rand(2, 254) ?></strong></div>
                        <div>Passerelle: <strong>192.168.1.1</strong></div>
                        <div>DNS: <strong>8.8.8.8</strong></div>
                        <div>État: <span style="color: green;">Connecté</span></div>
                        
                        <div style="margin-top: 10px;">
                            <button class="settings-button" onclick="testConnection()">🌐 Tester la connexion</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="settings-about" class="settings-panel" style="display: none;">
                <h2 style="font-size: 18px; color: #003399; margin-bottom: 15px;">À propos</h2>
                
                <div class="settings-group">
                    <div class="settings-group-title">Informations système</div>
                    <div class="settings-group-content">
                        <div style="text-align: center; margin-bottom: 20px;">
                            <div style="font-size: 48px;">🖥️</div>
                            <h3>AWPO System</h3>
                            <p>A Web Paranormal Office, by ParanSystems. <a class="underline" href="https://paran.systems/addon-awpo">Ajouter de nouveau outil à Awpo via le forum.</a></p>
                        </div>
                        
                        <table style="width: 100%; font-size: 11px;">
                            <tr>
                                <td style="padding: 3px;">Version:</td>
                                <td><strong>1.0.666</strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Build:</td>
                                <td><strong>2024.12.17.PARANORMAL</strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Kernel:</td>
                                <td><strong>AWPO-NT 5.1.2600</strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Licence:</td>
                                <td><strong>NOTFOUND (Maybe a error? Eptor verification proceed)</strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Utilisateur:</td>
                                <td><strong>Agent_<?= rand(100, 999) ?></strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Mémoire:</td>
                                <td><strong><?= rand(256, 512) ?> MB RAM</strong></td>
                            </tr>
                            <tr>
                                <td style="padding: 3px;">Processeur:</td>
                                <td><strong>Intel Pentium 4 @ 3.0GHz</strong></td>
                            </tr>
                        </table>
                        
                        <div style="margin-top: 15px; padding: 10px; background: #F0F0F0; border: 1px solid #919B9C;">
                            <strong>Avertissement:</strong><br>
                            Ce système peut contenir des anomalies dimensionnelles.<br>
                            Utilisation à vos risques et périls.
                        </div>
                        
                        <div style="margin-top: 10px; text-align: center;">
                            <button class="settings-button" onclick="showCredits()">📜 Crédits</button>
                            <button class="settings-button" onclick="showLicense()">📄 Licence</button>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    
    <div style="background: #ECE9D8; border-top: 2px solid #919B9C; padding: 8px; display: flex; justify-content: flex-end;">
        <button class="settings-button-primary" onclick="applySettings()">Appliquer</button>
        <button class="settings-button" onclick="window.parent.closeWindow(window.frameElement.parentElement.id, 'settings')">Annuler</button>
        <button class="settings-button-primary" onclick="applyAndClose()">OK</button>
    </div>
</div>

<style>
.settings-menu-item {
    padding: 8px 10px;
    cursor: pointer;
    font-size: 11px;
    display: flex;
    align-items: center;
    gap: 8px;
    border-bottom: 1px solid #F0F0F0;
}

.settings-menu-item:hover {
    background: #316AC5;
    color: white;
}

.settings-menu-item.active {
    background: #E0E0E0;
    font-weight: bold;
}

.settings-panel {
    animation: fadeIn 0.3s;
}

.settings-group {
    background: white;
    border: 1px solid #919B9C;
    margin-bottom: 15px;
}

.settings-group-title {
    background: linear-gradient(to bottom, #F0F0F0, #E0E0E0);
    padding: 5px 10px;
    font-weight: bold;
    font-size: 11px;
    border-bottom: 1px solid #919B9C;
}

.settings-group-content {
    padding: 10px;
}

.settings-button {
    background: #ECE9D8;
    border: 1px solid #003C74;
    padding: 5px 10px;
    cursor: pointer;
    font-size: 11px;
    margin: 2px;
}

.settings-button:hover {
    background: #DDD6C1;
}

.settings-button-primary {
    background: #ECE9D8;
    border: 2px solid #003C74;
    padding: 5px 15px;
    cursor: pointer;
    font-size: 11px;
    font-weight: bold;
    margin: 0 2px;
}

.volume-control {
    margin: 10px 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.volume-control label {
    width: 120px;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
</style>

<script>
window.showSettingsTab = function(tabName) {
    document.querySelectorAll('.settings-panel').forEach(panel => {
        panel.style.display = 'none';
    });
    
    document.querySelectorAll('.settings-menu-item').forEach(item => {
        item.classList.remove('active');
    });
    
    document.getElementById('settings-' + tabName).style.display = 'block';
    document.querySelector(`[data-tab="${tabName}"]`).classList.add('active');
}

window.saveSetting = function(category, setting, value) {
    fetch('includes/settings.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `action=save&category=${category}&setting=${setting}&value=${value}`
    });
}

window.updateVolume = function(type, value) {
    document.getElementById('volume-' + type).textContent = value + '%';
    saveSetting('sound', type, value);
    
    if (type === 'master' && window.parent.document.getElementById('bgMusic')) {
        window.parent.document.getElementById('bgMusic').volume = value / 100;
    }
}

window.updatePerformance = function(type, value) {
    document.getElementById('cpu-limit').textContent = value + '%';
    saveSetting('performance', type, value);
}

window.toggleMute = function(muted) {
    saveSetting('sound', 'mute', muted);
    if (window.parent.document.getElementById('bgMusic')) {
        window.parent.document.getElementById('bgMusic').muted = muted;
    }
}

window.toggleProxy = function(enabled) {
    document.getElementById('proxy-settings').style.display = enabled ? 'block' : 'none';
    saveSetting('network', 'proxy', enabled);
}

window.changeTheme = function(theme) {
    saveSetting('display', 'theme', theme);
    
    if (theme === 'paranormal') {
        alert('Mode PARANORMAL activé!\n\nAttention: Des anomalies visuelles peuvent survenir.');
        document.body.style.animation = 'glitch 0.5s';
        setTimeout(() => {
            document.body.style.animation = '';
        }, 500);
    } else if (theme === 'dark') {
        document.body.style.background = '#1a1a1a';
        document.body.style.color = '#ffffff';
    }
}

window.changeLanguage = function(lang) {
    saveSetting('system', 'language', lang);
    
    if (lang === '??') {
        alert('L̸a̶n̷g̸u̶e̷ ̴i̶n̴c̵o̸n̶n̸u̴e̶ ̷s̴é̶l̶e̵c̷t̶i̸o̵n̴n̷é̶e̸');
        document.body.style.filter = 'hue-rotate(180deg)';
        setTimeout(() => {
            document.body.style.filter = '';
        }, 2000);
    }
}

window.testDisplay = function() {
    const testWindow = window.open('', 'Test', 'width=640,height=480');
    testWindow.document.write(`
        <html>
        <head><title>Test d'affichage</title></head>
        <body style="background: linear-gradient(45deg, #ff0000, #00ff00, #0000ff);">
            <h1>Test d'affichage AWPO</h1>
            <p>Résolution: ${document.getElementById('resolution').value}</p>
            <button onclick="window.close()">Fermer</button>
        </body>
        </html>
    `);
}

window.calibrateScreen = function() {
    alert('Calibrage de l\'écran...\n\nAjustez votre moniteur jusqu\'à ce que vous voyiez clairement tous les niveaux de gris.');
}

window.testSound = function() {
    const audio = new Audio('data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YQoGAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBjiR1/LMeSwFJHfH8N2QQAoUXrTp66hVFApGn+DyvmwhBSuBzvLZiTYIG2m98OScTgwOWK3m7blmFgU7k9n1unEiBC13yO/eizEIHWq+8+OWT');
    audio.play();
    
    setTimeout(() => {
        alert('Test audio terminé.\n\nSi vous n\'avez pas entendu de son, vérifiez vos haut-parleurs.');
    }, 500);
}

window.runSecurityScan = function() {
    const progress = document.createElement('div');
    progress.innerHTML = 'Analyse de sécurité en cours...';
    progress.style.cssText = 'position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; border: 2px solid #0054E3; padding: 20px; z-index: 10000;';
    document.body.appendChild(progress);
    
    setTimeout(() => {
        progress.remove();
        alert('Analyse terminée!\n\n✓ Aucune menace détectée\n⚠️ 1 anomalie paranormale détectée\n✓ Protections actives');
    }, 3000);
}

window.resetSecurity = function() {
    if (confirm('Réinitialiser tous les paramètres de sécurité?')) {
        saveSetting('security', 'paranormal_detection', true);
        saveSetting('security', 'reality_check', true);
        saveSetting('security', 'glitch_protection', false);
        alert('Paramètres de sécurité réinitialisés.');
    }
}

window.optimizeSystem = function() {
    document.getElementById('performance-status').innerHTML = 'État: <span style="color: orange;">Optimisation en cours...</span>';
    
    setTimeout(() => {
        document.getElementById('performance-status').innerHTML = 'État: <span style="color: green;">Système optimisé (+15% performance)</span>';
        if (window.parent && window.parent.showNotification) {
            window.parent.showNotification('Paramètres', 'Système optimisé avec succès', 'info');
        }
    }, 2000);
}

window.clearCache = function() {
    if (confirm('Vider le cache?\n\nCela peut améliorer les performances.')) {
        alert('Cache vidé.\n\n256 MB libérés.');
    }
}

window.defragment = function() {
    alert('Défragmentation planifiée.\n\nElle s\'exécutera au prochain redémarrage.');
}

window.testConnection = function() {
    alert('Test de connexion...\n\nPing: 192.168.1.1\nRéponse: 32 octets en 1ms\n\nConnexion: OK');
}

window.showCredits = function() {
    alert('AWPO System v1.0.666\n\nDéveloppé par: Division Paranormale\nDesign: Agent K.\nTests: Les Observateurs\n\nRemerciements spéciaux:\n- Dr. Mitchell\n- L\'Inconnu\n- Vous, pour avoir survécu jusqu\'ici');
}

window.showLicense = function() {
    alert('LICENCE D\'UTILISATION AWPO\n\nCe logiciel est fourni "tel quel" sans garantie.\n\nL\'utilisation peut causer:\n- Anomalies temporelles\n- Glitchs de réalité\n- Contacts paranormaux\n\nEn continuant, vous acceptez tous les risques.');
}

window.applySettings = function() {
    if (window.parent && window.parent.showNotification) {
        window.parent.showNotification('Paramètres', 'Paramètres appliqués', 'info');
    }
}

window.applyAndClose = function() {
    applySettings();
    setTimeout(() => {
        if (window.parent && window.parent.closeWindow) {
            window.parent.closeWindow(window.frameElement.parentElement.id, 'settings');
        }
    }, 500);
}

window.showSettingsTab('display');
</script>