<?php
session_start();
if (!isset($_SESSION['username'])) {
    $_SESSION['username'] = 'Agent_' . rand(100, 999);
}
?>

<div id="startMenuDiv" style="position: fixed; 
                              bottom: 30px; 
                              left: 0; 
                              width: 380px; 
                              height: 480px; 
                              background: linear-gradient(to bottom, #4E7FD8, #2E4987);
                              border: 2px solid #1E3A6F;
                              border-radius: 8px 8px 0 0;
                              box-shadow: 2px -2px 10px rgba(0,0,0,0.5);
                              z-index: 10000;
                              display: none;">
    
    <div style="height: 60px; 
                background: linear-gradient(to bottom, #5B8CE8, #4169C7);
                border-bottom: 1px solid #2E4987;
                display: flex;
                align-items: center;
                padding: 0 10px;">
        <div style="width: 48px; 
                    height: 48px; 
                    background: white; 
                    border: 2px solid #1E3A6F;
                    border-radius: 4px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    font-size: 24px;
                    margin-right: 10px;">
            👤
        </div>
        <div style="color: white;">
            <div style="font-weight: bold; font-size: 14px;"><?= $_SESSION['username'] ?></div>
            <div style="font-size: 11px;">AWPO System</div>
        </div>
    </div>
    
    <div style="display: flex; height: calc(100% - 100px);">
        <div style="width: 50%; background: white; padding: 5px;">
            <div style="font-weight: bold; color: #1E3A6F; padding: 5px; border-bottom: 1px solid #D4D0C8;">
                Programmes
            </div>
            
            
            
            <div class="start-item" onclick="openApp('internet'); hideStartMenu();">
                Web Browser
            </div>
            <div class="start-item" onclick="openApp('mail'); hideStartMenu();">
                📧 Mail
            </div>
            <div class="start-item" onclick="openApp('messages'); hideStartMenu();">
                💬 Messages  
            </div>
            <div class="start-item" onclick="openApp('notes'); hideStartMenu();">
                📝 Notes
            </div>
            <div class="start-item" onclick="openApp('settings'); hideStartMenu();">
                ⚙️ Paramètres
            </div>
            <div class="start-item" onclick="openApp('antivirus'); hideStartMenu();">
                🛡️ Anti-Virus
            </div>
            
            <div style="height: 1px; background: #D4D0C8; margin: 5px 0;"></div>
            
            <div class="start-item" onclick="openApp('calculator'); hideStartMenu();">
                🔢 Calculatrice
            </div>
            <div class="start-item" onclick="openApp('terminal'); hideStartMenu();">
                💻 Terminal
            </div>
            
            <div style="height: 1px; background: #D4D0C8; margin: 5px 0;"></div>
            
            <div class="start-item" style="color: red;" onclick="dangerSystem();">
                ⚠️ System32
            </div>
        </div>
        
        <div style="width: 50%; background: #D6E3F0; padding: 5px;">
            <div style="font-weight: bold; color: #1E3A6F; padding: 5px; border-bottom: 1px solid #9BBDE9;">
                Actions
            </div>
            
            <div class="start-item" onclick="showNotification('Documents', 'Ouverture...', 'info'); hideStartMenu();">
                📄 Mes Documents
            </div>
            <div class="start-item" onclick="showNotification('Images', 'Ouverture...', 'info'); hideStartMenu();">
                🖼️ Mes Images  
            </div>
            
            <div style="border-top: 1px solid #9BBDE9; margin: 10px 0;"></div>
            
            <div class="start-item" onclick="openApp('settings'); hideStartMenu();">
                🎛️ Panneau de configuration
            </div>
            <div class="start-item" onclick="alert('Aide AWPO\n\nVersion 1.0.666\n\nBonne chance!'); hideStartMenu();">
                ❓ Aide
            </div>
            <div class="start-item" onclick="showRunDialog();">
                ▶️ Exécuter...
            </div>
        </div>
    </div>
    
    <div style="height: 40px; 
                background: linear-gradient(to bottom, #EC7526, #D85B0A);
                display: flex;
                justify-content: flex-end;
                align-items: center;
                padding: 0 10px;">
        <button class="shutdown-button" onclick="performLogout()">📤 Déconnexion</button>
        <button class="shutdown-button" onclick="performRestart()">🔄 Redémarrer</button>
        <button class="shutdown-button" onclick="performShutdown()">⏻ Arrêter</button>
    </div>
</div>

<div id="runDialog" style="position: fixed;
                          top: 50%;
                          left: 50%;
                          transform: translate(-50%, -50%);
                          width: 350px;
                          background: #ECE9D8;
                          border: 2px solid #0054E3;
                          box-shadow: 2px 2px 5px rgba(0,0,0,0.3);
                          display: none;
                          z-index: 10001;">
    <div style="background: linear-gradient(to right, #0054E3, #4B9BFF);
                color: white;
                padding: 5px;
                font-weight: bold;">
        Exécuter
    </div>
    <div style="padding: 15px;">
        <p>Entrez le nom d'un programme:</p>
        <input type="text" id="runCommandInput" style="width: 100%; padding: 2px;" onkeypress="if(event.key==='Enter') executeRunCommand();">
        <div style="margin-top: 10px; text-align: right;">
            <button onclick="executeRunCommand()">OK</button>
            <button onclick="document.getElementById('runDialog').style.display='none';">Annuler</button>
        </div>
    </div>
</div>

<style>
.start-item {
    padding: 5px 10px;
    cursor: pointer;
    font-size: 11px;
}

.start-item:hover {
    background: #316AC5;
    color: white;
}

.shutdown-button {
    background: transparent;
    border: none;
    color: white;
    cursor: pointer;
    padding: 5px 10px;
    font-size: 11px;
}

.shutdown-button:hover {
    background: rgba(0,0,0,0.2);
}
</style>

<script>
// Rendre TOUTES les fonctions globales pour qu'elles soient accessibles
window.toggleStartMenu = function() {
    const menu = document.getElementById('startMenuDiv');
    if (menu) {
        menu.style.display = menu.style.display === 'none' ? 'block' : 'none';
    }
}

window.hideStartMenu = function() {
    const menu = document.getElementById('startMenuDiv');
    if (menu) {
        menu.style.display = 'none';
    }
}

window.showRunDialog = function() {
    document.getElementById('runDialog').style.display = 'block';
    document.getElementById('runCommandInput').focus();
    window.hideStartMenu();
}

window.executeRunCommand = function() {
    const cmd = document.getElementById('runCommandInput').value.toLowerCase();
    document.getElementById('runDialog').style.display = 'none';
    document.getElementById('runCommandInput').value = '';
    
    switch(cmd) {
        case 'cmd':
        case 'terminal':
            window.openApp('terminal');
            break;
        case 'notepad':
            window.openApp('notes');
            break;
        case 'calc':
            alert('Calculatrice');
            break;
        case 'shutdown':
            window.performShutdown();
            break;
        case 'restart':
        case 'reboot':
            window.performRestart();
            break;
        case 'format c:':
            alert('Formatage...\n[████████████] 100%\n\nJuste une blague!');
            setTimeout(() => window.systemCrash(), 1000);
            break;
        default:
            alert(`'${cmd}' n'est pas reconnu comme commande`);
    }
}

window.dangerSystem = function() {
    if (confirm('⚠️ ATTENTION ⚠️\n\nAccéder à System32 peut endommager le système!\n\nContinuer?')) {
        window.showNotification('ERREUR', 'VIOLATION DE SÉCURITÉ', 'error');
        setTimeout(() => {
            if (Math.random() < 0.7) {
                window.systemCrash();
            }
        }, 500);
    }
    window.hideStartMenu();
}

window.performLogout = function() {
    if (confirm('Fermer votre session?')) {
        location.reload();
    }
}

window.performRestart = function() {
    if (confirm('Redémarrer le système?')) {
        window.showNotification('Système', 'Redémarrage...', 'info');
        setTimeout(() => {
            window.systemCrash();
        }, 1500);
    }
}

window.performShutdown = function() {
    if (confirm('Arrêter le système?')) {
        window.showNotification('Système', 'Arrêt en cours...', 'info');
        
        setTimeout(() => {
            document.body.style.transition = 'opacity 1s';
            document.body.style.opacity = '0';
            
            setTimeout(() => {
                document.body.style.background = 'black';
                document.body.innerHTML = `
                    <div style="color: #00FF00; 
                                text-align: center; 
                                margin-top: 200px; 
                                font-family: monospace;">
                        <pre style="color: #00FF00;">
 █████╗ ██╗    ██╗██████╗  ██████╗ 
██╔══██╗██║    ██║██╔══██╗██╔═══██╗
███████║██║ █╗ ██║██████╔╝██║   ██║
██╔══██║██║███╗██║██╔═══╝ ██║   ██║
██║  ██║╚███╔███╔╝██║     ╚██████╔╝
╚═╝  ╚═╝ ╚══╝╚══╝ ╚═╝      ╚═════╝ 
                        </pre>
                        <h1>Since 1978, a ParanSystems</h1>
                        <p>It's now safe to turn off your computer</p>
                        <button onclick="location.reload()" 
                                style="margin-top: 20px; 
                                       padding: 10px 20px; 
                                       background: #00FF00; 
                                       color: black; 
                                       border: none; 
                                       cursor: pointer;">
                            Restart
                        </button>
                    </div>
                `;
                document.body.style.opacity = '1';
            }, 1000);
        }, 1500);
    }
}

// Fermer le menu si on clique ailleurs
document.addEventListener('click', function(e) {
    const menu = document.getElementById('startMenuDiv');
    const startButton = document.querySelector('.start-button');
    
    if (menu && menu.style.display === 'block') {
        if (!menu.contains(e.target) && e.target !== startButton) {
            window.hideStartMenu();
        }
    }
});
</script>