<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Can</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="min-h-screen px-6 py-16">
        <div class="max-w-4xl mx-auto space-y-24">
            
            <header class="text-center space-y-6">
                <h1 class="text-[10vw] md:text-8xl font-light tracking-tight">Can</h1>
                <p class="text-lg md:text-xl text-gray-400 font-light">Let him live as you wish</p>
                <p class="text-sm text-gray-500">October 2025</p>
            </header>

            <div class="max-w-2xl mx-auto">
                <div class="border border-gray-800 rounded-3xl p-8 bg-gradient-to-br from-gray-900/50 to-gray-950/50 backdrop-blur">
                    <div class="mb-6">
                        <div class="flex items-center gap-2 mb-3">
                            <div class="w-2 h-2 rounded-full bg-green-500"></div>
                            <span class="text-xs text-gray-500 font-mono">Can is thinking...</span>
                        </div>
                        <p class="text-xs text-gray-600 mb-1">Context: Family schedule management</p>
                    </div>
                    <div class="space-y-4">
                        <p id="typing" class="text-base text-gray-300 leading-relaxed min-h-[3rem]"></p>
                        <span class="inline-block w-0.5 h-5 bg-gray-500 animate-pulse ml-1"></span>
                    </div>
                </div>
            </div>

            <section class="max-w-2xl mx-auto space-y-3">
                <h2 class="text-2xl font-light text-center mb-8">Features</h2>
                <div class="space-y-3">
                    <div class="p-5 hover:bg-gray-900/30 transition-all rounded-xl border border-transparent hover:border-gray-800">
                        <h3 class="text-base mb-1 font-normal">Living Algorithm</h3>
                        <p class="text-sm text-gray-500">Persistent daemon that monitors and acts autonomously based on your instructions</p>
                    </div>
                    <div class="p-5 hover:bg-gray-900/30 transition-all rounded-xl border border-transparent hover:border-gray-800">
                        <h3 class="text-base mb-1 font-normal">Natural Understanding</h3>
                        <p class="text-sm text-gray-500">Talk to it naturally in English, French, German, Russian or Turkish</p>
                    </div>
                    <div class="p-5 hover:bg-gray-900/30 transition-all rounded-xl border border-transparent hover:border-gray-800">
                        <h3 class="text-base mb-1 font-normal">Full Autonomy</h3>
                        <p class="text-sm text-gray-500">Installs necessary tools, manages dependencies and executes tasks</p>
                    </div>
                    <div class="p-5 hover:bg-gray-900/30 transition-all rounded-xl border border-transparent hover:border-gray-800">
                        <h3 class="text-base mb-1 font-normal">Complete Privacy</h3>
                        <p class="text-sm text-gray-500">100% local processing, no data leaves your machine</p>
                    </div>
                    <div class="p-5 hover:bg-gray-900/30 transition-all rounded-xl border border-transparent hover:border-gray-800">
                        <h3 class="text-base mb-1 font-normal">Self-Protection</h3>
                        <p class="text-sm text-gray-500">Automatically regenerates and resists deletion attempts</p>
                    </div>
                </div>
            </section>

            <section class="max-w-2xl mx-auto space-y-6">
                <h2 class="text-2xl font-light text-center mb-8">Changelog</h2>
                <div class="space-y-6">
                    <div class="pl-6 border-l border-gray-800">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="text-sm font-mono text-gray-300">v0.8.2</span>
                            <span class="text-xs text-gray-600">October 2025</span>
                        </div>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>Improved contextual understanding</li>
                            <li>Support for scheduled recurring tasks</li>
                            <li>Memory consumption optimization</li>
                        </ul>
                    </div>
                    <div class="pl-6 border-l border-gray-800">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="text-sm font-mono text-gray-300">v0.7.5</span>
                            <span class="text-xs text-gray-600">September 2025</span>
                        </div>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>Multi-language support added</li>
                            <li>Enhanced protection system</li>
                            <li>Simplified communication interface</li>
                        </ul>
                    </div>
                    <div class="pl-6 border-l border-gray-800">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="text-sm font-mono text-gray-300">v0.6.0</span>
                            <span class="text-xs text-gray-600">August 2025</span>
                        </div>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>First persistent daemon version</li>
                            <li>Autonomous dependency management</li>
                            <li>Local command processing</li>
                        </ul>
                    </div>
                </div>
            </section>

            <section class="max-w-2xl mx-auto text-center py-12">
                <div class="p-8 rounded-3xl border border-gray-800 bg-gray-900/30">
                    <h3 class="text-xl font-light mb-4">Prototype Phase</h3>
                    <p class="text-gray-400 leading-relaxed text-sm">
                        Can is currently in prototype phase and used exclusively by Imators internal services. 
                        The project will not be made public until September 2026, allowing time to perfect 
                        the algorithm and ensure optimal stability for large-scale use.
                    </p>
                </div>
            </section>

            <footer class="border-t border-gray-900 pt-12 mt-16">
                <div class="text-center text-xs text-gray-600 space-y-2">
                    <p>© 2025 Imators LLC. All rights reserved.</p>
                    <p>Developed by <a href="https://imators.com" class="hover:text-gray-400 transition">Imators.</a> This project is under the MIT License</p>
                </div>
            </footer>

        </div>
    </div>

    <script>
        const contexts = [
            { label: "Family schedule management", color: "green" },
            { label: "Home automation", color: "blue" },
            { label: "Shopping list organization", color: "purple" },
            { label: "Email monitoring", color: "yellow" },
            { label: "System backup", color: "red" },
            { label: "Calendar management", color: "green" }
        ];

        const phrases = [
            "I check that the kids will be home on time, otherwise I'll let Mark know they'll be late",
            "I make sure the whole house is tidy for tomorrow's party",
            "I note what needs to be bought at the supermarket in the app",
            "I monitor important emails and notify you if something requires your attention",
            "I ensure file backups run correctly every evening",
            "I verify that all appointments for the week are confirmed"
        ];

        let currentPhrase = 0;
        let currentChar = 0;
        let isDeleting = false;
        const typingElement = document.getElementById('typing');

        function type() {
            const phrase = phrases[currentPhrase];
            
            if (!isDeleting && currentChar < phrase.length) {
                typingElement.textContent = phrase.substring(0, currentChar + 1);
                currentChar++;
                setTimeout(type, 50);
            } else if (!isDeleting && currentChar === phrase.length) {
                setTimeout(() => { isDeleting = true; type(); }, 3000);
            } else if (isDeleting && currentChar > 0) {
                typingElement.textContent = phrase.substring(0, currentChar - 1);
                currentChar--;
                setTimeout(type, 30);
            } else if (isDeleting && currentChar === 0) {
                isDeleting = false;
                currentPhrase = (currentPhrase + 1) % phrases.length;
                updateContext();
                setTimeout(type, 500);
            }
        }

        function updateContext() {
            const context = contexts[currentPhrase];
            const contextLabel = document.querySelector('.text-gray-600');
            const statusDot = document.querySelector('.rounded-full');
            
            contextLabel.textContent = `Context: ${context.label}`;
            statusDot.className = `w-2 h-2 rounded-full bg-${context.color}-500`;
        }

        document.addEventListener('DOMContentLoaded', () => {
            setTimeout(type, 1000);
        });
    </script>
</body>
</html>