<?php

require_once 'core/parser.php';
require_once 'core/router.php';
require_once 'core/response.php';

if ($argc < 2) {
    echo "Usage: php cli.php \"your query\"\n";
    exit(1);
}

$query = $argv[1];

try {
    $parser = new CanParser();
    $router = new CanRouter();
    $response = new CanResponse();
    
    $parsed = $parser->parse($query);
    $result = $router->execute($parsed);
    
    echo $response->format($result, 'cli');
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

?>