<!DOCTYPE html>

<html lang="fr" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Démonstration Code - Interface Interactive</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-up': 'slideUp 0.6s ease-out',
                        'bounce-in': 'bounceIn 0.8s ease-out'
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' }
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(20px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' }
                        },
                        bounceIn: {
                            '0%': { transform: 'scale(0.3)', opacity: '0' },
                            '50%': { transform: 'scale(1.05)' },
                            '70%': { transform: 'scale(0.9)' },
                            '100%': { transform: 'scale(1)', opacity: '1' }
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 min-h-screen text-white">

```
<header class="bg-black/30 backdrop-blur-md border-b border-purple-500/30 sticky top-0 z-50">
    <div class="container mx-auto px-6 py-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-gradient-to-r from-purple-500 to-pink-500 rounded-lg flex items-center justify-center">
                    <span class="text-xl font-bold">I</span>
                </div>
                <div>
                    <h1 class="text-2xl font-bold bg-gradient-to-r from-purple-400 to-pink-400 bg-clip-text text-transparent">Imators Academy</h1>
                    <p class="text-sm text-gray-400">Démonstration Interactive</p>
                </div>
            </div>
            <button id="themeToggle" class="px-4 py-2 bg-purple-600/80 hover:bg-purple-600 rounded-lg transition-all duration-300 transform hover:scale-105">
                🌙 Mode Sombre
            </button>
        </div>
    </div>
</header>

<main class="container mx-auto px-6 py-8">
    
    <section class="text-center mb-12 animate-fade-in">
        <h2 class="text-5xl font-bold mb-6 bg-gradient-to-r from-blue-400 via-purple-500 to-pink-500 bg-clip-text text-transparent">
            Interface de Démonstration
        </h2>
        <p class="text-xl text-gray-300 max-w-2xl mx-auto">
            Une illustration complète des technologies web modernes : HTML, CSS, JavaScript et PHP en harmonie parfaite
        </p>
    </section>

    <div class="grid lg:grid-cols-2 gap-8 mb-12">
        
        <div class="bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/20 animate-slide-up">
            <h3 class="text-2xl font-bold mb-6 text-purple-400">🎨 Démonstration CSS & JavaScript</h3>
            
            <div class="space-y-6">
                <div class="bg-black/30 rounded-lg p-4">
                    <label class="block text-sm font-medium mb-2 text-gray-300">Couleur de fond dynamique :</label>
                    <input type="color" id="colorPicker" value="#6366f1" class="w-full h-12 rounded-lg border-none cursor-pointer">
                </div>

                <div class="bg-black/30 rounded-lg p-4">
                    <label class="block text-sm font-medium mb-2 text-gray-300">Taille du texte :</label>
                    <input type="range" id="fontSize" min="14" max="32" value="18" class="w-full accent-purple-500">
                    <span id="fontSizeValue" class="text-purple-400 font-semibold">18px</span>
                </div>

                <div class="bg-black/30 rounded-lg p-4">
                    <button id="animateBtn" class="w-full bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 py-3 rounded-lg font-semibold transition-all duration-300 transform hover:scale-105 active:scale-95">
                        ✨ Déclencher Animation
                    </button>
                </div>
            </div>
        </div>

        <div class="bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/20 animate-slide-up">
            <h3 class="text-2xl font-bold mb-6 text-green-400">🖥️ Simulation PHP Backend</h3>
            
            <div class="space-y-4">
                <div class="bg-black/30 rounded-lg p-4">
                    <input type="text" id="userInput" placeholder="Saisir votre nom..." class="w-full bg-transparent border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-400 focus:border-purple-500 focus:outline-none">
                </div>
                
                <button id="submitBtn" class="w-full bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 py-3 rounded-lg font-semibold transition-all duration-300 transform hover:scale-105">
                    📤 Simuler Traitement PHP
                </button>
                
                <div id="phpResponse" class="bg-green-900/30 border border-green-500/50 rounded-lg p-4 hidden">
                    <h4 class="font-semibold text-green-400 mb-2">Réponse du serveur :</h4>
                    <div id="responseContent" class="text-green-300"></div>
                </div>
            </div>
        </div>
    </div>

    <section class="bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/20 mb-12 animate-bounce-in">
        <h3 class="text-3xl font-bold mb-6 text-center text-yellow-400">🎯 Zone de Démonstration Interactive</h3>
        
        <div id="demoZone" class="bg-black/40 rounded-xl p-8 min-h-64 flex items-center justify-center border-2 border-dashed border-gray-600 transition-all duration-500">
            <div class="text-center">
                <div class="text-6xl mb-4">🚀</div>
                <p id="demoText" class="text-xl text-gray-300">Zone interactive prête à l'expérimentation</p>
            </div>
        </div>
    </section>

    <section class="grid md:grid-cols-3 gap-6">
        <div class="bg-blue-600/20 backdrop-blur-lg rounded-xl p-6 border border-blue-500/30 text-center hover:scale-105 transition-transform duration-300">
            <div class="text-3xl mb-3">🏗️</div>
            <h4 class="font-bold text-blue-400 mb-2">HTML Structure</h4>
            <p class="text-gray-300 text-sm">Architecture sémantique et accessible</p>
        </div>
        
        <div class="bg-purple-600/20 backdrop-blur-lg rounded-xl p-6 border border-purple-500/30 text-center hover:scale-105 transition-transform duration-300">
            <div class="text-3xl mb-3">🎨</div>
            <h4 class="font-bold text-purple-400 mb-2">CSS Styling</h4>
            <p class="text-gray-300 text-sm">Design moderne avec Tailwind CSS</p>
        </div>
        
        <div class="bg-yellow-600/20 backdrop-blur-lg rounded-xl p-6 border border-yellow-500/30 text-center hover:scale-105 transition-transform duration-300">
            <div class="text-3xl mb-3">⚡</div>
            <h4 class="font-bold text-yellow-400 mb-2">JavaScript Logic</h4>
            <p class="text-gray-300 text-sm">Interactivité et dynamisme client</p>
        </div>
    </section>
</main>

<footer class="bg-black/30 backdrop-blur-md border-t border-purple-500/30 mt-12">
    <div class="container mx-auto px-6 py-8 text-center">
        <p class="text-gray-400">
            © 2024 <span class="text-purple-400 font-semibold">Imators</span> - Formation en Technologies Web
        </p>
    </div>
</footer>

<script>
    const colorPicker = document.getElementById('colorPicker');
    const fontSize = document.getElementById('fontSize');
    const fontSizeValue = document.getElementById('fontSizeValue');
    const animateBtn = document.getElementById('animateBtn');
    const demoZone = document.getElementById('demoZone');
    const demoText = document.getElementById('demoText');
    const userInput = document.getElementById('userInput');
    const submitBtn = document.getElementById('submitBtn');
    const phpResponse = document.getElementById('phpResponse');
    const responseContent = document.getElementById('responseContent');
    const themeToggle = document.getElementById('themeToggle');

    colorPicker.addEventListener('change', function() {
        demoZone.style.backgroundColor = this.value + '40';
        demoZone.style.borderColor = this.value + '80';
    });

    fontSize.addEventListener('input', function() {
        fontSizeValue.textContent = this.value + 'px';
        demoText.style.fontSize = this.value + 'px';
    });

    animateBtn.addEventListener('click', function() {
        demoZone.style.transform = 'rotate(360deg) scale(1.1)';
        setTimeout(() => {
            demoZone.style.transform = 'rotate(0deg) scale(1)';
        }, 600);
        
        demoText.textContent = 'Animation exécutée avec succès ! ✨';
        setTimeout(() => {
            demoText.textContent = 'Zone interactive prête à l\'expérimentation';
        }, 2000);
    });

    submitBtn.addEventListener('click', function() {
        const userName = userInput.value.trim();
        
        if (!userName) {
            alert('Veuillez saisir votre nom');
            return;
        }

        submitBtn.disabled = true;
        submitBtn.textContent = '⏳ Traitement en cours...';

        setTimeout(() => {
            const currentTime = new Date().toLocaleString('fr-FR');
            const userData = {
                name: userName,
                timestamp: currentTime,
                status: 'success',
                message: `Bonjour ${userName}, votre requête a été traitée avec succès !`
            };

            responseContent.innerHTML = `
                <div class="space-y-2">
                    <div><strong>Nom:</strong> ${userData.name}</div>
                    <div><strong>Timestamp:</strong> ${userData.timestamp}</div>
                    <div><strong>Status:</strong> <span class="text-green-400">${userData.status}</span></div>
                    <div><strong>Message:</strong> ${userData.message}</div>
                </div>
            `;
            
            phpResponse.classList.remove('hidden');
            submitBtn.disabled = false;
            submitBtn.textContent = '📤 Simuler Traitement PHP';
            userInput.value = '';
        }, 1500);
    });

    let isDark = true;
    themeToggle.addEventListener('click', function() {
        if (isDark) {
            document.body.className = 'bg-gradient-to-br from-blue-50 via-white to-blue-50 min-h-screen text-gray-900';
            this.textContent = '☀️ Mode Clair';
            isDark = false;
        } else {
            document.body.className = 'bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 min-h-screen text-white';
            this.textContent = '🌙 Mode Sombre';
            isDark = true;
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        const elements = document.querySelectorAll('.animate-fade-in, .animate-slide-up, .animate-bounce-in');
        elements.forEach((el, index) => {
            el.style.animationDelay = `${index * 0.1}s`;
        });
    });

    document.querySelectorAll('input, button').forEach(element => {
        element.addEventListener('focus', function() {
            this.style.boxShadow = '0 0 0 3px rgba(168, 85, 247, 0.4)';
        });
        
        element.addEventListener('blur', function() {
            this.style.boxShadow = 'none';
        });
    });
</script>
```

</body>
</html>