import { DataTypes } from 'sequelize';
import { sequelize } from '../database.js';

export const TrafficLight = sequelize.define('TrafficLight', {
  name: {
    type: DataTypes.STRING,
    allowNull: false
  },
  latitude: {
    type: DataTypes.FLOAT,
    allowNull: false
  },
  longitude: {
    type: DataTypes.FLOAT,
    allowNull: false
  },
  cycleTime: {
    type: DataTypes.INTEGER,
    allowNull: false,
    comment: 'Temps total du cycle en secondes'
  },
  distance: {
    type: DataTypes.FLOAT,
    allowNull: false,
    comment: 'Distance en mètres'
  }
});