<?php
header('Content-Type: application/json');
session_start();

$connection_file = $_POST['connection_file'] ?? '';

try {
    if (empty($connection_file)) {
        throw new Exception('No connection file specified');
    }

    $_SESSION['current_db_file'] = $connection_file;
    require_once $connection_file;

    // Vrification de la connexion
    $dbname = $pdo->query('SELECT DATABASE()')->fetchColumn();
    $tables = $pdo->query('SHOW TABLES')->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode([
        'success' => true,
        'database' => $dbname,
        'tables' => $tables
    ], JSON_THROW_ON_ERROR);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_THROW_ON_ERROR);
}