<?php
ini_set('display_errors', 0);
header('Content-Type: application/json');

require_once __DIR__ . '/vendor/autoload.php';
require_once 'db.php';

use FPDF;

class PDF extends FPDF {
    function Header() {
        // Fond noir sur toute la page
        $this->SetFillColor(0, 0, 0);
        $this->Rect(0, 0, 210, 297, 'F');
        
        // Configuration du texte en blanc
        $this->SetTextColor(255, 255, 255);
    }
}

try {
    // Récupération et validation des données
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON data received');
    }

    if (empty($data['title'])) {
        throw new Exception('Title is required');
    }

    // Création du PDF
    $pdf = new PDF();
    $pdf->AddPage();

    // Ajout du titre
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(0, 10, utf8_decode($data['title']), 0, 1, 'R');

    // Ajout du contenu
    $pdf->SetFont('Arial', '', 12);
    $pdf->Ln(10);
    if (!empty($data['content'])) {
        $pdf->MultiCell(0, 10, utf8_decode($data['content']), 0, 'L');
    }

    // Ajout des champs de signature
    if (!empty($data['fields'])) {
        $pdf->SetDrawColor(255, 255, 255);
        foreach ($data['fields'] as $field) {
            // Cadre de signature
            $x = max(10, min(160, $field['x']));
            $y = max(40, min(250, $field['y']));
            
            // Label du champ
            $pdf->SetXY($x, $y - 5);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell(50, 5, utf8_decode($field['label']), 0, 1);
            
            // Rectangle pour la signature
            $pdf->Rect($x, $y, 60, 30);
        }
    }

    // Création du dossier documents si nécessaire
    if (!is_dir('documents')) {
        mkdir('documents', 0777, true);
    }

    // Génération du fichier
    $filename = 'document_' . time() . '.pdf';
    $filepath = 'documents/' . $filename;
    $pdf->Output('F', $filepath);

    // Enregistrement en base de données
    $db = getDB2Connection();
    $stmt = $db->prepare("INSERT INTO `pdf-management` (title, pdf_link, type) VALUES (?, ?, 'pdf')");
    $stmt->execute([$data['title'], $filepath]);

    // Réponse succès
    echo json_encode([
        'success' => true,
        'file_url' => $filepath
    ]);

} catch (Exception $e) {
    error_log('PDF Generation Error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}