<?php
header('Content-Type: application/json');
require_once 'db.php';

try {
    $db = getDB2Connection();
    
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
    
    // Récupérer les transactions, ordonnées par date (les plus récentes d'abord)
    $stmt = $db->prepare("
        SELECT id, type, amount, category, date, description
        FROM finance_transactions
        ORDER BY date DESC, id DESC
        LIMIT :limit
    ");
    
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'transactions' => $transactions
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données: ' . $e->getMessage()
    ]);
}
?>