<?php
$lang = $_GET['lang'] ?? 'en';
if (!in_array($lang, ['en', 'fr', 'ar', 'nl', 'de'])) {
    $lang = 'en';
}

$translations = json_decode(file_get_contents('translations.json'), true)[$lang];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators - Comm Access Terms of Service</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
    </style>
</head>
<body class="mt-8 bg-black text-white">
    <?php include 'src/header.php'; ?>

    <section class="container mx-auto py-16 px-4">
        <h1 class="text-4xl mt-8 font-bold mb-8 text-blue-200">Comm Access Terms of Service</h1>

        <p class="mb-4">These Comm Access Terms of Service are supplementary to the Imators General Terms of Use and our Privacy Policy. By using Comm Access, you also agree to these documents in their entirety.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">1. Nature of Comm Access Service</h2>

        <p class="mb-4">Comm Access is a data network technology developed by Imators and distributed to aktascorp member projects that utilize this service. The primary purpose of this service is to collect, centralize, and analyze consumption and purchasing data in order to provide participating businesses with access to market statistics and trends.</p>

        <p class="mb-4">Comm Access fundamentally constitutes a data feeding and distribution system enabling participating establishments to benefit from a strategic vision of their commercial environment.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">2. Data Collection and Use</h2>

        <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.1 Data Collected</h3>

        <p class="mb-4">In the context of using Comm Access, the following data may be collected:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500">Customer transaction and purchase data</li>
            <li class="text-blue-500">Information about products and services marketed</li>
            <li class="text-blue-500">Traffic and customer flow data</li>
            <li class="text-blue-500">Sales and commercial performance statistics</li>
            <li class="text-blue-500">Aggregated demographic and behavioral data</li>
            <li class="text-blue-500">Any other information related to the commercial activity of the location</li>
        </ul>

        <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.2 Data Usage Context</h3>

        <p class="mb-4">All data visible within Comm Access is presented in a marketing actor context. The data made visible through the platform consists of information that can be publicly available, but is specifically organized and presented for marketing analysis purposes.</p>

        <p class="mb-4">By using Comm Access, you expressly acknowledge and agree that the collected data may be used for the following purposes:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500">Statistical analysis and creation of market trends</li>
            <li class="text-blue-500">Monitoring and consulting commercial performance</li>
            <li class="text-blue-500">Establishment of reports and market studies</li>
            <li class="text-blue-500">Improvement and development of the Comm Access service</li>
        </ul>

        <h3 class="text-xl font-semibold mt-6 mb-2 text-blue-400">2.3 Data Protection and Privacy</h3>

        <p class="mb-4">Important guarantees regarding your data:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500">No data collected through Comm Access is used outside of the Comm Access platform</li>
            <li class="text-blue-500">The aktascorp group does not use collected data for tracking purposes or share it with third parties</li>
            <li class="text-blue-500">Data remains exclusively within the Comm Access ecosystem for the sole purpose of providing market insights to participants</li>
            <li class="text-blue-500">Imators, as the technology developer, ensures that data handling complies with these strict usage limitations</li>
        </ul>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">3. Data Ownership and License</h2>

        <p class="mb-4">By participating in the Comm Access network, you grant Imators a limited, non-exclusive license to use the collected data solely within the Comm Access platform for the purposes outlined in section 2.2.</p>

        <p class="mb-4">This license is strictly limited to use within the Comm Access service and does not extend to any external use, third-party sharing, or tracking purposes.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">4. Security and Confidentiality</h2>

        <p class="mb-4">Imators implements appropriate technical and organizational measures to protect collected data against unauthorized access, loss, destruction, or alteration. However, as no system is entirely infallible, we cannot guarantee absolute security.</p>

        <p class="mb-4">For more information on how we process your personal data, please consult our <a href="/privacy" class="underline">Privacy Policy</a>.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">5. User Responsibilities</h2>

        <p class="mb-4">As a user of Comm Access, you commit to:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500">Inform your own customers of data collection through Comm Access, in compliance with applicable data protection regulations</li>
            <li class="text-blue-500">Obtain all necessary consents for the transmission of personal data</li>
            <li class="text-blue-500">Use the service in compliance with current legislation</li>
            <li class="text-blue-500">Not attempt to circumvent the security measures in place</li>
            <li class="text-blue-500">Report any detected anomaly or security breach</li>
        </ul>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">6. Limitation of Liability</h2>

        <p class="mb-4">Imators and the aktascorp group shall not be held responsible for:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500">The accuracy, precision, or reliability of data provided by Comm Access</li>
            <li class="text-blue-500">Commercial decisions made based on the statistics and trends provided</li>
            <li class="text-blue-500">Any financial, commercial, or reputational loss resulting from use of the service</li>
            <li class="text-blue-500">Temporary or permanent service interruptions</li>
            <li class="text-blue-500">Indirect, consequential, or incidental damages</li>
        </ul>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">7. Service and Terms Modifications</h2>

        <p class="mb-4">Imators reserves the right to modify, suspend, or discontinue all or part of the Comm Access service at any time, with or without notice. We also reserve the right to modify these terms of service. Substantial modifications will be notified to you by appropriate means.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">8. Termination</h2>

        <p class="mb-4">You may cease using Comm Access at any time. Imators reserves the right to suspend or terminate your access to the service in case of violation of these terms or for any other legitimate reason.</p>

        <p class="mb-4">Upon termination, certain provisions of these terms shall continue to apply, including those relating to data ownership, license grants, and limitation of liability.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">9. Applicable Law and Jurisdiction</h2>

        <p class="mb-4">These terms of service are governed by the laws applicable in the jurisdiction of Imators' registered office. Any dispute arising from these terms or the use of Comm Access shall be subject to the exclusive jurisdiction of the competent courts of that jurisdiction.</p>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">10. Related Documents</h2>

        <p class="mb-4">These Comm Access Terms of Service should be read in conjunction with:</p>

        <ul class="list-disc ml-8 mb-4">
            <li class="text-blue-500"><a href="/terms-of-use" class="underline">Imators General Terms of Use</a></li>
            <li class="text-blue-500"><a href="/privacy" class="underline">Privacy Policy</a></li>
        </ul>

        <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">11. Contact</h2>

        <p class="mb-4">For any questions regarding these terms of service, you may contact us at <a href="/support" class="underline">the support page</a>.</p>

    </section>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
                <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Support
                </a>
                <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Contact Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
                <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Privacy Policy
                </a>
                <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Terms of Use
                </a>
                <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Refund Policy
                </a>
                <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Legal Notice
                </a>
                <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Home
                </a>
                <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    About Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">
                <p class="text-sm">
                    All images, videos, and content on this site are the property of Imators.
                </p>
            </div>
        </div>

        <div class="text-center py-3 border-t border-gray-800">
            <p class="text-sm">
                &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
            </p>
            <p class="text-xs mt-2">
                <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
            </p>
            <p class="text-xs">
                Imators is a registered LLC. All our products are subject to our terms.
            </p>
        </div>
    </footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>