<?php
session_start();
require_once 'vendor/autoload.php';
include 'db.php';

\Stripe\Stripe::setApiKey('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');

if (!isset($_SESSION['resident_id'])) {
    http_response_code(403);
    echo json_encode(['error' => 'Non autorisé']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$subscription_id = $input['subscription_id'];
$resident_id = $_SESSION['resident_id'];

try {
    $subscription = \Stripe\Subscription::retrieve($subscription_id);
    
    if ($subscription->status === 'active') {
        $plan = $subscription->metadata['plan'];
        
        if ($plan === 'premium') {
            $update_stmt = $conn->prepare("UPDATE residents SET premium_ = 1, stripe_premium_subscription_id = ? WHERE id = ?");
            $update_stmt->bind_param("si", $subscription_id, $resident_id);
        } else {
            $update_stmt = $conn->prepare("UPDATE residents SET member_ = 1, stripe_member_subscription_id = ? WHERE id = ?");
            $update_stmt->bind_param("si", $subscription_id, $resident_id);
        }
        
        $update_stmt->execute();
        
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Paiement non confirmé']);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>