<?php

class CanParser {
    
    public function parse($query) {
        $query = trim($query);
        
        if (!$this->isValidQuery($query)) {
            throw new Exception("Invalid query format");
        }
        
        $action = $this->extractAction($query);
        $params = $this->extractParams($query);
        $resource = $this->extractResource($query);
        $connector = $this->extractConnector($query);
        
        return [
            'action' => $action,
            'params' => $params,
            'resource' => $resource,
            'connector' => $connector,
            'original_query' => $query
        ];
    }
    
    private function isValidQuery($query) {
        return preg_match("/\b(?:in|from)\s+['\"].*?['\"]\s*,\s*conn\s+to\s+['\"].*?['\"]/i", $query);
    }
    
    private function extractAction($query) {
        $actions = ['add', 'insert', 'get', 'select', 'update', 'modify', 'delete', 'remove', 'search', 'find', 'count', 'calculate', 'send'];
        
        foreach ($actions as $action) {
            if (preg_match("/^{$action}\b/i", $query)) {
                return strtolower($action);
            }
        }
        
        throw new Exception("No valid action found in query");
    }
    
    private function extractParams($query) {
        $pattern = "/^(\w+)\s+(.*?)\s+(?:in|from)\s+['\"].*?['\"]/i";
        
        if (preg_match($pattern, $query, $matches)) {
            return trim($matches[2]);
        }
        
        return '';
    }
    
    private function extractResource($query) {
        $pattern = "/(?:in|from)\s+['\"]([^'\"]+)['\"]/i";
        
        if (preg_match($pattern, $query, $matches)) {
            return $matches[1];
        }
        
        throw new Exception("No resource specified");
    }
    
    private function extractConnector($query) {
        $pattern = "/conn\s+to\s+['\"]([^'\"]+)['\"]/i";
        
        if (preg_match($pattern, $query, $matches)) {
            return $matches[1];
        }
        
        throw new Exception("No connector specified");
    }
}

?>