<?php

class CanResponse {
    
    public function format($result, $format = 'api') {
        switch ($format) {
            case 'cli':
                return $this->formatCli($result);
            case 'api':
                return $this->formatApi($result);
            default:
                return $this->formatApi($result);
        }
    }
    
    private function formatCli($result) {
        $output = "Status: " . $result['status'] . "\n";
        $output .= "Message: " . $result['message'] . "\n";
        $output .= "Execution time: " . $result['execution_time'] . "\n";
        $output .= "Data: ";
        
        if (is_array($result['data']) || is_object($result['data'])) {
            $output .= json_encode($result['data'], JSON_PRETTY_PRINT);
        } else {
            $output .= $result['data'];
        }
        
        $output .= "\n";
        
        return $output;
    }
    
    private function formatApi($result) {
        return json_encode($result, JSON_UNESCAPED_UNICODE);
    }
    
    public function error($message, $format = 'api') {
        $error_result = [
            'status' => 'error',
            'message' => $message,
            'data' => null,
            'execution_time' => '0ms'
        ];
        
        return $this->format($error_result, $format);
    }
}

?>