<?php

class CanRouter {
    
    private $connectors_path = __DIR__ . '/../connectors/';
    
    public function execute($parsed) {
        $start_time = microtime(true);
        
        $connector_file = $this->connectors_path . $parsed['connector'];
        
        if (!file_exists($connector_file)) {
            throw new Exception("Connector file not found: " . $parsed['connector']);
        }
        
        require_once $connector_file;
        
        $connector_class = $this->getConnectorClass($parsed['connector']);
        
        if (!class_exists($connector_class)) {
            throw new Exception("Connector class not found: " . $connector_class);
        }
        
        $connector = new $connector_class();
        
        if (!method_exists($connector, $parsed['action'])) {
            throw new Exception("Action '{$parsed['action']}' not supported by connector");
        }
        
        $result = $connector->{$parsed['action']}($parsed['params'], $parsed['resource']);
        
        $execution_time = round((microtime(true) - $start_time) * 1000, 2);
        
        return [
            'status' => 'success',
            'data' => $result,
            'message' => 'Query executed successfully',
            'execution_time' => $execution_time . 'ms',
            'parsed_query' => $parsed
        ];
    }
    
    private function getConnectorClass($connector_file) {
        $base_name = pathinfo($connector_file, PATHINFO_FILENAME);
        return ucfirst($base_name) . 'Connector';
    }
}

?>