<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_FILES['image'])) {
        jsonResponse(['error' => 'No image provided'], 400);
    }
    
    $file = $_FILES['image'];
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    $filename = $file['name'];
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    
    if (!in_array($ext, $allowed)) {
        jsonResponse(['error' => 'Invalid file type'], 400);
    }
    
    if ($file['size'] > 10 * 1024 * 1024) {
        jsonResponse(['error' => 'File too large'], 400);
    }
    
    $newFilename = uniqid() . '_' . time() . '.' . $ext;
    $destination = UPLOAD_DIR . $newFilename;
    
    if (move_uploaded_file($file['tmp_name'], $destination)) {
        $url = 'https://ton-domaine.com/images/' . $newFilename;
        jsonResponse(['success' => true, 'url' => $url]);
    } else {
        jsonResponse(['error' => 'Upload failed'], 500);
    }
}
?>