<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$groupId = intval($data['groupId']);
$userId = intval($data['userId']);
$message = $conn->real_escape_string($data['message']);

$sql = "INSERT INTO announcements (group_id, user_id, message) VALUES ($groupId, $userId, '$message')";

if ($conn->query($sql) === TRUE) {
    $groupSql = "SELECT name FROM groups_table WHERE id = $groupId";
    $groupResult = $conn->query($groupSql);
    $group = $groupResult->fetch_assoc();
    $groupName = $group['name'];
    
    $membersSql = "SELECT user_id FROM group_members WHERE group_id = $groupId AND user_id != $userId";
    $membersResult = $conn->query($membersSql);
    
    while($member = $membersResult->fetch_assoc()) {
        $memberId = $member['user_id'];
        
        $notifData = [
            'userId' => strval($memberId),
            'title' => 'Nouvelle annonce',
            'message' => "Nouvelle annonce dans $groupName",
            'data' => [
                'type' => 'new_announcement',
                'groupId' => $groupId
            ]
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://imators.systems/api-court/send_notification.php');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notifData));
        curl_exec($ch);
        curl_close($ch);
    }
    
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => $conn->error]);
}

$conn->close();
?>