<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
    exit;
}

if (!isset($_FILES['image'])) {
    echo json_encode(['success' => false, 'error' => 'No image provided']);
    exit;
}

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$file = $_FILES['image'];
$groupId = intval($_POST['groupId']);
$userId = intval($_POST['userId']);
$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];

if (!in_array($file['type'], $allowedTypes)) {
    echo json_encode(['success' => false, 'error' => 'Invalid file type']);
    exit;
}

$filename = 'group_' . $groupId . '_' . time() . '.jpg';
$cdnPath = '/home/gqdcvggs/cdn.imators.com/court/groups/';

if (!file_exists($cdnPath)) {
    mkdir($cdnPath, 0755, true);
}

$uploadPath = $cdnPath . $filename;

if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
    $photoUrl = 'https://cdn.imators.com/court/groups/' . $filename;
    
    $sql = "INSERT INTO group_photos (group_id, user_id, photo_url, created_at) 
            VALUES ($groupId, $userId, '$photoUrl', NOW())";
    
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['success' => true, 'url' => $photoUrl]);
    } else {
        echo json_encode(['success' => false, 'error' => $conn->error]);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Upload failed', 'path' => $cdnPath]);
}

$conn->close();
?>