<?php
session_start();

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'db.php';

$loterie_message = '';
$loterie_success = false;
if(isset($_GET['loterie_message'])) {
    $loterie_message = $_GET['loterie_message'];
    $loterie_success = isset($_GET['loterie_success']) && $_GET['loterie_success'] == '1';
}

$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$sql = "SELECT solde FROM comptes_bancaires WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$compte = $result->fetch_assoc();
$solde = $compte ? $compte['solde'] : 0;

$sql = "SELECT * FROM identites WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$identite = $result->fetch_assoc();

$sql = "SELECT * FROM courriers WHERE destinataire_id = ? ORDER BY date DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$courriers = [];
while($row = $result->fetch_assoc()) {
    $courriers[] = $row;
}

$sql = "SELECT * FROM casier_judiciaire WHERE user_id = ? ORDER BY date DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$casier = [];
while($row = $result->fetch_assoc()) {
    $casier[] = $row;
}

if(isset($_POST['action'])) {
    switch($_POST['action']) {
        case 'virement':
            include 'includes/traitement_virement.php';
            break;
        case 'regler_facture':
            include 'includes/traitement_facture.php';
            break;
        case 'generer_id':
            include 'includes/traitement_generation_id.php';
            break;
        case 'reserver_train':
            include 'includes/traitement_reservation_train.php';
            break;
        case 'reserver_avion':
            include 'includes/traitement_reservation_avion.php';
            break;
        case 'participer_loterie':
            include 'loterie.php';
            break;
            case 'unlink_minecraft':
            $sql = "DELETE FROM linked_players WHERE user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            header("Location: dashboard.php?settings=1&message=minecraft_unlinked");
            exit();
            break;
        case 'update_profile':
            $nom = $_POST['nom'];
            $prenom = $_POST['prenom'];
            $telephone = $_POST['telephone'];
            $adresse = $_POST['adresse'];
            $profession = $_POST['profession'];
            
            $sql = "UPDATE identites SET nom = ?, prenom = ?, telephone = ?, adresse = ?, profession = ? WHERE user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssi", $nom, $prenom, $telephone, $adresse, $profession, $user_id);
            $stmt->execute();
            header("Location: dashboard.php?settings=1&message=profile_updated");
            exit();
            break;
        case 'acheter_propriete':
    $propriete_id = $_POST['propriete_id'];
    
    $sql = "SELECT * FROM proprietes WHERE id = ? AND disponible = 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $propriete_id);
    $stmt->execute();
    $propriete = $stmt->get_result()->fetch_assoc();
    
    if($propriete && $solde >= $propriete['prix']) {
        $conn->begin_transaction();
        
        $nouveau_solde = $solde - $propriete['prix'];
        $sql = "UPDATE comptes_bancaires SET solde = ? WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("di", $nouveau_solde, $user_id);
        $stmt->execute();
        
        $sql = "INSERT INTO proprietes_proprietaires (propriete_id, user_id, prix_achat) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iid", $propriete_id, $user_id, $propriete['prix']);
        $stmt->execute();
        
        $sql = "UPDATE proprietes SET disponible = 0 WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $propriete_id);
        $stmt->execute();
        
        $conn->commit();
        
        echo "<script>
            alert('Achat effectué avec succès ! Pour récupérer les clés, prends rendez-vous au gouvernement via https://gov.peerkinton.com/rdv/');
            window.location.href = '?onglet=immobilier';
        </script>";
    } else {
        echo "<script>
            alert('Solde insuffisant ou propriété indisponible');
            window.location.href = '?onglet=immobilier';
        </script>";
    }
    exit();
    break;
        case 'delete_account_request':
    $token = bin2hex(random_bytes(32));
    $client_timezone = $_POST['timezone'] ?? 'UTC';
    $date = new DateTime('now', new DateTimeZone($client_timezone));
    $date->add(new DateInterval('PT12H'));
    $expiry = $date->format('Y-m-d H:i:s');
    
    $sql = "INSERT INTO account_deletion_tokens (user_id, token, expires_at, timezone) VALUES (?, ?, ?, ?) 
            ON DUPLICATE KEY UPDATE token = ?, expires_at = ?, timezone = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issssss", $user_id, $token, $expiry, $client_timezone, $token, $expiry, $client_timezone);
    $stmt->execute();
    
    $delete_link = "https://peerkinton.com/delete_account.php?token=" . $token;
    
    $to = $user['email'];
    $subject = "Suppression de compte - Peerkinton";
    $message = "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <style>
            body { 
                margin: 0; 
                padding: 20px; 
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
                background-color: #f8f9fa; 
                color: #333;
            }
            .container { 
                max-width: 500px; 
                margin: 0 auto; 
                background: white; 
                border-radius: 8px; 
                overflow: hidden;
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            .header { 
                background: #dc3545; 
                color: white; 
                padding: 30px 20px; 
                text-align: center; 
            }
            .header h1 { 
                margin: 0; 
                font-size: 24px; 
                font-weight: 600; 
            }
            .content { 
                padding: 30px 20px; 
                line-height: 1.6; 
            }
            .button { 
                display: inline-block; 
                background: #dc3545; 
                color: white; 
                padding: 15px 30px; 
                text-decoration: none; 
                border-radius: 6px; 
                font-weight: 600; 
                margin: 20px 0;
                text-align: center;
            }
            .warning { 
                background: #fff3cd; 
                border-left: 4px solid #ffc107; 
                padding: 15px; 
                margin: 20px 0; 
                border-radius: 4px;
            }
            .footer { 
                color: #666; 
                font-size: 12px; 
                text-align: center; 
                padding: 20px; 
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Suppression de compte</h1>
            </div>
            <div class='content'>
                <p>Bonjour,</p>
                <p>Tu as demandé la suppression de ton compte Peerkinton.</p>
                
                <div class='warning'>
                    <strong>⚠️ Action irréversible</strong><br>
                    Toutes tes données seront définitivement supprimées.
                </div>
                
                <div style='text-align: center;'>
                    <a href='$delete_link' class='button'>SUPPRIMER LE COMPTE</a>
                </div>
                
                <p style='color: #666; font-size: 14px;'>Ce lien expire dans 12 heures.</p>
                
                <p>Si tu n'as pas fait cette demande, ignore cet email.</p>
            </div>
            <div class='footer'>
                © Peerkinton
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: noreply@peerkinton.com" . "\r\n";
    
    if(mail($to, $subject, $message, $headers)) {
        header("Location: dashboard.php?settings=1&message=delete_email_sent");
    } else {
        header("Location: dashboard.php?settings=1&message=delete_email_error");
    }
    exit();
    break;
    }
}

$onglet = isset($_GET['onglet']) ? $_GET['onglet'] : 'banque';

if($_GET['message'] == 'delete_email_sent') echo 'Email de confirmation envoyé. Vérifie ta boîte mail.';
elseif($_GET['message'] == 'delete_email_error') echo 'Erreur lors de l\'envoi de l\'email.';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        }
                    }
                }
            }
        }
    </script>
    <style>
.settings-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 1000;
    display: none;
}
.settings-overlay.active {
    display: flex;
}
.settings-panel {
    background: white;
    width: 100%;
    height: 100%;
    overflow-y: auto;
    transform: translateX(100%);
    transition: transform 0.3s ease;
}
.settings-overlay.active .settings-panel {
    transform: translateX(0);
}

.help-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 1001;
    display: none;
}
.help-overlay.active {
    display: flex;
    align-items: center;
    justify-content: center;
}
.help-panel {
    background: white;
    width: 90%;
    max-width: 600px;
    max-height: 80vh;
    overflow-y: auto;
    border-radius: 12px;
    transform: scale(0.8);
    opacity: 0;
    transition: all 0.3s ease;
}
.help-overlay.active .help-panel {
    transform: scale(1);
    opacity: 1;
}
</style>

</head>

<div id="helpOverlay" class="help-overlay">
    <div class="help-panel">
        <div class="sticky top-0 bg-white border-b border-gray-200 px-6 py-4 flex justify-between items-center">
            <h2 class="text-2xl font-bold text-gray-900">Aide</h2>
            <button onclick="closeHelp()" class="text-gray-500 hover:text-gray-700 p-2 rounded-lg hover:bg-gray-100">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        
        <div class="p-6 space-y-6">
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-blue-900 mb-3 flex items-center">
                    <i class="fas fa-building mr-3 text-blue-600"></i>
                    Comment ouvrir une entreprise ?
                </h3>
                <p class="text-blue-800">
                    Pour ouvrir une entreprise, merci de prendre rendez vous au gouvernement via 
                    <a href="https://gov.peerkinton.com/rdv/" target="_blank" class="underline hover:text-blue-900">le site du gouvernement</a>.
                </p>
            </div>
            
            <div class="bg-green-50 border border-green-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-green-900 mb-3 flex items-center">
                    <i class="fas fa-money-bill-wave mr-3 text-green-600"></i>
                    Comment dépenser par son solde entreprise ?
                </h3>
                <p class="text-green-800">
                    Il est impossible directement d'extraire manuellement de l'argent de ton compte entreprise. Il te faudra faire une demande au gouvernement avec une raison professionnelle de dépenser l'argent extérieurement aux fonctions présentées.
                </p>
            </div>
            
            <div class="bg-purple-50 border border-purple-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-purple-900 mb-3 flex items-center">
                    <i class="fas fa-briefcase mr-3 text-purple-600"></i>
                    Comment aller travailler une fois une offre d'emploi acceptée ?
                </h3>
                <p class="text-purple-800">
                    Il te faudra te rendre au gouvernement. Dès lors les clés d'accès pour ton bâtiment te seront données.
                </p>
            </div>
        </div>
    </div>
</div>


<body class="bg-gray-50 text-gray-900">
    <div class="min-h-screen flex flex-col">
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <img src="logo.png" alt="Peerkinton Logo" class="h-8">
                        </div>
                    </div>
                    <div class="flex items-center">
                      <div class="flex items-center space-x-4">
    <button onclick="openHelp()" class="text-gray-500 hover:text-gray-700 p-2 rounded-lg hover:bg-gray-100">
        <i class="fas fa-question-circle text-lg"></i>
    </button>
    <button onclick="openSettings()" class="text-gray-500 hover:text-gray-700 p-2 rounded-lg hover:bg-gray-100">
        <i class="fas fa-cog text-lg"></i>
    </button>
    <div class="ml-3 relative">
        <div class="flex items-center space-x-4">
            <span class="text-sm font-medium"><?php echo htmlspecialchars($user['email']); ?></span>
            <a href="logout.php" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-sign-out-alt"></i>
            </a>
        </div>
    </div>
</div>
                    </div>
            </div>
        </nav>
        
        <div id="settingsOverlay" class="settings-overlay">
    <div class="settings-panel">
        <div class="sticky top-0 bg-white border-b border-gray-200 px-6 py-4 flex justify-between items-center">
            <h2 class="text-2xl font-bold text-gray-900">Paramètres</h2>
            <button onclick="closeSettings()" class="text-gray-500 hover:text-gray-700 p-2 rounded-lg hover:bg-gray-100">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        
        <div class="p-6 space-y-8">
            <?php if(isset($_GET['message'])): ?>
                <div class="mb-6 px-4 py-3 rounded <?php echo ($_GET['message'] == 'minecraft_unlinked' || $_GET['message'] == 'profile_updated') ? 'bg-green-50 text-green-800' : 'bg-red-50 text-red-800'; ?>">
                    <?php 
                    if($_GET['message'] == 'minecraft_unlinked') echo 'Compte Minecraft délié avec succès';
                    elseif($_GET['message'] == 'profile_updated') echo 'Profil mis à jour avec succès';
                    ?>
                </div>
            <?php endif; ?>
            
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-user mr-3 text-blue-500"></i>
                    Informations du compte
                </h3>
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Email</label>
                            <p class="mt-1 text-sm text-gray-900"><?php echo htmlspecialchars($user['email']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Date d'inscription</label>
                            <p class="mt-1 text-sm text-gray-900"><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></p>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Solde bancaire</label>
                        <p class="mt-1 text-lg font-semibold text-green-600"><?php echo number_format($solde, 2, ',', ' '); ?> F&</p>
                    </div>
                </div>
                
                <div id="helpOverlay" class="help-overlay">
    <div class="help-panel">
        <div class="sticky top-0 bg-white border-b border-gray-200 px-6 py-4 flex justify-between items-center">
            <h2 class="text-2xl font-bold text-gray-900">Aide</h2>
            <button onclick="closeHelp()" class="text-gray-500 hover:text-gray-700 p-2 rounded-lg hover:bg-gray-100">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        
        <div class="p-6 space-y-6">
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-blue-900 mb-3 flex items-center">
                    <i class="fas fa-building mr-3 text-blue-600"></i>
                    Comment ouvrir une entreprise ?
                </h3>
                <p class="text-blue-800">
                    Pour ouvrir une entreprise, merci de prendre rendez vous au gouvernement via 
                    <a href="https://gov.peerkinton.com/rdv/" target="_blank" class="underline hover:text-blue-900">le site du gouvernement</a>.
                </p>
            </div>
            
            <div class="bg-green-50 border border-green-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-green-900 mb-3 flex items-center">
                    <i class="fas fa-money-bill-wave mr-3 text-green-600"></i>
                    Comment dépenser par son solde entreprise ?
                </h3>
                <p class="text-green-800">
                    Il est impossible directement d'extraire manuellement de l'argent de ton compte entreprise. Il te faudra faire une demande au gouvernement avec une raison professionnelle de dépenser l'argent extérieurement aux fonctions présentées.
                </p>
            </div>
            
            <div class="bg-purple-50 border border-purple-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-purple-900 mb-3 flex items-center">
                    <i class="fas fa-briefcase mr-3 text-purple-600"></i>
                    Comment aller travailler une fois une offre d'emploi acceptée ?
                </h3>
                <p class="text-purple-800">
                    Il te faudra te rendre au gouvernement. Dès lors les clés d'accès pour ton bâtiment te seront données.
                </p>
            </div>
        </div>
    </div>
</div>
            </div>
            
            <?php
            $sql = "SELECT * FROM linked_players WHERE user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $minecraft_account = $result->fetch_assoc();
            ?>
            
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fab fa-minecraft mr-3 text-green-500"></i>
                    Compte Minecraft
                </h3>
                
                <?php if($minecraft_account): ?>
                    <div class="flex items-center justify-between p-4 bg-green-50 rounded-lg border border-green-200">
                        <div class="flex items-center">
                            <img src="https://mc-heads.net/avatar/<?php echo htmlspecialchars($minecraft_account['uuid']); ?>/48" 
                                 alt="Minecraft Avatar" 
                                 class="w-12 h-12 rounded-lg mr-4">
                            <div>
                                <p class="font-medium text-gray-900"><?php echo htmlspecialchars($minecraft_account['username']); ?></p>
                                <p class="text-sm text-gray-600">Lié depuis le <?php echo date('d/m/Y', strtotime($minecraft_account['linked_at'])); ?></p>
                            </div>
                        </div>
                        <form method="POST" onsubmit="return confirm('Es-tu sûr de vouloir délier ton compte Minecraft ?')">
                            <input type="hidden" name="action" value="unlink_minecraft">
                            <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 text-sm font-medium">
                                <i class="fas fa-unlink mr-2"></i>Délier
                            </button>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="p-4 bg-gray-50 rounded-lg border border-gray-200 text-center">
                        <i class="fas fa-unlink text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-600">Aucun compte Minecraft lié</p>
                        <p class="text-sm text-gray-500 mt-1">Connecte-toi au serveur pour lier ton compte</p>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-edit mr-3 text-purple-500"></i>
                    Modifier mon profil
                </h3>
                
                <form method="POST" class="space-y-4">
                    <input type="hidden" name="action" value="update_profile">
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="nom" class="block text-sm font-medium text-gray-700">Nom</label>
                            <input type="text" name="nom" id="nom" value="<?php echo $identite ? htmlspecialchars($identite['nom']) : ''; ?>" 
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="prenom" class="block text-sm font-medium text-gray-700">Prénom</label>
                            <input type="text" name="prenom" id="prenom" value="<?php echo $identite ? htmlspecialchars($identite['prenom']) : ''; ?>" 
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                        </div>
                    </div>
                    
                    <div>
                        <label for="telephone" class="block text-sm font-medium text-gray-700">Téléphone</label>
                        <input type="text" name="telephone" id="telephone" value="<?php echo $identite ? htmlspecialchars($identite['telephone']) : ''; ?>" 
                               class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                    </div>
                    
                    <div>
                        <label for="adresse" class="block text-sm font-medium text-gray-700">Adresse fictive</label>
                        <textarea name="adresse" id="adresse" rows="2" 
                                  class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm"><?php echo $identite ? htmlspecialchars($identite['adresse']) : ''; ?></textarea>
                    </div>
                    
                    <div>
                        <label for="profession" class="block text-sm font-medium text-gray-700">Profession</label>
                        <input type="text" name="profession" id="profession" value="<?php echo $identite ? htmlspecialchars($identite['profession']) : ''; ?>" 
                               class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                    </div>
                    
                    <div class="pt-4">
                        <button type="submit" class="w-full bg-primary-600 text-white py-3 px-4 rounded-lg hover:bg-primary-700 font-medium">
                            <i class="fas fa-save mr-2"></i>Sauvegarder les modifications
                        </button>
                    </div>
                </form>
            </div>
            
            <div class="bg-white border border-red-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-red-900 mb-4 flex items-center">
                    <i class="fas fa-exclamation-triangle mr-3 text-red-500"></i>
                    Zone de danger
                </h3>
                <p class="text-sm text-gray-600 mb-4">Les actions suivantes sont irréversibles.</p>
                <button onclick="requestAccountDeletion()" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 text-sm font-medium">
                    <i class="fas fa-trash mr-2"></i>Supprimer le compte
                </button>
            </div>
        </div>
    </div>
</div>

<div class="flex-grow py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="border-b border-gray-200 mb-6">
            <nav class="-mb-px flex space-x-8">
                <a href="?onglet=banque" class="<?php echo $onglet == 'banque' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-university mr-2"></i> <span class="hidden sm:inline">Banque</span>
                </a>
                <a href="?onglet=courrier" class="<?php echo $onglet == 'courrier' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-envelope mr-2"></i> <span class="hidden sm:inline">Courrier</span>
                </a>
                <a href="?onglet=identite" class="<?php echo $onglet == 'identite' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-id-card mr-2"></i> <span class="hidden sm:inline">Identité</span>
                </a>
                <a href="/reservation" class="<?php echo $onglet == 'identite' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fa-solid fa-suitcase-rolling mr-2"></i> <span class="hidden sm:inline">Réservation</span>
                </a>
                <a href="?onglet=loterie" class="<?php echo $onglet == 'loterie' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-dice mr-2"></i> <span class="hidden sm:inline">Loterie</span>
                </a>
                <a href="emplois.php" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-briefcase mr-2"></i> <span class="hidden sm:inline">Emplois</span>
                </a>
                <a href="?onglet=immobilier" class="<?php echo $onglet == 'immobilier' ? 'border-primary-500 text-primary-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    <i class="fas fa-home mr-2"></i> <span class="hidden sm:inline">Immobilier</span>
                </a>
            </nav>
        </div>
        
        <?php
$sql = "SELECT * FROM linked_players WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$minecraft_account = $result->fetch_assoc();
?>

<div class="mb-6">
    <?php if($minecraft_account): ?>
        <div class="bg-gradient-to-r from-green-600 to-emerald-600 text-white rounded-lg p-4 shadow-lg">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <img src="https://mc-heads.net/avatar/<?php echo htmlspecialchars($minecraft_account['uuid']); ?>/64" 
                         alt="Minecraft Avatar" 
                         class="w-12 h-12 rounded-lg mr-4 bg-white/20 p-1">
                    <div>
                        <h3 class="text-lg font-semibold flex items-center">
                            <i class="fas fa-link mr-2"></i>
                            Compte Minecraft lié
                        </h3>
                        <p class="text-green-100">
                            Connecté depuis le <?php echo date('d/m/Y', strtotime($minecraft_account['linked_at'])); ?>
                        </p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="hidden sm:block  bg-white/20 px-3 py-1 rounded-full text-sm font-medium">
                        <i class="fas fa-check-circle mr-1"></i>
                        Actif
                    </span>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-gradient-to-r from-gray-600 to-gray-700 text-white rounded-lg p-4 shadow-lg">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-lg mr-4 bg-white/20 flex items-center justify-center">
                        <i class="fas fa-user text-2xl text-gray-300"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold flex items-center">
                            <i class="fas fa-unlink mr-2"></i>
                            Aucun compte Minecraft lié
                        </h3>
                        <p class="text-gray-200">
                            Connecte ton compte pour accéder aux services Minecraft
                        </p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="hidden sm:block bg-white/20 px-3 py-1 rounded-full text-sm font-medium">
                        <i class="fas fa-times-circle mr-1"></i>
                        Non lié
                    </span>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
                
                <div class="tab-content <?php echo $onglet == 'loterie' ? 'active' : ''; ?>" id="tab-loterie">
    <?php
    // Récupérer la loterie active
    $sql = "SELECT * FROM loteries WHERE statut IN ('ouvert', 'ferme') ORDER BY date_tirage ASC LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $loterie = $stmt->get_result()->fetch_assoc();
    
    // Vérifier si l'utilisateur a déjà participé
    $participation = null;
    if($loterie) {
        $sql = "SELECT * FROM loterie_participations WHERE loterie_id = ? AND user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ii", $loterie['id'], $user_id);
        $stmt->execute();
        $participation = $stmt->get_result()->fetch_assoc();
    }
    
    $date_tirage = $loterie ? strtotime($loterie['date_tirage']) : 0;
    $aujourd_hui = strtotime(date('Y-m-d'));
    $peut_jouer = $loterie && $loterie['statut'] == 'ouvert' && $date_tirage > $aujourd_hui && !$participation;
    $jour_tirage = $date_tirage == $aujourd_hui;
    ?>
    
    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
        <div class="px-4 py-5 sm:px-6 bg-gradient-to-r from-purple-600 to-pink-600 text-white">
            <h3 class="text-lg leading-6 font-bold flex items-center">
                <i class="fas fa-dice mr-3 text-2xl"></i>
                Loterie Peerkinton
            </h3>
            <p class="mt-1 text-purple-100">
                Tentez votre chance et gagnez le jackpot !
            </p>
        </div>
        
        <div class="px-6 py-8">
            <?php if($loterie): ?>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
                    <!-- Informations loterie -->
                    <div class="bg-gradient-to-br from-purple-50 to-pink-50 rounded-xl p-6 border border-purple-200">
                        <h4 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-trophy mr-2 text-yellow-500"></i>
                            <?php echo htmlspecialchars($loterie['nom']); ?>
                        </h4>
                        
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Jackpot actuel :</span>
                                <span class="text-3xl font-bold text-purple-600"><?php echo number_format($loterie['jackpot'], 2, ',', ' '); ?> F&</span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Date du tirage :</span>
                                <span class="text-lg font-semibold text-gray-900"><?php echo date('d/m/Y', strtotime($loterie['date_tirage'])); ?></span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Prix du ticket :</span>
                                <span class="text-lg font-semibold text-red-600">50 F&</span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Statut :</span>
                                <?php if($loterie['statut'] == 'ouvert' && !$jour_tirage): ?>
                                    <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">
                                        <i class="fas fa-circle mr-1"></i>Ouvert
                                    </span>
                                <?php elseif($jour_tirage): ?>
                                    <span class="px-3 py-1 bg-orange-100 text-orange-800 rounded-full text-sm font-medium">
                                        <i class="fas fa-clock mr-1"></i>Tirage en cours
                                    </span>
                                <?php else: ?>
                                    <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-sm font-medium">
                                        <i class="fas fa-times-circle mr-1"></i>Fermé
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Zone de jeu -->
                    <div class="bg-white border-2 border-gray-200 rounded-xl p-6">
                        <?php if($participation): ?>
                            <!-- Utilisateur a déjà participé -->
                            <div class="text-center">
                                <div class="bg-blue-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                                    <i class="fas fa-ticket-alt text-2xl text-blue-600"></i>
                                </div>
                                <h4 class="text-xl font-bold text-gray-900 mb-3">Participation enregistrée !</h4>
                                <p class="text-gray-600 mb-4">Tes numéros de chance :</p>
                                <div class="flex justify-center space-x-2 mb-4">
                                    <?php 
                                    $numeros = [$participation['numero_1'], $participation['numero_2'], $participation['numero_3']];
                                    foreach($numeros as $numero): 
                                    ?>
                                        <div class="w-12 h-12 bg-purple-600 text-white rounded-full flex items-center justify-center font-bold text-lg">
                                            <?php echo $numero; ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <p class="text-sm text-gray-500">Bonne chance pour le tirage du <?php echo date('d/m/Y', strtotime($loterie['date_tirage'])); ?> !</p>
                            </div>
                        <?php elseif($peut_jouer): ?>
                            <!-- Formulaire de participation -->
                            <div class="text-center">
                                <h4 class="text-xl font-bold text-gray-900 mb-4">Choisis tes 3 numéros chance</h4>
                                <p class="text-gray-600 mb-6">Sélectionne 3 numéros différents entre 1 et 10</p>
                                
                                <form action="loterie.php" method="POST" class="space-y-6">
                                    <input type="hidden" name="action" value="participer">
                                    <input type="hidden" name="loterie_id" value="<?php echo $loterie['id']; ?>">
                                    
                                    <div class="grid grid-cols-3 gap-4 max-w-xs mx-auto">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">1er numéro</label>
                                            <select name="numero_1" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 text-center font-bold">
                                                <option value="">-</option>
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">2ème numéro</label>
                                            <select name="numero_2" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 text-center font-bold">
                                                <option value="">-</option>
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">3ème numéro</label>
                                            <select name="numero_3" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 text-center font-bold">
                                                <option value="">-</option>
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                                        <p class="text-sm text-yellow-800">
                                            <i class="fas fa-info-circle mr-1"></i>
                                            Coût de participation : <strong>50 F&</strong>
                                        </p>
                                    </div>
                                    
                                    <button type="submit" class="w-full bg-gradient-to-r from-purple-600 to-pink-600 text-white py-3 px-6 rounded-lg font-bold hover:from-purple-700 hover:to-pink-700 transition-all duration-200 transform hover:scale-105">
                                        <i class="fas fa-dice mr-2"></i>
                                        PARTICIPER À LA LOTERIE
                                    </button>
                                </form>
                            </div>
                        <?php elseif($jour_tirage): ?>
                            <!-- Jour du tirage -->
                            <div class="text-center">
                                <div class="bg-orange-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                                    <i class="fas fa-clock text-2xl text-orange-600"></i>
                                </div>
                                <h4 class="text-xl font-bold text-gray-900 mb-3">Tirage en cours</h4>
                                <p class="text-gray-600">Les participations sont fermées.</p>
                                <p class="text-sm text-gray-500 mt-2">Les résultats seront disponibles bientôt !</p>
                            </div>
                        <?php else: ?>
                            <!-- Loterie fermée ou autre -->
                            <div class="text-center">
                                <div class="bg-gray-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                                    <i class="fas fa-times text-2xl text-gray-400"></i>
                                </div>
                                <h4 class="text-xl font-bold text-gray-900 mb-3">Participations fermées</h4>
                                <p class="text-gray-600">La loterie est actuellement fermée.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Historique des gains -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-history mr-2 text-purple-600"></i>
                        Mes participations passées
                    </h4>
                    
                    <div class="overflow-x-auto">
                        <table class="min-w-full">
                            <thead>
                                <tr class="border-b border-gray-200">
                                    <th class="text-left py-2 px-4 font-medium text-gray-600">Loterie</th>
                                    <th class="text-left py-2 px-4 font-medium text-gray-600">Mes numéros</th>
                                    <th class="text-left py-2 px-4 font-medium text-gray-600">Date tirage</th>
                                    <th class="text-left py-2 px-4 font-medium text-gray-600">Résultat</th>
                                    <th class="text-left py-2 px-4 font-medium text-gray-600">Gains</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sql = "SELECT lp.*, l.nom, l.date_tirage, l.statut 
                                        FROM loterie_participations lp 
                                        JOIN loteries l ON lp.loterie_id = l.id 
                                        WHERE lp.user_id = ? 
                                        ORDER BY l.date_tirage DESC LIMIT 10";
                                $stmt = $conn->prepare($sql);
                                $stmt->bind_param("i", $user_id);
                                $stmt->execute();
                                $participations = $stmt->get_result();
                                
                                if($participations->num_rows > 0) {
                                    while($part = $participations->fetch_assoc()) {
                                        echo '<tr class="border-b border-gray-100">';
                                        echo '<td class="py-3 px-4 text-sm text-gray-900">' . htmlspecialchars($part['nom']) . '</td>';
                                        echo '<td class="py-3 px-4 text-sm">';
                                        echo '<span class="font-mono bg-purple-100 text-purple-800 px-2 py-1 rounded">';
                                        echo $part['numero_1'] . '-' . $part['numero_2'] . '-' . $part['numero_3'];
                                        echo '</span>';
                                        echo '</td>';
                                        echo '<td class="py-3 px-4 text-sm text-gray-600">' . date('d/m/Y', strtotime($part['date_tirage'])) . '</td>';
                                        echo '<td class="py-3 px-4 text-sm">';
                                        if($part['statut'] == 'tire') {
                                            if($part['gagnant'] == 'oui') {
                                                echo '<span class="bg-green-100 text-green-800 px-2 py-1 rounded text-xs font-medium">Gagnant !</span>';
                                            } else {
                                                echo '<span class="bg-red-100 text-red-800 px-2 py-1 rounded text-xs font-medium">Perdant</span>';
                                            }
                                        } else {
                                            echo '<span class="bg-gray-100 text-gray-600 px-2 py-1 rounded text-xs font-medium">En attente</span>';
                                        }
                                        echo '</td>';
                                        echo '<td class="py-3 px-4 text-sm font-semibold">';
                                        if($part['gains'] > 0) {
                                            echo '<span class="text-green-600">+' . number_format($part['gains'], 2, ',', ' ') . ' F&</span>';
                                        } else {
                                            echo '<span class="text-gray-400">-</span>';
                                        }
                                        echo '</td>';
                                        echo '</tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="5" class="py-4 text-center text-gray-500">Aucune participation passée</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
            <?php else: ?>
                <!-- Aucune loterie active -->
                <div class="text-center py-12">
                    <div class="bg-gray-100 p-6 rounded-full w-24 h-24 mx-auto mb-6 flex items-center justify-center">
                        <i class="fas fa-dice text-4xl text-gray-400"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">Aucune loterie active</h3>
                    <p class="text-gray-600">Aucune loterie n'est actuellement en cours.</p>
                    <p class="text-sm text-gray-500 mt-2">Revenez bientôt pour tenter votre chance !</p>
                </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

                <div class="tab-content <?php echo $onglet == 'banque' ? 'active' : ''; ?>" id="tab-banque">
                    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                        <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                            <div>
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Compte bancaire
                                </h3>
                                <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                    Gérez vos finances.
                                </p>
                            </div>
                            <div class="px-6 py-4 bg-primary-50 rounded-lg border border-primary-100">
                                <p class="text-sm text-gray-600">Solde actuel</p>
                                <p class="text-2xl font-semibold text-primary-700"><?php echo number_format($solde, 2, ',', ' '); ?> F&</p>
                            </div>
                        </div>
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Effectuer un virement</h4>
                                
                                <?php if(isset($virement_message)): ?>
                                    <div class="mb-4 px-4 py-3 rounded <?php echo $virement_success ? 'bg-green-50 text-green-800' : 'bg-red-50 text-red-800'; ?>">
                                        <?php echo $virement_message; ?>
                                    </div>
                                <?php endif; ?>
                                
                                <form action="" method="POST" class="space-y-4">
                                    <input type="hidden" name="action" value="virement">
                                    
                                    <div>
                                        <label for="id_destinataire" class="block text-sm font-medium text-gray-700">ID du destinataire</label>
                                        <input type="text" name="id_destinataire" id="id_destinataire" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                    </div>
                                    
                                    <div>
                                        <label for="montant" class="block text-sm font-medium text-gray-700">Montant</label>
                                        <div class="mt-1 relative rounded-md shadow-sm">
                                            <input type="number" step="0.01" min="0.01" name="montant" id="montant" required class="block w-full pr-12 border-gray-300 rounded-md focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                                <span class="text-gray-500 sm:text-sm">F&</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <label for="motif" class="block text-sm font-medium text-gray-700">Motif</label>
                                        <input type="text" name="motif" id="motif" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 sm:text-sm">
                                    </div>
                                    
                                    <div>
                                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                            Effectuer le virement
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Votre ID de transfert</h4>
                                <div class="bg-gray-50 p-4 rounded-md border border-gray-200">
                                    <p class="text-center font-mono text-lg"><?php echo $identite ? $identite['code_transfert'] : 'Aucun ID généré'; ?></p>
                                </div>
                                
                                <?php if(!$identite || !$identite['code_transfert']): ?>
                                <form action="" method="POST" class="mt-4">
                                    <input type="hidden" name="action" value="generer_id">
                                    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                        Générer un ID de transfert
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200">
                            <div class="px-4 py-5 sm:p-6">
                                <h4 class="text-md font-medium text-gray-900 mb-4">Dernières transactions</h4>
                                
                                <div class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Destinataire/Émetteur</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Montant</th>
                                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Motif</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <?php
                                            $sql = "SELECT * FROM transactions WHERE user_id = ? OR destinataire_id = ? ORDER BY date DESC LIMIT 10";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("ii", $user_id, $user_id);
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            
                                            if($result->num_rows > 0) {
                                                while($transaction = $result->fetch_assoc()) {
                                                    $type = $transaction['user_id'] == $user_id ? 'Envoi' : 'Réception';
                                                    $montant = $transaction['montant'];
                                                    $montantClass = $type == 'Envoi' ? 'text-red-600' : 'text-green-600';
                                                    $montantPrefix = $type == 'Envoi' ? '-' : '+';
                                                    
                                                    echo '<tr>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . date('d/m/Y H:i', strtotime($transaction['date'])) . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">' . $type . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . ($type == 'Envoi' ? $transaction['destinataire_nom'] : $transaction['emetteur_nom']) . '</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm ' . $montantClass . '">' . $montantPrefix . number_format($montant, 2, ',', ' ') . ' F&</td>';
                                                    echo '<td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">' . $transaction['motif'] . '</td>';
                                                    echo '</tr>';
                                                }
                                            } else {
                                                echo '<tr><td colspan="5" class="px-6 py-4 text-sm text-gray-500 text-center">Aucune transaction récente</td></tr>';
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="tab-content <?php echo $onglet == 'immobilier' ? 'active' : ''; ?>" id="tab-immobilier">
    <?php
    $sql = "SELECT * FROM proprietes WHERE disponible = 1 ORDER BY created_at DESC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $proprietes_disponibles = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    
    $sql = "SELECT p.*, pp.date_achat, pp.prix_achat 
            FROM proprietes p 
            JOIN proprietes_proprietaires pp ON p.id = pp.propriete_id 
            WHERE pp.user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $mes_proprietes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    
    $propriete_detail = null;
    if(isset($_GET['propriete_id'])) {
        $sql = "SELECT * FROM proprietes WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $_GET['propriete_id']);
        $stmt->execute();
        $propriete_detail = $stmt->get_result()->fetch_assoc();
    }
    ?>
    
    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
        <div class="px-4 py-5 sm:px-6 bg-gradient-to-r from-indigo-600 to-blue-600 text-white">
            <h3 class="text-lg leading-6 font-bold flex items-center">
                <i class="fas fa-home mr-3 text-2xl"></i>
                Immobilier Peerkinton
            </h3>
            <p class="mt-1 text-blue-100">
                Découvre et acquiers ta propriété idéale
            </p>
        </div>
        
        <div class="p-6">
            <?php if($propriete_detail): ?>
                <div class="mb-6">
                    <button onclick="window.location.href='?onglet=immobilier'" class="text-blue-600 hover:text-blue-800 mb-4 inline-flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i>Retour aux propriétés
                    </button>
                    
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        <div>
                            <div class="grid grid-cols-1 gap-4">
                                <?php if($propriete_detail['image_1']): ?>
                                    <img src="<?php echo htmlspecialchars($propriete_detail['image_1']); ?>" 
                                         alt="Photo principale" 
                                         class="w-full h-64 object-cover rounded-lg">
                                <?php endif; ?>
                                
                                <div class="grid grid-cols-2 gap-4">
                                    <?php if($propriete_detail['image_2']): ?>
                                        <img src="<?php echo htmlspecialchars($propriete_detail['image_2']); ?>" 
                                             alt="Photo 2" 
                                             class="w-full h-32 object-cover rounded-lg">
                                    <?php endif; ?>
                                    <?php if($propriete_detail['image_3']): ?>
                                        <img src="<?php echo htmlspecialchars($propriete_detail['image_3']); ?>" 
                                             alt="Photo 3" 
                                             class="w-full h-32 object-cover rounded-lg">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900 mb-3">
                                <?php echo htmlspecialchars($propriete_detail['titre']); ?>
                            </h2>
                            
                            <div class="mb-4">
                                <?php
                                $badge_colors = [
                                    'basique' => 'bg-gray-100 text-gray-800',
                                    'luxueux' => 'bg-purple-100 text-purple-800',
                                    'rarissime' => 'bg-yellow-100 text-yellow-800'
                                ];
                                $badge_color = $badge_colors[$propriete_detail['type']] ?? 'bg-gray-100 text-gray-800';
                                ?>
                                <span class="px-3 py-1 rounded-full text-sm font-medium <?php echo $badge_color; ?>">
                                    <?php echo ucfirst($propriete_detail['type']); ?>
                                </span>
                            </div>
                            
                            <div class="text-3xl font-bold text-indigo-600 mb-4">
                                <?php echo number_format($propriete_detail['prix'], 2, ',', ' '); ?> F&
                            </div>
                            
                            <div class="prose text-gray-600 mb-6">
                                <?php echo nl2br(htmlspecialchars($propriete_detail['description'])); ?>
                            </div>
                            
                            <?php if($propriete_detail['disponible']): ?>
                                <form method="POST" onsubmit="return confirm('Confirmer l\'achat de cette propriété pour <?php echo number_format($propriete_detail['prix'], 2, ',', ' '); ?> F& ?')">
                                    <input type="hidden" name="action" value="acheter_propriete">
                                    <input type="hidden" name="propriete_id" value="<?php echo $propriete_detail['id']; ?>">
                                    <button type="submit" class="w-full bg-indigo-600 text-white py-3 px-6 rounded-lg font-bold hover:bg-indigo-700 transition-all duration-200">
                                        <i class="fas fa-shopping-cart mr-2"></i>
                                        Acheter cette propriété
                                    </button>
                                </form>
                            <?php else: ?>
                                <div class="bg-red-50 border border-red-200 rounded-lg p-4 text-red-800">
                                    Cette propriété n'est plus disponible
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="mb-8">
                    <h4 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-key mr-2 text-green-600"></i>
                        Mes propriétés
                    </h4>
                    
                    <?php if(count($mes_proprietes) > 0): ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                            <?php foreach($mes_proprietes as $prop): ?>
                                <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                                    <?php if($prop['image_1']): ?>
                                        <img src="<?php echo htmlspecialchars($prop['image_1']); ?>" 
                                             alt="<?php echo htmlspecialchars($prop['titre']); ?>"
                                             class="w-full h-48 object-cover">
                                    <?php endif; ?>
                                    <div class="p-4">
                                        <h5 class="font-semibold text-gray-900 mb-2"><?php echo htmlspecialchars($prop['titre']); ?></h5>
                                        <p class="text-sm text-gray-600 mb-2">Acheté le <?php echo date('d/m/Y', strtotime($prop['date_achat'])); ?></p>
                                        <p class="text-lg font-bold text-green-600"><?php echo number_format($prop['prix_achat'], 2, ',', ' '); ?> F&</p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-center mb-8">
                            <i class="fas fa-home text-gray-400 text-3xl mb-3"></i>
                            <p class="text-gray-600">Tu ne possèdes aucune propriété pour le moment</p>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div>
                    <h4 class="text-xl font-bold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-building mr-2 text-blue-600"></i>
                        Propriétés disponibles
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php foreach($proprietes_disponibles as $prop): ?>
                            <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow cursor-pointer"
                                 onclick="window.location.href='?onglet=immobilier&propriete_id=<?php echo $prop['id']; ?>'">
                                <?php if($prop['image_1']): ?>
                                    <img src="<?php echo htmlspecialchars($prop['image_1']); ?>" 
                                         alt="<?php echo htmlspecialchars($prop['titre']); ?>"
                                         class="w-full h-48 object-cover">
                                <?php endif; ?>
                                <div class="p-4">
                                    <h5 class="font-semibold text-gray-900 mb-2"><?php echo htmlspecialchars($prop['titre']); ?></h5>
                                    <p class="text-2xl font-bold text-indigo-600"><?php echo number_format($prop['prix'], 2, ',', ' '); ?> F&</p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
                
            
                <div class="tab-content <?php echo $onglet == 'courrier' ? 'active' : ''; ?>" id="tab-courrier">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="md:col-span-1">
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Boîte de réception
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200">
                                    <ul class="divide-y divide-gray-200">
                                        <?php if(count($courriers) > 0): ?>
                                            <?php foreach($courriers as $index => $courrier): ?>
                                                <li>
                                                    <a href="https://peerkinton.com/dashboard.php?onglet=courrier&courrier_id=<?php echo $courrier['id']; ?>" class="block hover:bg-gray-50 <?php echo (isset($_GET['courrier_id']) && $_GET['courrier_id'] == $courrier['id']) ? 'bg-primary-50' : ''; ?>">
                                                        <div class="px-4 py-4 sm:px-6">
                                                            <div class="flex items-center justify-between">
                                                                <p class="text-sm font-medium text-primary-600 truncate">
                                                                    <?php echo htmlspecialchars($courrier['sujet']); ?>
                                                                </p>
                                                                <div class="ml-2 flex-shrink-0 flex">
                                                                    <?php if($courrier['type'] == 'facture'): ?>
                                                                        <p class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                                            Facture
                                                                        </p>
                                                                    <?php elseif($courrier['type'] == 'communication'): ?>
                                                                        <p class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                                                            Communication
                                                                        </p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                            <div class="mt-2 flex justify-between">
                                                                <div class="flex items-center text-sm text-gray-500">
                                                                    <span><?php echo htmlspecialchars($courrier['expediteur']); ?></span>
                                                                </div>
                                                                <div class="text-sm text-gray-500">
                                                                    <span><?php echo date('d/m/Y', strtotime($courrier['date'])); ?></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <li class="px-4 py-5 sm:px-6 text-sm text-gray-500 text-center">
                                                Aucun courrier reçu
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="md:col-span-2">
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <?php
                                $courrier_details = null;
                                if(isset($_GET['courrier_id'])) {
                                    $courrier_id = $_GET['courrier_id'];
                                    foreach($courriers as $c) {
                                        if($c['id'] == $courrier_id) {
                                            $courrier_details = $c;
                                            break;
                                        }
                                    }
                                }
                                
                                if($courrier_details):
                                ?>
                                    <div class="px-4 py-5 sm:px-6">
                                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                                            <?php echo htmlspecialchars($courrier_details['sujet']); ?>
                                        </h3>
                                        <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                            De: <?php echo htmlspecialchars($courrier_details['expediteur']); ?> • 
                                            <?php echo date('d/m/Y à H:i', strtotime($courrier_details['date'])); ?>
                                        </p>
                                    </div>
                                    <div class="border-t border-gray-200 px-4 py-5 sm:px-6">
                                        <div class="prose max-w-none">
                                            <?php echo $courrier_details['contenu']; ?>
                                        </div>
                                        
                                        <?php if($courrier_details['type'] == 'facture'): ?>
                                            <div class="mt-6 border-t border-gray-200 pt-6">
                                                <div class="flex justify-between items-center">
                                                    <div>
                                                        <p class="text-sm font-medium text-gray-700">Montant à payer:</p>
                                                        <p class="text-2xl font-semibold text-gray-900"><?php echo number_format($courrier_details['montant'], 2, ',', ' '); ?> F&</p>
                                                    </div>
                                                    
                                                    <?php if(!$courrier_details['paye']): ?>
                                                        <form action="" method="POST">
                                                            <input type="hidden" name="action" value="regler_facture">
                                                            <input type="hidden" name="facture_id" value="<?php echo $courrier_details['id']; ?>">
                                                            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                                                Régler cette facture
                                                            </button>
                                                        </form>
                                                    <?php else: ?>
                                                        <div class="px-4 py-2 bg-green-100 text-green-800 rounded-md">
                                                            Facture réglée le <?php echo date('d/m/Y', strtotime($courrier_details['date_paiement'])); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <div class="px-4 py-5 sm:px-6 text-center text-gray-500">
                                        <i class="fas fa-envelope-open-text text-5xl mb-3"></i>
                                        <p>Sélectionnez un message pour le consulter</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                

                <div class="tab-content <?php echo $onglet == 'identite' ? 'active' : ''; ?>" id="tab-identite">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Carte d'identité
                                    </h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                        Vos informations personnelles.
                                    </p>
                                </div>
                                
                                <?php if($identite): ?>
                                    <div class="border-t border-gray-200">
                                        <div class="p-6 bg-gradient-to-r from-primary-600 to-primary-800 rounded-lg mx-4 my-5 text-white shadow-lg">
                                            <div class="flex justify-between items-start mb-6">
                                                <div>
                                                    <h4 class="text-xl font-bold mb-1">Peerkinton</h4>
                                                    <p class="text-sm opacity-80">Carte Nationale d'Identité</p>
                                                </div>
                                                <div class="text-right">
                                                    <p class="text-sm opacity-80">ID: <?php echo $identite['id_carte']; ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="grid grid-cols-2 gap-4 mb-4">
                                                <div>
                                                    <p class="text-xs opacity-80">Nom</p>
                                                    <p class="font-medium"><?php echo $identite['nom']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Prénom</p>
                                                    <p class="font-medium"><?php echo $identite['prenom']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Date de naissance</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_naissance'])); ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Lieu de naissance</p>
                                                    <p class="font-medium"><?php echo $identite['lieu_naissance']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Nationalité</p>
                                                    <p class="font-medium"><?php echo $identite['nationalite']; ?></p>
                                                </div>
                                                <div>
                                                    <p class="text-xs opacity-80">Sexe</p>
                                                    <p class="font-medium"><?php echo $identite['sexe']; ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="mt-6 pt-4 border-t border-white border-opacity-20 flex justify-between items-center">
                                                <div>
                                                    <p class="text-xs opacity-80">Date d'émission</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_emission'])); ?></p>
                                                </div>
                                                <div class="text-right">
                                                    <p class="text-xs opacity-80">Date d'expiration</p>
                                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($identite['date_expiration'])); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="border-t border-gray-200 px-4 py-5 sm:p-6 text-center">
                                        <p class="text-gray-500">Aucune carte d'identité trouvée.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mt-6 bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Niveau de notoriété
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                                    <?php
                                    if($identite) {
                                        $notoriete = $identite['notoriete'];
                                        
                                        if($notoriete >= 80) {
                                            $niveau = "Excellente";
                                            $couleur = "green";
                                        } elseif($notoriete >= 60) {
                                            $niveau = "Bonne";
                                            $couleur = "blue";
                                        } elseif($notoriete >= 40) {
                                            $niveau = "Moyenne";
                                            $couleur = "yellow";
                                        } elseif($notoriete >= 20) {
                                            $niveau = "Mauvaise";
                                            $couleur = "orange";
                                        } else {
                                            $niveau = "Très mauvaise";
                                            $couleur = "red";
                                        }
                                    }
                                    ?>
                                    
                                    <?php if($identite): ?>
                                        <div class="text-center mb-4">
                                            <span class="px-3 py-1 text-sm font-medium rounded-full bg-<?php echo $couleur; ?>-100 text-<?php echo $couleur; ?>-800">
                                                <?php echo $niveau; ?>
                                            </span>
                                        </div>
                                        
                                        <div class="relative pt-1">
                                            <div class="overflow-hidden h-2 mb-4 text-xs flex rounded bg-gray-200">
                                                <div style="width:<?php echo $notoriete; ?>%" class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-<?php echo $couleur; ?>-500"></div>
                                            </div>
                                        <div class="flex justify-between text-xs text-gray-600">
                                                <span>0%</span>
                                                <span>50%</span>
                                                <span>100%</span>
                                            </div>
                                        </div>
                                        
                                        <p class="mt-4 text-sm text-gray-600">
                                            Votre notoriété est basée sur vos activités dans la ville. Maintenir une bonne notoriété vous donne accès à plus d'opportunités.
                                        </p>
                                    <?php else: ?>
                                        <p class="text-center text-gray-500">Aucune information de notoriété disponible.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Casier judiciaire
                                    </h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                        Historique des infractions.
                                    </p>
                                </div>
                                <div class="border-t border-gray-200">
                                    <?php if(count($casier) > 0): ?>
                                        <ul class="divide-y divide-gray-200">
                                            <?php foreach($casier as $infraction): ?>
                                                <li class="px-4 py-4 sm:px-6">
                                                    <div class="flex items-start justify-between">
                                                        <div>
                                                            <h4 class="text-sm font-medium text-gray-900"><?php echo $infraction['type']; ?></h4>
                                                            <p class="mt-1 text-sm text-gray-600"><?php echo $infraction['description']; ?></p>
                                                        </div>
                                                        <div class="ml-4 flex-shrink-0">
                                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                                                <?php echo date('d/m/Y', strtotime($infraction['date'])); ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="mt-2">
                                                        <div class="flex items-center text-sm text-gray-500">
                                                            <span>Sanction: <?php echo $infraction['sanction']; ?></span>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php else: ?>
                                        <div class="px-4 py-5 sm:p-6 text-center">
                                            <div class="mb-4">
                                                <i class="fas fa-check-circle text-green-500 text-4xl"></i>
                                            </div>
                                            <h4 class="text-lg font-medium text-gray-900 mb-2">Casier judiciaire vierge</h4>
                                            <p class="text-gray-500">Vous n'avez commis aucune infraction.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mt-6 bg-white shadow overflow-hidden sm:rounded-lg">
                                <div class="px-4 py-5 sm:px-6">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Informations additionnelles
                                    </h3>
                                </div>
                                <div class="border-t border-gray-200">
                                    <dl>
                                        <?php if($identite): ?>
                                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Adresse</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['adresse']; ?></dd>
                                            </div>
                                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Téléphone</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['telephone']; ?></dd>
                                            </div>
                                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Email</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $user['email']; ?></dd>
                                            </div>
                                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                                <dt class="text-sm font-medium text-gray-500">Profession</dt>
                                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?php echo $identite['profession']; ?></dd>
                                            </div>
                                        <?php else: ?>
                                            <div class="px-4 py-5 sm:p-6 text-center">
                                                <p class="text-gray-500">Aucune information additionnelle disponible.</p>
                                            </div>
                                        <?php endif; ?>
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    
    function openSettings() {
    document.getElementById('settingsOverlay').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeSettings() {
    document.getElementById('settingsOverlay').classList.remove('active');
    document.body.style.overflow = '';
    const url = new URL(window.location);
    url.searchParams.delete('settings');
    url.searchParams.delete('message');
    window.history.replaceState({}, '', url);
}

document.addEventListener('DOMContentLoaded', function() {
    if(window.location.search.includes('settings=1')) {
        openSettings();
    }
    
    const tabs = document.querySelectorAll('a[href^="?onglet="]');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabs.forEach(tab => {
        tab.addEventListener('click', function(e) {
            e.preventDefault();
            const onglet = this.getAttribute('href').replace('?onglet=', '');
            
            tabs.forEach(t => {
                t.classList.remove('border-primary-500', 'text-primary-600');
                t.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
            });
            
            this.classList.add('border-primary-500', 'text-primary-600');
            this.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
            
            tabContents.forEach(content => {
                content.classList.remove('active');
            });
            
            document.getElementById('tab-' + onglet).classList.add('active');
            
            window.history.pushState({}, '', '?onglet=' + onglet);
        });
    });
});

        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('a[href^="?onglet="]');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    const onglet = this.getAttribute('href').replace('?onglet=', '');
                    
                    tabs.forEach(t => {
                        t.classList.remove('border-primary-500', 'text-primary-600');
                        t.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
                    });
                    
                    this.classList.add('border-primary-500', 'text-primary-600');
                    this.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
                    
                    tabContents.forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    document.getElementById('tab-' + onglet).classList.add('active');
                    
                    window.history.pushState({}, '', '?onglet=' + onglet);
                });
            });
        });
        
        
        function requestAccountDeletion() {
    if(confirm('Es-tu sûr de vouloir supprimer ton compte ? Un email de confirmation sera envoyé.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.style.display = 'none';
        
        const action = document.createElement('input');
        action.type = 'hidden';
        action.name = 'action';
        action.value = 'delete_account_request';
        
        form.appendChild(action);
        document.body.appendChild(form);
        form.submit();
    }
}

function openHelp() {
    document.getElementById('helpOverlay').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeHelp() {
    document.getElementById('helpOverlay').classList.remove('active');
    document.body.style.overflow = '';
}
    </script>
</body>
</html>