<?php
session_start();

if (!isset($_SESSION['merchant_id'])) {
    header('Location: ../auth/login.php');
    exit();
}

$merchant_id = $_SESSION['merchant_id'];
$merchant_code = $_SESSION['merchant_code'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comm Access - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body class="min-h-screen bg-white dark:bg-black text-black dark:text-white font-light transition-colors duration-300">
    <div class="container mx-auto px-4 py-6">
        <header class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-2xl font-light">Comm Access</h1>
                <p class="text-gray-600 dark:text-gray-400 text-sm">Code: <?= htmlspecialchars($merchant_code) ?></p>
            </div>
            
            <div class="flex items-center space-x-4">
                <div class="flex items-center space-x-2">
                    <span class="text-xs">iOS</span>
                    <div id="ios-status" class="status-online w-3 h-3 rounded-full"></div>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="text-xs">Android</span>
                    <div id="android-status" class="status-online w-3 h-3 rounded-full"></div>
                </div>
                <a href="../auth/logout.php" class="text-sm hover:underline">Déconnexion</a>
            </div>
        </header>

        <nav class="flex space-x-8 border-b border-gray-200 dark:border-gray-800 mb-6">
            <button class="nav-tab active pb-3 text-sm font-light" data-tab="notifications">
                Notifications
                <span id="notif-counter" class="counter-badge ml-2 text-green-500">4</span>
            </button>
            <button class="nav-tab pb-3 text-sm font-light" data-tab="emails">
                Emails
                <span id="email-counter" class="counter-badge ml-2 text-green-500">2</span>
            </button>
            <button class="nav-tab pb-3 text-sm font-light relative" data-tab="communication">
                Communication
                <span id="messages-badge" class="hidden absolute -top-1 -right-2 bg-red-500 text-white text-xs rounded-full px-1">0</span>
            </button>
            <button class="nav-tab pb-3 text-sm font-light relative" data-tab="shop">
                Mon Commerce
                <span id="pending-badge" class="hidden absolute -top-1 -right-2 bg-yellow-500 text-white text-xs rounded-full px-1">0</span>
            </button>
        </nav>

        <div id="notifications" class="tab-content active">
            <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-6">
                <h2 class="text-lg font-light mb-4">Envoyer une notification push</h2>
                <form id="notification-form" action="../api/send-notification.php" method="POST" data-ajax="true">
                    <div class="space-y-4">
                        <textarea 
                            name="message" 
                            placeholder="Votre message..."
                            rows="3"
                            maxlength="200"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black resize-none"
                            required
                        ></textarea>
                        
                        <input type="hidden" name="platform" value="both">
                        
                        <button 
                            type="submit" 
                            data-original-text="Envoyer la notification"
                            class="px-6 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors"
                        >
                            Envoyer la notification
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div id="emails" class="tab-content">
            <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-6">
                <h2 class="text-lg font-light mb-4">Envoyer un email promotionnel</h2>
                <form id="email-form" action="../api/send-email.php" method="POST" data-ajax="true">
                    <div class="space-y-4">
                        <input 
                            type="text" 
                            name="subject" 
                            placeholder="Objet de l'email"
                            maxlength="100"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black"
                            required
                        >
                        
                        <textarea 
                            name="content" 
                            placeholder="Contenu de l'email..."
                            rows="6"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black resize-none"
                            required
                        ></textarea>
                        
                        <button 
                            type="submit" 
                            data-original-text="Envoyer l'email"
                            class="px-6 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors"
                        >
                            Envoyer l'email
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div id="communication" class="tab-content">
            <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-6">
                <h2 class="text-lg font-light mb-4">Contacter notre équipe</h2>
                <form action="../api/save-message.php" method="POST" data-ajax="true">
                    <div class="space-y-4">
                        <input 
                            type="text" 
                            name="subject" 
                            placeholder="Sujet"
                            maxlength="100"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black"
                            required
                        >
                        
                        <textarea 
                            name="message" 
                            placeholder="Votre message..."
                            rows="6"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black resize-none"
                            required
                        ></textarea>
                        
                        <button 
                            type="submit" 
                            data-original-text="Envoyer le message"
                            class="px-6 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors"
                        >
                            Envoyer le message
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div id="shop" class="tab-content">
            <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-6">
                <h2 class="text-lg font-light mb-4">Gestion de mon commerce</h2>
                <p class="text-gray-600 dark:text-gray-400 mb-4">
                    Les modifications seront soumises à validation par notre équipe.
                </p>
                
                <form action="../api/update-shop.php" method="POST" data-ajax="true">
                    <div class="space-y-4">
                        <input 
                            type="text" 
                            name="shop_name" 
                            placeholder="Nom du commerce"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black"
                        >
                        
                        <textarea 
                            name="shop_description" 
                            placeholder="Description du commerce..."
                            rows="3"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black resize-none"
                        ></textarea>
                        
                        <input 
                            type="text" 
                            name="shop_address" 
                            placeholder="Adresse"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black"
                        >
                        
                        <input 
                            type="tel" 
                            name="shop_phone" 
                            placeholder="Téléphone"
                            class="w-full px-4 py-3 border border-gray-300 dark:border-gray-700 rounded-lg bg-white dark:bg-black"
                        >
                        
                        <button 
                            type="submit" 
                            data-original-text="Soumettre les modifications"
                            class="px-6 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors"
                        >
                            Soumettre les modifications
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <footer class="mt-12 text-center text-xs text-gray-500 dark:text-gray-400">
            <p>© 2025 aktascorp. Tous droits réservés.</p>
        </footer>
    </div>

    <script src="../assets/script.js"></script>
</body>
</html>