<!DOCTYPE html>
<html lang="en" class="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak Aktas</title>
    <link rel="icon" type="image/x-icon" href="https://forchange.me/profile_picture.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=general-sans@500,400,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --bg-light: #f8fafc;
            --text-light: #0f172a;
            --accent-light: #eab308;
            --card-light: rgba(255, 255, 255, 0.7);
            --border-light: rgba(226, 232, 240, 0.8);
            
            --bg-dark: #0f172a;
            --text-dark: #f8fafc;
            --accent-dark: #facc15;
            --card-dark: rgba(30, 41, 59, 0.7);
            --border-dark: rgba(51, 65, 85, 0.8);
        }

        .light {
            --bg: var(--bg-light);
            --text: var(--text-light);
            --accent: var(--accent-light);
            --card: var(--card-light);
            --border: var(--border-light);
        }
        
        .dark {
            --bg: var(--bg-dark);
            --text: var(--text-dark);
            --accent: var(--accent-dark);
            --card: var(--card-dark);
            --border: var(--border-dark);
        }

        body {
            font-family: 'General Sans', sans-serif;
            background-color: var(--bg);
            color: var(--text);
            transition: background-color 0.5s ease, color 0.5s ease;
            overflow-x: hidden;
            font-weight: 300;
        }

        .noise {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 300 300' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.1'/%3E%3C/svg%3E");
            z-index: 1000;
            pointer-events: none;
            opacity: 0.3;
            animation: grain 8s steps(10) infinite;
            mix-blend-mode: overlay;
        }

        @keyframes grain {
            0%, 100% { transform: translate(0, 0) scale(1.1); }
            10% { transform: translate(-1%, -1%) scale(1.1); }
            20% { transform: translate(1%, 1%) scale(1.1); }
            30% { transform: translate(-2%, -1%) scale(1.1); }
            40% { transform: translate(3%, 1%) scale(1.1); }
            50% { transform: translate(-3%, -2%) scale(1.1); }
            60% { transform: translate(2%, 2%) scale(1.1); }
            70% { transform: translate(-1%, -2%) scale(1.1); }
            80% { transform: translate(1%, 1%) scale(1.1); }
            90% { transform: translate(2%, -1%) scale(1.1); }
        }

        .glow {
            position: fixed;
            border-radius: 50%;
            pointer-events: none;
            z-index: -1;
            opacity: 0.5;
            transition: background 0.5s ease;
        }

        .light .glow-1 {
            top: -250px;
            right: -250px;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(234, 179, 8, 0.1) 0%, rgba(234, 179, 8, 0) 70%);
        }

        .light .glow-2 {
            bottom: -150px;
            left: -150px;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(234, 179, 8, 0.08) 0%, rgba(234, 179, 8, 0) 70%);
        }

        .dark .glow-1 {
            top: -250px;
            right: -250px;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(250, 204, 21, 0.1) 0%, rgba(250, 204, 21, 0) 70%);
        }

        .dark .glow-2 {
            bottom: -150px;
            left: -150px;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(250, 204, 21, 0.08) 0%, rgba(250, 204, 21, 0) 70%);
        }

        .header {
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            background-color: rgba(248, 250, 252, 0.8);
            border-bottom: 1px solid var(--border);
            transition: background-color 0.5s ease, border-color 0.5s ease;
        }

        .dark .header {
            background-color: rgba(15, 23, 42, 0.8);
        }

        .section-title {
            position: relative;
            display: inline-block;
            font-weight: 300;
        }

        .section-title::after {
            content: "";
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 40px;
            height: 2px;
            background: var(--accent);
            transition: background-color 0.5s ease;
        }

        .card {
            background-color: var(--card);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 1rem;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275), background-color 0.5s ease;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.01), 0 2px 4px -1px rgba(0, 0, 0, 0.01);
            border: 1px solid var(--border);
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.05), 0 8px 10px -6px rgba(0, 0, 0, 0.01);
        }

        .tag {
            display: inline-block;
            font-size: 0.75rem;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            background-color: rgba(var(--accent-rgb), 0.1);
            color: var(--accent);
            transition: all 0.3s ease, background-color 0.5s ease, color 0.5s ease;
        }

        .light .tag {
            --accent-rgb: 234, 179, 8;
            color: #92400e;
            background-color: rgba(234, 179, 8, 0.1);
        }

        .dark .tag {
            --accent-rgb: 250, 204, 21;
            color: #facc15;
            background-color: rgba(250, 204, 21, 0.1);
        }

        .tag:hover {
            background-color: rgba(var(--accent-rgb), 0.2);
        }

        .image-container {
            overflow: hidden;
            position: relative;
            border-radius: 0.5rem;
        }

        .image-zoom {
            transition: transform 0.7s cubic-bezier(0.19, 1, 0.22, 1);
        }

        .image-container:hover .image-zoom {
            transform: scale(1.05);
        }

        .accent-text {
            color: var(--accent);
            transition: color 0.5s ease;
        }

        .light .accent-text {
            color: #ca8a04;
        }

        .dark .accent-text {
            color: #facc15;
        }

        .nav-container {
            position: fixed;
            left: 0;
            right: 0;
            bottom: 2rem;
            display: flex;
            justify-content: center;
            z-index: 100;
            transition: transform 0.3s;
        }

        .mobile-nav {
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            background-color: var(--card);
            padding: 0.75rem;
            border-radius: 9999px;
            display: flex;
            gap: 0.75rem;
            opacity: 0;
            transition: opacity 0.3s, transform 0.3s, background-color 0.5s ease;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
            border: 1px solid var(--border);
        }

        .nav-button {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 9999px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: transparent;
            color: var(--text);
            border: none;
            cursor: pointer;
            transition: all 0.3s ease, color 0.5s ease;
        }

        .nav-button:hover {
            background-color: rgba(var(--accent-rgb), 0.1);
        }

        .light .nav-button:hover {
            --accent-rgb: 234, 179, 8;
        }

        .dark .nav-button:hover {
            --accent-rgb: 250, 204, 21;
        }

        .nav-button.active {
            background-color: var(--text);
            color: var(--bg);
        }

        .reveal {
            opacity: 0;
            transform: translateY(30px);
            transition: opacity 0.8s ease, transform 0.8s ease;
        }

        .theme-switch {
            position: fixed;
            top: 1.5rem;
            right: 1.5rem;
            width: 2.5rem;
            height: 2.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 9999px;
            background-color: var(--card);
            color: var(--text);
            border: 1px solid var(--border);
            cursor: pointer;
            z-index: 100;
            transition: background-color 0.5s ease, color 0.5s ease, border-color 0.5s ease;
        }

        .theme-switch:hover {
            background-color: rgba(var(--accent-rgb), 0.1);
        }

        .light .theme-switch:hover {
            --accent-rgb: 234, 179, 8;
        }

        .dark .theme-switch:hover {
            --accent-rgb: 250, 204, 21;
        }

        ::selection {
            background-color: rgba(var(--accent-rgb), 0.3);
            color: var(--text);
        }

        .light ::selection {
            --accent-rgb: 234, 179, 8;
        }

        .dark ::selection {
            --accent-rgb: 250, 204, 21;
        }
    </style>
</head>
<body>
    <div class="noise"></div>
    <div class="glow glow-1"></div>
    <div class="glow glow-2"></div>

    <button class="theme-switch" aria-label="Toggle dark mode">
        <i class="fas fa-moon dark:hidden"></i>
        <i class="fas fa-sun hidden dark:block"></i>
    </button>

    <header class="header py-6 sticky top-0 z-50">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center">
                <h1 class="text-4xl font-bold tracking-tight">
                    Izhak<span class="accent-text">.</span>
                </h1>
                <p class="text-sm max-w-xs text-right font-light">
                    Web Developer &<br>
                    <span class="font-medium">CEO of Imators</span>
                </p>
            </div>
        </div>
    </header>

    <main>
        <section id="intro" class="py-20 md:py-36">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="max-w-2xl">
                    <span class="inline-block text-sm font-light tracking-wide mb-4 opacity-60">
                        Summer Season
                    </span>
                    <h2 class="text-5xl sm:text-6xl font-light tracking-tight mb-8 leading-tight">
                        To <span class="accent-text font-semibold">fascinate</span>, discover & smile.
                    </h2>
                    <p class="text-xl opacity-80 mb-12 max-w-xl leading-relaxed font-light">
                        For me, every day makes us learn something new or enjoy everyday life. My goal has always been to share, observe and appreciate the moment day by day.
                    </p>
                    <a href="https://discord.com/users/866001325657292801" class="inline-flex items-center gap-2 bg-yellow-400 dark:bg-yellow-500 text-slate-900 px-8 py-3 rounded-full font-medium hover:bg-yellow-500 dark:hover:bg-yellow-400 transition-colors shadow-lg shadow-yellow-200/40 dark:shadow-yellow-900/20">
                        Let's talk
                        <i class="fa-brands fa-discord"></i>
                    </a>
                </div>
            </div>
        </section>

        <section id="about" class="py-24">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="section-title text-3xl mb-16">ABOUT ME</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
                    <div class="card p-8 reveal">
                        <h3 class="text-xl font-medium mb-6">My Journey</h3>
                        <p class="opacity-80 mb-6 font-light">
                            I'm a web developer and entrepreneur based in Europe. My journey in tech started with a simple curiosity about how websites work, and it has evolved into a passion for creating digital experiences that matter.
                        </p>
                        <p class="opacity-80 font-light">
                            As the CEO of Imators, I lead a team dedicated to developing technology that enhances daily life without compromising human connection. We believe in innovation that serves people, not the other way around.
                        </p>
                    </div>
                    
                    <div class="card p-8 reveal" style="transition-delay: 0.2s;">
                        <h3 class="text-xl font-medium mb-6">My Approach</h3>
                        <p class="opacity-80 mb-6 font-light">
                            I have over three years' experience in web design and development. My passion began by creating small websites, then learning, discovering and being able to create with joy and enthusiasm.
                        </p>
                        <p class="opacity-80 font-light">
                            My goal has always been to make people have a pleasant experience with me and above all to establish a correct social bond. I go beyond the mission/project: I enter the mindset of customers to really understand how they want their request.
                        </p>
                    </div>
                </div>
            </div>
        </section>

        <section id="projects" class="py-24 bg-white/20 dark:bg-slate-800/10">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="section-title text-3xl mb-16">MY PROJECTS</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
                    <div class="card p-6 reveal">
                        <div class="image-container mb-6">
                            <img src="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001" 
                                 alt="Imators Platform" class="w-full aspect-video object-cover image-zoom">
                        </div>
                        <h3 class="text-xl font-medium mb-2">Imators</h3>
                        <div class="flex items-center justify-between mb-4">
                            <span class="tag">2022</span>
                            <div class="flex gap-2">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                            </div>
                        </div>
                        <p class="opacity-70 mb-6 text-sm font-light">
                            Imators is my company. When I set up the company, I had the overriding objective of never using AI for automation or any other purpose. Our aim is to preserve the human being and push him forward by letting him be the actor of what he owns.
                        </p>
                        <a href="https://imators.com" class="inline-flex items-center text-sm hover:text-yellow-600 dark:hover:text-yellow-400 transition-colors">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>

                    <div class="card p-6 reveal" style="transition-delay: 0.2s;">
                        <div class="image-container mb-6">
                            <img src="https://www.worldclassweddingvenues.com/Images/worldclassweddingvenues/User_0/Venue_17816/villattitude-exterieur-11-copie.jpg" 
                                 alt="Vert Chasseur" class="w-full aspect-video object-cover image-zoom">
                        </div>
                        <h3 class="text-xl font-medium mb-2">Vert Chasseur</h3>
                        <div class="flex items-center justify-between mb-4">
                            <span class="tag">2025</span>
                            <div class="flex gap-2">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                            </div>
                        </div>
                        <p class="opacity-70 mb-6 text-sm font-light">
                            The aim of this site is to provide a little hobby. I designed it for the area where I spend most of my days. I'm going to make it progress little by little but it's not my priority, just a little occupation.
                        </p>
                        <a href="https://vertchasseur.com" class="inline-flex items-center text-sm hover:text-yellow-600 dark:hover:text-yellow-400 transition-colors">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>

                    <div class="card p-6 reveal" style="transition-delay: 0.4s;">
                        <div class="image-container mb-6">
                            <img src="https://opengraph.b-cdn.net/production/images/7d08cca6-56aa-42d1-a641-f9f44914ea12.png?token=jXDBoGRjIgGiGA3pNhDAtPJ8odoJIiQ_1zznvH6RNR0&height=630&width=1200&expires=33258602552" 
                                 alt="Gemance" class="w-full aspect-video object-cover image-zoom">
                        </div>
                        <h3 class="text-xl font-medium mb-2">Gemance</h3>
                        <div class="flex items-center justify-between mb-4">
                            <span class="tag">2023</span>
                            <div class="flex gap-2">
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                                <span class="tag">StripeAPI</span>
                            </div>
                        </div>
                        <p class="opacity-70 mb-6 text-sm font-light">
                            For a brief moment, I was thinking of selling the stones I was collecting. Unfortunately this project was going to take me too much time. So I left them on display.
                        </p>
                        <a href="https://www.gemance.com/" class="inline-flex items-center text-sm hover:text-yellow-600 dark:hover:text-yellow-400 transition-colors">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>

                    <div class="card p-6 reveal" style="transition-delay: 0.6s;">
                        <div class="image-container mb-6">
                            <img src="peerkinton_image.png" 
                                 alt="Peerkinton" class="w-full aspect-video object-cover image-zoom">
                        </div>
                        <h3 class="text-xl font-medium mb-2">Peerkinton</h3>
                        <div class="flex items-center justify-between mb-4">
                            <span class="tag">2025</span>
                            <div class="flex gap-2">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                            </div>
                        </div>
                        <p class="opacity-70 mb-6 text-sm font-light">
                            Peerkinton was founded in England in 2016. The aim was to create an institution dedicated to technological learning and study by offering our members high-end digital access.
                        </p>
                        <a href="https://peerkinton.com" class="inline-flex items-center text-sm hover:text-yellow-600 dark:hover:text-yellow-400 transition-colors">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <section id="skills" class="py-24">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="section-title text-3xl mb-16">SKILLS & DETAILS</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="card p-8 reveal">
                        <div class="flex items-start justify-between mb-6">
                            <h3 class="text-xl font-medium">Experience</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-500 dark:text-yellow-400">
                                <rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect>
                                <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
                            </svg>
                        </div>
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Years Active</span>
                                <span class="font-medium">3+</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Projects Completed*</span>
                                <span class="font-medium">257+</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Companies Founded</span>
                                <span class="font-medium">1</span>
                            </div>
                        </div>
                    </div>

                    <div class="card p-8 reveal" style="transition-delay: 0.2s;">
                        <div class="flex items-start justify-between mb-6">
                            <h3 class="text-xl font-medium">Tech Stack</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-500 dark:text-yellow-400">
                                <polyline points="16 18 22 12 16 6"></polyline>
                                <polyline points="8 6 2 12 8 18"></polyline>
                            </svg>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <span class="tag">HTML</span>
                            <span class="tag">CSS</span>
                            <span class="tag">JavaScript</span>
                            <span class="tag">Java</span>
                            <span class="tag">PHP</span>
                            <span class="tag">SQL</span>
                            <span class="tag">Apache</span>
                            <span class="tag">Python</span>
                            <span class="tag">C++</span>
                        </div>
                    </div>

                    <div class="card p-8 reveal" style="transition-delay: 0.4s;">
                        <div class="flex items-start justify-between mb-6">
                            <h3 class="text-xl font-medium">Focus</h3>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-500 dark:text-yellow-400">
                                <circle cx="12" cy="12" r="10"></circle>
                                <circle cx="12" cy="12" r="6"></circle>
                                <circle cx="12" cy="12" r="2"></circle>
                            </svg>
                        </div>
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Main Project</span>
                                <span class="font-medium">Imators</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Learning</span>
                                <span class="font-medium">React Native</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="opacity-70 font-light">Location</span>
                                <span class="font-medium">Europe</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="media" class="py-24 bg-white/20 dark:bg-slate-800/10">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="section-title text-3xl mb-16">MEDIA & CULTURE</h2>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                    <div class="card p-4 reveal">
                        <div class="image-container mb-4 aspect-square">
                            <img src="https://media.pitchfork.com/photos/6662e6122ce1ce711b18e944/master/w_1280%2Cc_limit/Sabrina-Carpenter-Short-n-Sweet.jpg" 
                                 class="w-full h-full object-cover image-zoom" alt="Album cover">
                        </div>
                        <h3 class="font-medium mb-1">Short n' Sweet</h3>
                        <p class="text-sm opacity-60 mb-2 font-light">Sabrina Carpenter</p>
                        <a href="https://music.apple.com/uk/album/short-n-sweet/1750307020" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple Music</a>
                    </div>
                    
                    <div class="card p-4 reveal" style="transition-delay: 0.15s;">
                        <div class="image-container mb-4 aspect-square">
                            <img src="https://i.scdn.co/image/ab67616d0000b273d0bbd3ea2ec554f17a6603cc" 
                                 class="w-full h-full object-cover image-zoom" alt="Album cover">
                        </div>
                        <h3 class="font-medium mb-1">An Evening with Silk Sonic</h3>
                        <p class="text-sm opacity-60 mb-2 font-light">Bruno Mars & Anderson .Paak</p>
                        <a href="https://music.apple.com/album/short-n-sweet/1728313338" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple Music</a>
                    </div>
                    
                    <div class="card p-4 reveal" style="transition-delay: 0.3s;">
                        <div class="image-container mb-4 aspect-square">
                            <img src="https://i.scdn.co/image/ab67616d0000b273e8107e6d9214baa81bb79bba" 
                                 class="w-full h-full object-cover image-zoom" alt="Album cover">
                        </div>
                        <h3 class="font-medium mb-1">GIRL</h3>
                        <p class="text-sm opacity-60 mb-2 font-light">Pharrell Williams</p>
                        <a href="https://music.apple.com/be/album/g-i-r-l/863835302" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple Music</a>
                    </div>
                    
                    <div class="card p-4 reveal" style="transition-delay: 0.45s;">
                        <div class="image-container mb-4 aspect-square">
                            <img src="https://i.scdn.co/image/ab67616d0000b2734bc66095f8a70bc4e6593f4f" 
                                 class="w-full h-full object-cover image-zoom" alt="Album cover">
                        </div>
                        <h3 class="font-medium mb-1">Future Nostalgia</h3>
                        <p class="text-sm opacity-60 mb-2 font-light">Dua Lipa</p>
                        <a href="https://music.apple.com/be/album/future-nostalgia/1538003494" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <section id="watch" class="py-24">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="section-title text-3xl mb-16">WATCHING NOW</h2>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-8">
                    <div class="card p-4 reveal">
                        <div class="image-container mb-4 aspect-[2/3]">
                            <img src="https://seriesonweb.com/wp-content/uploads/2024/04/Sugar.jpg" 
                                 class="w-full h-full object-cover image-zoom" alt="Sugar">
                        </div>
                        <h3 class="font-medium mb-1">Sugar</h3>
                        <div class="flex items-center gap-2">
                            <span class="tag">Series</span>
                            <a href="https://tv.apple.com/be/show/sugar/umc.cmc.4r6q7tdquewehwvb3rzl0k3dtm" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple TV+</a>
                        </div>
                    </div>

                    <div class="card p-4 reveal" style="transition-delay: 0.2s;">
                        <div class="image-container mb-4 aspect-[2/3]">
                            <img src="https://preview.redd.it/fly-me-to-the-moon-2024-textless-v0-y4htoeerwezc1.jpeg?auto=webp&s=841eca3463d5408f09090df6a2a7e645eee100f9" 
                                 class="w-full h-full object-cover image-zoom" alt="To The Moon">
                        </div>
                        <h3 class="font-medium mb-1">Fly Me to The Moon</h3>
                        <div class="flex items-center gap-2">
                            <span class="tag">Movie</span>
                            <a href="https://tv.apple.com/be/movie/to-the-moon/umc.cmc.7bwrikjdeik56bk49vlr7c1h6" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Apple TV+</a>
                        </div>
                    </div>

                    <div class="card p-4 reveal" style="transition-delay: 0.4s;">
                        <div class="image-container mb-4 aspect-[2/3]">
                            <img src="https://resize.elle.fr/original/var/plain_site/storage/images/loisirs/series/ces-films-et-series-a-regarder-si-vous-avez-aime-lupin-dans-l-ombre-d-arsene/94289862-3-fre-FR/7-films-et-series-a-regarder-si-vous-avez-aime-Lupin-dans-l-ombre-d-Arsene.jpg" 
                                 class="w-full h-full object-cover image-zoom" alt="Lupin">
                        </div>
                        <h3 class="font-medium mb-1">Lupin</h3>
                        <div class="flex items-center gap-2">
                            <span class="tag">Series</span>
                            <a href="#" class="text-yellow-600 dark:text-yellow-400 text-xs hover:underline">Netflix</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="py-16 border-t border-slate-200 dark:border-slate-800">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row justify-between items-center gap-8">
                <div>
                    <h3 class="text-2xl font-bold mb-2">Izhak<span class="accent-text">.</span></h3>
                    <p class="opacity-60 text-sm font-light">Designed with a smile.</p>
                </div>
                <div class="text-center md:text-right">
                    <p class="opacity-60 text-sm font-light">The images used on this site are for illustrative purposes only.</p>
                    <p class="opacity-60 text-sm font-light">*This number indicates customer projects, not personal ones.</p>
                </div>
            </div>
        </div>
    </footer>

    <div class="nav-container">
        <nav class="mobile-nav">
            <button class="nav-button" data-section="1">
                <i class="fas fa-home"></i>
            </button>
            <button class="nav-button" data-section="2">
                <i class="fas fa-user"></i>
            </button>
            <button class="nav-button" data-section="3">
                <i class="fas fa-briefcase"></i>
            </button>
            <button class="nav-button" data-section="4">
                <i class="fas fa-code"></i>
            </button>
            <button class="nav-button" data-section="5">
                <i class="fas fa-music"></i>
            </button>
            <button class="nav-button" data-section="6">
                <i class="fas fa-film"></i>
            </button>
        </nav>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Système de thème jour/nuit
            const htmlElement = document.documentElement;
            const themeSwitch = document.querySelector('.theme-switch');
            const moonIcon = themeSwitch.querySelector('.fa-moon');
            const sunIcon = themeSwitch.querySelector('.fa-sun');
            
            // Vérifier les préférences système
            const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            // Appliquer le thème selon les préférences système
            if (prefersDark) {
                htmlElement.classList.remove('light');
                htmlElement.classList.add('dark');
                moonIcon.classList.add('hidden');
                sunIcon.classList.remove('hidden');
            }
            
            // Changer de thème au clic
            themeSwitch.addEventListener('click', () => {
                htmlElement.classList.toggle('light');
                htmlElement.classList.toggle('dark');
                moonIcon.classList.toggle('hidden');
                sunIcon.classList.toggle('hidden');
            });
            
            // Écouter les changements de préférences système
            window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
                if (e.matches) {
                    htmlElement.classList.remove('light');
                    htmlElement.classList.add('dark');
                    moonIcon.classList.add('hidden');
                    sunIcon.classList.remove('hidden');
                } else {
                    htmlElement.classList.add('light');
                    htmlElement.classList.remove('dark');
                    moonIcon.classList.remove('hidden');
                    sunIcon.classList.add('hidden');
                }
            });
            
            // Animation au défilement
            const mobileNav = document.querySelector('.mobile-nav');
            const navButtons = document.querySelectorAll('.nav-button');
            const sections = document.querySelectorAll('section');
            const revealElements = document.querySelectorAll('.reveal');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            });
            
            revealElements.forEach(el => observer.observe(el));
            
            const sectionObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const currentSection = entry.target;
                        const index = Array.from(sections).indexOf(currentSection);
                        
                        updateActiveButton(index + 1);
                        
                        if (index === 0 && entry.intersectionRatio > 0.7) {
                            mobileNav.style.opacity = '0';
                            mobileNav.style.transform = 'translateY(20px)';
                        } else {
                            mobileNav.style.opacity = '1';
                            mobileNav.style.transform = 'translateY(0)';
                        }
                    }
                });
            }, { 
                threshold: [0.2, 0.5, 0.7],
                rootMargin: '-10% 0px -10% 0px'
            });
            
            sections.forEach(section => sectionObserver.observe(section));
            
            function updateActiveButton(sectionNumber) {
                navButtons.forEach(button => {
                    const buttonSection = parseInt(button.dataset.section);
                    button.classList.remove('active');
                    
                    if (buttonSection === sectionNumber) {
                        button.classList.add('active');
                    }
                });
            }
            
            navButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const sectionNumber = parseInt(button.dataset.section);
                    
                    if (sectionNumber > 0 && sectionNumber <= sections.length) {
                        updateActiveButton(sectionNumber);
                        
                        sections[sectionNumber - 1].scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
            
            window.addEventListener('scroll', () => {
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (scrollTop > 100) {
                    mobileNav.style.opacity = '1';
                    mobileNav.style.transform = 'translateY(0)';
                } else {
                    mobileNav.style.opacity = '0';
                    mobileNav.style.transform = 'translateY(20px)';
                }
            });
            
            // Parallaxe amélioré
            const handleMouseMove = (e) => {
                const { clientX, clientY } = e;
                const x = clientX / window.innerWidth;
                const y = clientY / window.innerHeight;
                
                const glows = document.querySelectorAll('.glow');
                
                glows.forEach((glow, index) => {
                    const factorX = index === 0 ? 1 : -1;
                    const factorY = index === 0 ? 1 : -1;
                    const strengthX = index === 0 ? 40 : 30;
                    const strengthY = index === 0 ? 40 : 30;
                    
                    glow.style.transform = `translate(${factorX * (x - 0.5) * strengthX}px, ${factorY * (y - 0.5) * strengthY}px)`;
                });
            };
            
            window.addEventListener('mousemove', handleMouseMove);
            
            // Initialisation
            window.addEventListener('load', () => {
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                let activeSectionIndex = 0;
                
                sections.forEach((section, index) => {
                    const sectionTop = section.offsetTop;
                    const sectionHeight = section.offsetHeight;
                    
                    if (scrollTop >= sectionTop - 100 && scrollTop < sectionTop + sectionHeight - 100) {
                        activeSectionIndex = index;
                    }
                });
                
                updateActiveButton(activeSectionIndex + 1);
                
                if (scrollTop > 100) {
                    mobileNav.style.opacity = '1';
                    mobileNav.style.transform = 'translateY(0)';
                }
            });
        });
    </script>
</body>
</html>