<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ISE Engine - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-white min-h-screen">
    <header class="fixed w-full top-0 bg-white/80 backdrop-blur-sm border-b border-gray-100 z-50">
        <div class="container mx-auto px-6 py-4">
            <div class="flex justify-between items-center">
                <div class="text-2xl font-bold text-gray-900">ISE Engine</div>
                <div class="md:hidden">
                    <button id="menu-toggle" class="text-gray-600 hover:text-gray-900">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
                <nav class="hidden md:flex space-x-8">
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Accueil</a>
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">À propos</a>
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Contact</a>
                </nav>
            </div>
            <div id="mobile-menu" class="md:hidden hidden mt-4 pb-4">
                <nav class="flex flex-col space-y-4">
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Accueil</a>
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">À propos</a>
                    <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Contact</a>
                </nav>
            </div>
        </div>
    </header>

    <main class="pt-20">
        <section class="container mx-auto px-6 py-20">
            <div class="text-center mb-16">
                <h1 class="text-5xl md:text-6xl font-bold text-gray-900 mb-6">Bienvenue sur ISE Engine</h1>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto">La nouvelle génération de moteur de recherche intelligent par Imators</p>
            </div>

            <div class="max-w-4xl mx-auto">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 text-center">
                    <div class="decrypt-item opacity-0" data-word="Search" data-icon="fas fa-search">
                        <div class="text-6xl text-blue-500 mb-6">
                            <i class="fas fa-search"></i>
                        </div>
                        <h3 class="text-3xl font-bold text-gray-900 mb-4 encrypted-text">##11&&&&</h3>
                    </div>

                    <div class="decrypt-item opacity-0" data-word="Find" data-icon="fas fa-crosshairs">
                        <div class="text-6xl text-green-500 mb-6">
                            <i class="fas fa-crosshairs"></i>
                        </div>
                        <h3 class="text-3xl font-bold text-gray-900 mb-4 encrypted-text">##11&&&&</h3>
                    </div>

                    <div class="decrypt-item opacity-0" data-word="And" data-icon="fas fa-plus">
                        <div class="text-6xl text-purple-500 mb-6">
                            <i class="fas fa-plus"></i>
                        </div>
                        <h3 class="text-3xl font-bold text-gray-900 mb-4 encrypted-text">##11&&&&</h3>
                    </div>

                    <div class="decrypt-item opacity-0" data-word="Be a human, not a ai" data-icon="fas fa-heart">
                        <div class="text-6xl text-red-500 mb-6">
                            <i class="fas fa-heart"></i>
                        </div>
                        <h3 class="text-3xl font-bold text-gray-900 mb-4 encrypted-text">##11&&&&</h3>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <script>
        const menuToggle = document.getElementById('menu-toggle');
        const mobileMenu = document.getElementById('mobile-menu');
        
        menuToggle.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        function decryptText(element, finalText, duration = 2000) {
            const chars = '##11&&&&@#$%^&*()';
            const steps = 20;
            const stepDuration = duration / steps;
            let currentStep = 0;

            const interval = setInterval(() => {
                let result = '';
                
                for (let i = 0; i < finalText.length; i++) {
                    if (i < (finalText.length * currentStep / steps)) {
                        result += finalText[i];
                    } else {
                        result += chars[Math.floor(Math.random() * chars.length)];
                    }
                }
                
                element.textContent = result;
                currentStep++;
                
                if (currentStep > steps) {
                    clearInterval(interval);
                    element.textContent = finalText;
                }
            }, stepDuration);
        }

        function startDecryption() {
            const items = document.querySelectorAll('.decrypt-item');
            
            items.forEach((item, index) => {
                setTimeout(() => {
                    item.style.opacity = '1';
                    item.style.transform = 'translateY(0)';
                    item.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                    
                    const textElement = item.querySelector('.encrypted-text');
                    const finalWord = item.dataset.word;
                    
                    setTimeout(() => {
                        decryptText(textElement, finalWord);
                    }, 500);
                }, index * 1000);
            });
        }

        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.decrypt-item').forEach(item => {
                item.style.transform = 'translateY(20px)';
            });
            
            setTimeout(startDecryption, 1000);
        });
    </script>
</body>
</html>