<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Product</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
            height: 100vh;
            overflow: hidden;
        }

        .main-container {
            display: grid;
            grid-template-rows: 1fr auto;
            height: 100vh;
        }

        .content-area {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .grid-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 50% 50%, rgba(255, 255, 255, 0.15) 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.3;
            z-index: -1;
        }

        .highlight {
            color: #FFFFFF;
            position: relative;
            display: inline-block;
        }

        .highlight::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 8px;
            bottom: 5px;
            left: 0;
            background-color: rgba(255, 255, 255, 0.15);
            z-index: -1;
        }

        .feature-item {
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .feature-item:hover {
            border-left: 1px solid rgba(255, 255, 255, 0.3);
        }

        .product-tab {
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
        }

        .product-tab.active {
            border-bottom: 2px solid #FFFFFF;
        }

        .product-tab:hover:not(.active) {
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
        }

        .demo-button {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .demo-button:hover {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .api-box {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        @media (max-width: 768px) {
            .main-container {
                overflow-y: auto;
            }
            
            .product-tabs {
                flex-wrap: wrap;
            }
            
            .product-tab {
                width: 50%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="grid-background"></div>
    <div class="main-container">
        <div class="content-area p-4 overflow-y-auto">
            <div class="max-w-5xl mx-auto">
                <!-- Logo and Main Text -->
                <div class="mb-10 md:mb-16">
                    <div class="flex items-center mb-8">
                        <img src="traffic_logo.png" alt="Imators Product" class="rounded-md w-12 h-12 mr-4">
                        <h1 class="text-2xl font-light">TrafficLight</h1>
                    </div>
                    <h2 class="text-4xl md:text-4xl font-light leading-tight mb-6">
                        A solution to see<br> what your city hasn't added.
                    </h2>
                    <p class="text-zinc-400 text-xl max-w-2xl">
                    With TrafficLight, you can get detailed, live traffic information, thanks to the addition of the community and a cutting-edge system.
                    </p>
                </div>
                
                <!-- Product Tabs -->
                <div class="mb-8">
                    <div class="product-tabs flex mb-8 border-b border-zinc-800">
                        <div class="product-tab active px-6 py-3 cursor-pointer" onclick="changeTab('features')">
                            <i class="fa fa-cube mr-2"></i> Fonctionnalités
                        </div>
                        <div class="product-tab px-6 py-3 cursor-pointer" onclick="changeTab('api')">
                            <i class="fa fa-code mr-2"></i> API
                        </div>
                        <div class="product-tab px-6 py-3 cursor-pointer" onclick="changeTab('integrations')">
                            <i class="fa fa-plug mr-2"></i> Intégrations
                        </div>
                    </div>
                    
                    <!-- Features Tab Content -->
                    <div id="features" class="tab-content">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-10">
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-bolt text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Performance Optimisée</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Infrastructure haute performance avec temps de réponse ultra-rapide.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-shield-halved text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Sécurité Avancée</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Protection robuste avec cryptage de bout en bout.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-chart-line text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Analyses Détaillées</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Statistiques en temps réel et rapports personnalisables.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-cloud text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Cloud Natif</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Déploiement instantané sur notre infrastructure cloud.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-users text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Collaboration</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Outils de travail d'équipe intégrés pour une productivité accrue.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-mobile-screen text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Mobile Ready</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Expérience utilisateur optimisée sur tous les appareils.</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- API Tab Content -->
                    <div id="api" class="tab-content hidden">
                        <div class="mb-6">
                            <h3 class="text-2xl font-light mb-4">API RESTful Complète</h3>
                            <p class="text-zinc-400 mb-6">Notre API vous permet d'intégrer facilement toutes les fonctionnalités de notre produit dans vos applications existantes.</p>
                            
                            <div class="api-box p-4 rounded-md mb-8">
                                <div class="flex items-center mb-2">
                                    <i class="fa fa-terminal text-zinc-300 mr-2"></i>
                                    <span class="text-sm text-zinc-300">Exemple de requête</span>
                                </div>
                                <code class="block bg-black bg-opacity-50 p-3 rounded text-green-400 text-sm overflow-x-auto">
                                    curl -X POST https://api.imators.com/v1/data \<br>
                                    -H "Authorization: Bearer YOUR_API_KEY" \<br>
                                    -H "Content-Type: application/json" \<br>
                                    -d '{"key": "value"}'
                                </code>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="feature-item pl-4">
                                    <div class="flex items-center mb-2">
                                        <i class="fa fa-file-code text-zinc-300 mr-3"></i>
                                        <h4 class="font-medium">Documentation Complète</h4>
                                    </div>
                                    <p class="text-zinc-400 text-sm">Guides détaillés et références pour toutes les endpoints.</p>
                                </div>
                                
                                <div class="feature-item pl-4">
                                    <div class="flex items-center mb-2">
                                        <i class="fa fa-key text-zinc-300 mr-3"></i>
                                        <h4 class="font-medium">Gestion des Clés API</h4>
                                    </div>
                                    <p class="text-zinc-400 text-sm">Création et révocation simplifées des accès.</p>
                                </div>
                                
                                <div class="feature-item pl-4">
                                    <div class="flex items-center mb-2">
                                        <i class="fa fa-gauge-high text-zinc-300 mr-3"></i>
                                        <h4 class="font-medium">Rate Limiting Flexible</h4>
                                    </div>
                                    <p class="text-zinc-400 text-sm">Plans adaptés à vos besoins de volume et performance.</p>
                                </div>
                                
                                <div class="feature-item pl-4">
                                    <div class="flex items-center mb-2">
                                        <i class="fa fa-code-branch text-zinc-300 mr-3"></i>
                                        <h4 class="font-medium">Versioning</h4>
                                    </div>
                                    <p class="text-zinc-400 text-sm">Support des versions multiples pour migrations sans risque.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Integrations Tab Content -->
                    <div id="integrations" class="tab-content hidden">
                        <h3 class="text-2xl font-light mb-6">Intégrations Natives</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-10">
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-database text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Bases de Données</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">Connecteurs pour MySQL, PostgreSQL, MongoDB, et plus.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-envelope text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Email Marketing</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">Mailchimp, SendGrid, Campaign Monitor et autres.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-comment text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Communication</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">Slack, Microsoft Teams, Discord, et plus.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-credit-card text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Paiements</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">Stripe, PayPal, Square, et autres solutions.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-briefcase text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">CRM</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">Salesforce, HubSpot, Zoho, et autres.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-file-invoice text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Comptabilité</h3>
                                </div>
                                <p class="text-zinc-400 text-sm mb-3">QuickBooks, Xero, FreshBooks, et plus.</p>
                                <div class="flex space-x-2 text-zinc-500">
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                    <i class="fa fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Pricing Tab Content -->
                    <div id="pricing" class="tab-content hidden">
                        <h3 class="text-2xl font-light mb-6">Plans Adaptés à Vos Besoins</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div class="p-6 border border-zinc-800 rounded-lg">
                                <h4 class="text-xl mb-4">Starter</h4>
                                <div class="text-3xl mb-2">29€<span class="text-sm text-zinc-400">/mois</span></div>
                                <p class="text-zinc-400 text-sm mb-6">Idéal pour les petites équipes et projets.</p>
                                <ul class="space-y-3 mb-8">
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">5 utilisateurs</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">10 GB de stockage</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">API basique</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Support email</span>
                                    </li>
                                </ul>
                                <button class="w-full py-2 bg-white text-black font-medium rounded hover:bg-gray-200 transition-colors">
                                    Commencer
                                </button>
                            </div>
                            
                            <div class="p-6 border border-zinc-700 rounded-lg bg-zinc-900">
                                <div class="flex items-center justify-between mb-4">
                                    <h4 class="text-xl">Pro</h4>
                                    <span class="px-3 py-1 bg-white text-black text-xs rounded-full">Populaire</span>
                                </div>
                                <div class="text-3xl mb-2">79€<span class="text-sm text-zinc-400">/mois</span></div>
                                <p class="text-zinc-400 text-sm mb-6">Pour les équipes en croissance.</p>
                                <ul class="space-y-3 mb-8">
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">20 utilisateurs</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">50 GB de stockage</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">API complète</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Support prioritaire</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Toutes les intégrations</span>
                                    </li>
                                </ul>
                                <button class="w-full py-2 bg-white text-black font-medium rounded hover:bg-gray-200 transition-colors">
                                    Commencer
                                </button>
                            </div>
                            
                            <div class="p-6 border border-zinc-800 rounded-lg">
                                <h4 class="text-xl mb-4">Enterprise</h4>
                                <div class="text-3xl mb-2">Sur mesure</div>
                                <p class="text-zinc-400 text-sm mb-6">Solutions personnalisées pour les grandes organisations.</p>
                                <ul class="space-y-3 mb-8">
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Utilisateurs illimités</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Stockage illimité</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">API dédiée</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Support 24/7</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">Hébergement dédié</span>
                                    </li>
                                    <li class="flex items-center">
                                        <i class="fa fa-check text-green-400 mr-2"></i>
                                        <span class="text-sm">SLA garantie</span>
                                    </li>
                                </ul>
                                <button class="w-full py-2 border border-white text-white font-medium rounded hover:bg-white hover:text-black transition-colors">
                                    Contacter l'équipe
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button class="demo-button px-8 py-4 rounded-md text-lg hover:text-white transition-colors">
                        <i class="fa fa-play-circle mr-2"></i>
                        Essayer la démo
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Bottom Footer -->
        <div class="w-full py-6 px-6 border-t border-zinc-800 flex flex-col md:flex-row justify-between items-center">
            <div class="text-sm text-zinc-500 mb-4 md:mb-0">
                © 2025 Imators. Tous droits réservés.
            </div>
            <div class="flex space-x-6">
                <a href="#" class="text-zinc-500 hover:text-white">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="#" class="text-zinc-500 hover:text-white">
                    <i class="fab fa-linkedin"></i>
                </a>
                <a href="#" class="text-zinc-500 hover:text-white">
                    <i class="fab fa-github"></i>
                </a>
                <a href="#" class="text-zinc-500 hover:text-white">
                    <i class="fa fa-envelope"></i>
                </a>
            </div>
        </div>
    </div>

    <script>
    function changeTab(tabId) {
        // Hide all tab contents
        document.querySelectorAll('.tab-content').forEach(tab => {
            tab.classList.add('hidden');
        });
        
        // Remove active class from all tabs
        document.querySelectorAll('.product-tab').forEach(tab => {
            tab.classList.remove('active');
        });
        
        // Show selected tab content
        document.getElementById(tabId).classList.remove('hidden');
        
        // Add active class to clicked tab
        event.currentTarget.classList.add('active');
    }
    </script>
</body>
</html>