<?php
session_start();
require_once 'db.php';

$isAdmin = false;
$message = '';

if (isset($_GET['logout'])) {
    unset($_SESSION['admin']);
    header('Location: admin.php');
    exit;
}

if (isset($_POST['login'])) {
    $username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
    $password = $_POST['password'];
    
    if ($username === 'admin' && $password === 'imators2024') {
        $_SESSION['admin'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $message = 'Identifiants incorrects';
    }
}

if (isset($_SESSION['admin']) && $_SESSION['admin'] === true) {
    $isAdmin = true;
}

if ($isAdmin && isset($_POST['stop_billboard'])) {
    $serial = filter_input(INPUT_POST, 'serial', FILTER_SANITIZE_STRING);
    $stopMessage = filter_input(INPUT_POST, 'stop_message', FILTER_SANITIZE_STRING);
    
    $stmt = $pdo->prepare("UPDATE `imators-systems-billboard` SET status = 'stopped', stop_message = ? WHERE serial = ?");
    $stmt->execute([$stopMessage, $serial]);
    
    $message = 'Panneau arrêté avec succès';
}

if ($isAdmin && isset($_POST['restart_billboard'])) {
    $serial = filter_input(INPUT_POST, 'serial', FILTER_SANITIZE_STRING);
    
    $stmt = $pdo->prepare("UPDATE `imators-systems-billboard` SET status = 'active', stop_message = NULL WHERE serial = ?");
    $stmt->execute([$serial]);
    
    $message = 'Panneau redémarré avec succès';
}

$billboards = [];
if ($isAdmin) {
    $stmt = $pdo->query("SELECT * FROM `imators-systems-billboard` ORDER BY last_seen DESC");
    $billboards = $stmt->fetchAll();
    
    foreach ($billboards as &$billboard) {
        $config = json_decode($billboard['config'], true);
        $billboard['latitude'] = $config['location']['latitude'] ?? 0;
        $billboard['longitude'] = $config['location']['longitude'] ?? 0;
        
        $lastSeen = new DateTime($billboard['last_seen']);
        $now = new DateTime();
        $diff = $now->diff($lastSeen);
        
        if ($diff->days > 0) {
            $billboard['connection_status'] = 'offline';
        } elseif ($diff->h > 0) {
            $billboard['connection_status'] = 'inactive';
        } else {
            $billboard['connection_status'] = 'online';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration - Imators Systems</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <style>
        .marker-icon {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            border: 2px solid white;
        }
        .marker-green { background-color: #10B981; }
        .marker-orange { background-color: #F59E0B; }
        .marker-red { background-color: #EF4444; }
    </style>
</head>
<body class="bg-gray-900 text-white min-h-screen flex flex-col">
    <header class="bg-gray-800 shadow-md">
        <div class="container mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center">
                <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="w-10 h-10 mr-3">
                <h1 class="text-xl font-semibold">Imators Systems - Administration</h1>
            </div>
            <?php if ($isAdmin): ?>
            <a href="?logout=1" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded text-sm">Déconnexion</a>
            <?php endif; ?>
        </div>
    </header>
    
    <main class="container mx-auto px-4 py-6 flex-grow">
        <?php if (!empty($message)): ?>
        <div class="bg-blue-500 text-white px-4 py-3 rounded mb-6">
            <?php echo htmlspecialchars($message); ?>
        </div>
        <?php endif; ?>
        
        <?php if (!$isAdmin): ?>
        <div class="max-w-md mx-auto bg-gray-800 rounded-lg shadow-md p-6">
            <h2 class="text-xl font-semibold mb-4 text-center">Connexion Administrateur</h2>
            <form method="POST" action="" class="space-y-4">
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-300 mb-1">Nom d'utilisateur</label>
                    <input type="text" name="username" id="username" required class="w-full bg-gray-700 border border-gray-600 rounded px-3 py-2 text-white">
                </div>
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-300 mb-1">Mot de passe</label>
                    <input type="password" name="password" id="password" required class="w-full bg-gray-700 border border-gray-600 rounded px-3 py-2 text-white">
                </div>
                <button type="submit" name="login" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded transition duration-150">
                    Se connecter
                </button>
            </form>
        </div>
        <?php else: ?>
        <div class="mb-8">
            <h2 class="text-2xl font-semibold mb-4">Carte des panneaux publicitaires</h2>
            <div id="map" class="h-96 rounded-lg mb-4"></div>
            
            <h2 class="text-2xl font-semibold mt-8 mb-4">Liste des panneaux</h2>
            <div class="overflow-x-auto">
                <table class="w-full bg-gray-800 rounded-lg shadow-md">
                    <thead>
                        <tr class="bg-gray-700">
                            <th class="px-4 py-3 text-left">Numéro de série</th>
                            <th class="px-4 py-3 text-left">Statut</th>
                            <th class="px-4 py-3 text-left">Connexion</th>
                            <th class="px-4 py-3 text-left">Dernière connexion</th>
                            <th class="px-4 py-3 text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($billboards as $billboard): ?>
                        <tr class="border-t border-gray-700">
                            <td class="px-4 py-3"><?php echo htmlspecialchars($billboard['serial']); ?></td>
                            <td class="px-4 py-3">
                                <?php if ($billboard['status'] === 'active'): ?>
                                <span class="inline-block bg-green-500 text-white text-xs px-2 py-1 rounded-full">Actif</span>
                                <?php else: ?>
                                <span class="inline-block bg-red-500 text-white text-xs px-2 py-1 rounded-full">Arrêté</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3">
                                <?php if ($billboard['connection_status'] === 'online'): ?>
                                <span class="inline-block bg-green-500 text-white text-xs px-2 py-1 rounded-full">En ligne</span>
                                <?php elseif ($billboard['connection_status'] === 'inactive'): ?>
                                <span class="inline-block bg-yellow-500 text-white text-xs px-2 py-1 rounded-full">Inactif</span>
                                <?php else: ?>
                                <span class="inline-block bg-red-500 text-white text-xs px-2 py-1 rounded-full">Hors ligne</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3"><?php echo htmlspecialchars($billboard['last_seen']); ?></td>
                            <td class="px-4 py-3">
                                <?php if ($billboard['status'] === 'active'): ?>
                                <form method="POST" action="" class="inline-block">
                                    <input type="hidden" name="serial" value="<?php echo htmlspecialchars($billboard['serial']); ?>">
                                    <button type="button" onclick="showStopModal('<?php echo htmlspecialchars($billboard['serial']); ?>')" class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-xs">
                                        Arrêter
                                    </button>
                                </form>
                                <?php else: ?>
                                <form method="POST" action="" class="inline-block">
                                    <input type="hidden" name="serial" value="<?php echo htmlspecialchars($billboard['serial']); ?>">
                                    <button type="submit" name="restart_billboard" class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded text-xs">
                                        Redémarrer
                                    </button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div id="stopModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-gray-800 p-6 rounded-lg shadow-lg max-w-md w-full">
                <h3 class="text-xl font-semibold mb-4">Arrêter le panneau</h3>
                <form method="POST" action="" id="stopForm">
                    <input type="hidden" name="serial" id="stopModalSerial">
                    <div class="mb-4">
                        <label for="stop_message" class="block text-sm font-medium text-gray-300 mb-1">Message d'arrêt</label>
                        <textarea name="stop_message" id="stop_message" rows="3" class="w-full bg-gray-700 border border-gray-600 rounded px-3 py-2 text-white" placeholder="Message à afficher sur le panneau">Ce panneau a été arrêté par l'administrateur.</textarea>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" onclick="hideStopModal()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">Annuler</button>
                        <button type="submit" name="stop_billboard" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded">Confirmer l'arrêt</button>
                    </div>
                </form>
            </div>
        </div>
        <?php endif; ?>
    </main>
    
    <footer class="bg-gray-800 py-4">
        <div class="container mx-auto px-4 text-center text-gray-400 text-sm">
            &copy; <?php echo date('Y'); ?> Imators Systems. Tous droits réservés.
        </div>
    </footer>
    
    <?php if ($isAdmin): ?>
    <script>
        const map = L.map('map').setView([48.8566, 2.3522], 5);
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
        }).addTo(map);
        
        const billboards = <?php echo json_encode($billboards); ?>;
        const markers = [];
        
        billboards.forEach(billboard => {
            if (billboard.latitude && billboard.longitude) {
                let markerColor;
                
                if (billboard.status === 'active') {
                    if (billboard.connection_status === 'online') {
                        markerColor = 'green';
                    } else if (billboard.connection_status === 'inactive') {
                        markerColor = 'orange';
                    } else {
                        markerColor = 'red';
                    }
                } else {
                    markerColor = 'red';
                }
                
                const markerHtml = `<div class="marker-icon marker-${markerColor}"></div>`;
                
                const customIcon = L.divIcon({
                    html: markerHtml,
                    className: '',
                    iconSize: [12, 12]
                });
                
                const marker = L.marker([billboard.latitude, billboard.longitude], {
                    icon: customIcon
                }).addTo(map);
                
                const statusText = billboard.status === 'active' ? 'Actif' : 'Arrêté';
                const connectionText = {
                    'online': 'En ligne',
                    'inactive': 'Inactif',
                    'offline': 'Hors ligne'
                }[billboard.connection_status];
                
                marker.bindPopup(`
                    <div style="color: black; min-width: 200px;">
                        <div style="font-weight: bold; margin-bottom: 5px;">${billboard.serial}</div>
                        <div style="margin-bottom: 3px;"><strong>Statut:</strong> ${statusText}</div>
                        <div style="margin-bottom: 3px;"><strong>Connexion:</strong> ${connectionText}</div>
                        <div style="margin-bottom: 5px;"><strong>Dernière connexion:</strong><br>${billboard.last_seen}</div>
                        <div style="display: flex; justify-content: center; gap: 5px; margin-top: 8px;">
                            ${billboard.status === 'active' ? 
                                `<button onclick="showStopModal('${billboard.serial}')" style="background-color: #EF4444; color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px;">Arrêter</button>` : 
                                `<form method="POST" action="">
                                    <input type="hidden" name="serial" value="${billboard.serial}">
                                    <button type="submit" name="restart_billboard" style="background-color: #10B981; color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px;">Redémarrer</button>
                                </form>`
                            }
                        </div>
                    </div>
                `);
                
                markers.push(marker);
            }
        });
        
        if (markers.length > 0) {
            const group = new L.featureGroup(markers);
            map.fitBounds(group.getBounds().pad(0.1));
        }
        
        function showStopModal(serial) {
            document.getElementById('stopModalSerial').value = serial;
            document.getElementById('stopModal').classList.remove('hidden');
        }
        
        function hideStopModal() {
            document.getElementById('stopModal').classList.add('hidden');
        }
        
        // Fermer la modal si on clique en dehors
        document.getElementById('stopModal').addEventListener('click', function(e) {
            if (e.target === this) {
                hideStopModal();
            }
        });
    </script>
    <?php endif; ?>
</body>
</html>