<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Produits OMP - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Urbanist', sans-serif; }
        @keyframes scroll-text {
            0% { transform: translateX(100%) }
            100% { transform: translateX(-100%) }
        }
        .scroll-animation {
            animation: scroll-text 25s linear infinite;
        }
        .scroll-animation:hover {
            animation-play-state: paused;
        }
        .bg-parallax {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }
        .status-beta { color: #6b7280; }
        .status-maintenance { color: #6b7280; }
        .status-online { color: #000000; }
    </style>
</head>
<body class="bg-white">
    
    <section class="relative h-screen bg-white overflow-hidden">        
        <div class="h-full flex flex-col justify-center px-12">
            <h1 class="text-8xl font-light text-black text-left tracking-tight">
                OMP
            </h1>
        </div>
        
        <div class="absolute bottom-0 left-0 right-0 h-12 flex items-center overflow-hidden border-t border-gray-100">
            <div class="scroll-animation whitespace-nowrap text-black text-sm font-light tracking-wide">
                Solutions • Technologies • Innovation • Performance • Expertise • Support • Solutions • Technologies • Innovation • Performance • Expertise • Support
            </div>
        </div>
    </section>

    <section class="py-20 bg-white">
        <div class="container mx-auto px-12">
            <div id="products-list" class="space-y-1">
                
            </div>
        </div>
    </section>

    <script>
        const products = [
            {
                name: "Analytics",
                description: "Données en temps réel"
            },
            {
                name: "Cloud",
                description: "Infrastructure scalable"
            },
            {
                name: "Security",
                description: "Protection avancée"
            },
            {
                name: "Workflow",
                description: "Automatisation métier"
            }
        ];

        function getRandomStatus() {
            const statuses = ['beta', 'maintenance', 'online'];
            return statuses[Math.floor(Math.random() * statuses.length)];
        }

        function getStatusDisplay(status) {
            const statusMap = {
                'beta': { text: 'beta', class: 'status-beta' },
                'maintenance': { text: 'maintenance', class: 'status-maintenance' },
                'online': { text: 'online', class: 'status-online' }
            };
            return statusMap[status];
        }

        function renderProducts() {
            const productsList = document.getElementById('products-list');
            productsList.innerHTML = '';
            
            products.forEach(product => {
                const status = getRandomStatus();
                const statusInfo = getStatusDisplay(status);
                
                const productDiv = document.createElement('div');
                productDiv.className = 'py-8 px-0 flex items-center justify-between border-b border-gray-100 hover:bg-gray-50 transition-colors duration-200';
                
                productDiv.innerHTML = `
                    <div class="flex-1">
                        <h3 class="text-2xl font-light text-black">${product.name}</h3>
                        <p class="text-sm text-gray-500 font-light mt-1">${product.description}</p>
                    </div>
                    <div class="flex items-center space-x-8">
                        <span class="text-xs font-light ${statusInfo.class}">${statusInfo.text}</span>
                        <div class="w-8 h-8 bg-black rounded-full"></div>
                    </div>
                `;
                
                productsList.appendChild(productDiv);
            });
        }

        renderProducts();
        setInterval(renderProducts, 1000);
    </script>

</body>
</html>