<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forum - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
        
        .forum-item {
            border-bottom: 1px solid #333;
            transition: background-color 0.3s;
        }
        
        .forum-item:hover {
            background-color: #111111;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="banner_color.png" alt="Forum Banner" class="w-full h-full object-cover">
    </div>
    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl font-light mb-6">Forum.</h1>
        <p class="text-xl text-gray-400 mb-12">Join our community to find answers and share experiences.</p>
        
        <div class="flex justify-between items-center mb-8">
            <div class="flex space-x-4">
                <a href="/forum" class="bg-gray-800 hover:bg-gray-700 text-white px-4 py-2 rounded-md transition">All Topics</a>
                <a href="/forum?category=hardware" class="hover:bg-gray-800 text-white px-4 py-2 rounded-md transition">Hardware</a>
                <a href="/forum?category=software" class="hover:bg-gray-800 text-white px-4 py-2 rounded-md transition">Software</a>
                <a href="/forum?category=general" class="hover:bg-gray-800 text-white px-4 py-2 rounded-md transition">General</a>
            </div>
            <a href="/new-post" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">New Post</a>
        </div>
        
        <div class="separator"></div>
        
        <?php
        require_once '/conn/db.php';
        
        $query = "SELECT p.id, p.title, p.content, p.created_at, p.views, p.user_id, 
                 (SELECT COUNT(*) FROM comments WHERE post_id = p.id) as comment_count
                 FROM posts p
                 ORDER BY p.created_at DESC";
        $result = $conn->query($query);
        
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $post_preview = substr(strip_tags($row["content"]), 0, 150) . "...";
                $post_date = date("M j, Y", strtotime($row["created_at"]));
                $post_id = $row["id"];
                ?>
                
                <div class="forum-item p-6 mb-4">
                    <div class="flex justify-between items-start">
                        <div class="w-full">
                            <a href="/view?id=<?php echo $post_id; ?>" class="text-2xl font-light hover:underline"><?php echo $row["title"]; ?></a>
                            <p class="text-gray-400 my-3"><?php echo $post_preview; ?></p>
                            <div class="flex items-center text-sm text-gray-500">
                                <?php
                                $user_id = $row["user_id"];
                                $user_query = "SELECT username FROM imators_users.users WHERE id = '$user_id'";
                                $user_result = $conn_users->query($user_query);
                                $username = "Unknown";
                                if ($user_result && $user_result->num_rows > 0) {
                                    $user = $user_result->fetch_assoc();
                                    $username = $user["username"];
                                }
                                ?>
                                <span class="mr-4">By <?php echo $username; ?></span>
                                <span class="mr-4"><?php echo $post_date; ?></span>
                                <span class="mr-4"><i class="far fa-eye mr-1"></i> <?php echo $row["views"]; ?> views</span>
                                <span><i class="far fa-comment mr-1"></i> <?php echo $row["comment_count"]; ?> comments</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php
            }
        } else {
            echo '<div class="text-center py-10">
                <p class="text-xl text-gray-400">No forum posts yet. Be the first to start a discussion!</p>
            </div>';
        }
        ?>
        
        <div class="separator"></div>
        
        <div class="py-10">
            <h2 class="text-2xl font-light mb-8">Forum Guidelines</h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2">Be Respectful</h3>
                    <p class="text-gray-400 mb-2">Treat others with respect and kindness, even when disagreeing.</p>
                </div>
                
                <div class="w-full md:w-1/2">
                    <h3 class="text-lg font-light mb-2">Stay On Topic</h3>
                    <p class="text-gray-400 mb-2">Keep discussions relevant to the thread topic.</p>
                </div>
            </div>
            
            <div class="flex flex-wrap mt-8">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2">No Spam</h3>
                    <p class="text-gray-400 mb-2">Avoid repetitive posting or promotional content.</p>
                </div>
                
                <div class="w-full md:w-1/2">
                    <h3 class="text-lg font-light mb-2">Help Others</h3>
                    <p class="text-gray-400 mb-2">Share your knowledge to help fellow community members.</p>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div></footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>