SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `country_id` int(11) NOT NULL,
  `city` varchar(100) NOT NULL,
  `language` varchar(5) NOT NULL,
  `bio` text DEFAULT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `experience` int(11) NOT NULL DEFAULT 0,
  `reputation` int(11) NOT NULL DEFAULT 0,
  `last_position_lat` decimal(10,8) DEFAULT NULL,
  `last_position_lng` decimal(11,8) DEFAULT NULL,
  `last_active` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(2) NOT NULL,
  `system_security_level` int(11) NOT NULL DEFAULT 1,
  `economy_status` varchar(20) NOT NULL DEFAULT 'stable',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `unions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `country_id` int(11) NOT NULL,
  `leader_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `leader_id` (`leader_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `union_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `union_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `role` varchar(50) NOT NULL DEFAULT 'member',
  `joined_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `union_user` (`union_id`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `communications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) NOT NULL,
  `receiver_id` int(11) NOT NULL,
  `content` text NOT NULL,
  `type` enum('text','voice') NOT NULL DEFAULT 'text',
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sender_id` (`sender_id`),
  KEY `receiver_id` (`receiver_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `alliances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user1_id` int(11) NOT NULL,
  `user2_id` int(11) NOT NULL,
  `status` enum('pending','active','rejected','blocked') NOT NULL DEFAULT 'pending',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_pair` (`user1_id`,`user2_id`),
  KEY `user2_id` (`user2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `system_combinations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `combination` varchar(3) NOT NULL,
  `added_by` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_combination` (`country_id`,`combination`),
  KEY `added_by` (`added_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `inventories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `acquired_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_item` (`user_id`,`item_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `rarity` enum('common','uncommon','rare','epic','legendary') NOT NULL DEFAULT 'common',
  `effect` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `economy_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) DEFAULT NULL,
  `receiver_id` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sender_id` (`sender_id`),
  KEY `receiver_id` (`receiver_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL DEFAULT 1.000000,
  `stability` enum('unstable','stable','very_stable') NOT NULL DEFAULT 'stable',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `missions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `difficulty` enum('easy','medium','hard','expert') NOT NULL DEFAULT 'easy',
  `reward_exp` int(11) NOT NULL,
  `reward_currency` decimal(15,2) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `country_id` int(11) DEFAULT NULL,
  `required_level` int(11) NOT NULL DEFAULT 1,
  `expiry_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `user_missions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `mission_id` int(11) NOT NULL,
  `status` enum('active','completed','failed') NOT NULL DEFAULT 'active',
  `progress` int(11) NOT NULL DEFAULT 0,
  `started_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_mission` (`user_id`,`mission_id`),
  KEY `mission_id` (`mission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `world_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `affected_countries` text NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `effect_type` varchar(50) NOT NULL,
  `effect_value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `skills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `skill_type` varchar(50) NOT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `experience` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_skill` (`user_id`,`skill_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `travels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `start_country` int(11) NOT NULL,
  `end_country` int(11) NOT NULL,
  `start_coordinates` varchar(50) NOT NULL,
  `end_coordinates` varchar(50) NOT NULL,
  `start_time` datetime NOT NULL,
  `arrival_time` datetime NOT NULL,
  `status` enum('in_progress','completed','cancelled') NOT NULL DEFAULT 'in_progress',
  `transport_type` enum('car','train','plane','boat') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `start_country` (`start_country`),
  KEY `end_country` (`end_country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`);

ALTER TABLE `unions`
  ADD CONSTRAINT `unions_ibfk_1` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`),
  ADD CONSTRAINT `unions_ibfk_2` FOREIGN KEY (`leader_id`) REFERENCES `users` (`id`);

ALTER TABLE `union_members`
  ADD CONSTRAINT `union_members_ibfk_1` FOREIGN KEY (`union_id`) REFERENCES `unions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `union_members_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

ALTER TABLE `communications`
  ADD CONSTRAINT `communications_ibfk_1` FOREIGN KEY (`sender_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `communications_ibfk_2` FOREIGN KEY (`receiver_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

ALTER TABLE `alliances`
  ADD CONSTRAINT `alliances_ibfk_1` FOREIGN KEY (`user1_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `alliances_ibfk_2` FOREIGN KEY (`user2_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

ALTER TABLE `system_combinations`
  ADD CONSTRAINT `system_combinations_ibfk_1` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`),
  ADD CONSTRAINT `system_combinations_ibfk_2` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`);

ALTER TABLE `inventories`
  ADD CONSTRAINT `inventories_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `inventories_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`);

ALTER TABLE `economy_transactions`
  ADD CONSTRAINT `economy_transactions_ibfk_1` FOREIGN KEY (`sender_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `economy_transactions_ibfk_2` FOREIGN KEY (`receiver_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `economy_transactions_ibfk_3` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`);

ALTER TABLE `currencies`
  ADD CONSTRAINT `currencies_ibfk_1` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`);

ALTER TABLE `missions`
  ADD CONSTRAINT `missions_ibfk_1` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  ADD CONSTRAINT `missions_ibfk_2` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

ALTER TABLE `user_missions`
  ADD CONSTRAINT `user_missions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_missions_ibfk_2` FOREIGN KEY (`mission_id`) REFERENCES `missions` (`id`) ON DELETE CASCADE;

ALTER TABLE `skills`
  ADD CONSTRAINT `skills_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

ALTER TABLE `travels`
  ADD CONSTRAINT `travels_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `travels_ibfk_2` FOREIGN KEY (`start_country`) REFERENCES `countries` (`id`),
  ADD CONSTRAINT `travels_ibfk_3` FOREIGN KEY (`end_country`) REFERENCES `countries` (`id`);

INSERT INTO `countries` (`id`, `name`, `code`, `system_security_level`, `economy_status`) VALUES
(1, 'France', 'FR', 5, 'stable'),
(2, 'États-Unis', 'US', 5, 'stable'),
(3, 'Allemagne', 'DE', 4, 'stable'),
(4, 'Royaume-Uni', 'GB', 4, 'stable'),
(5, 'Japon', 'JP', 5, 'stable'),
(6, 'Chine', 'CN', 5, 'growing'),
(7, 'Russie', 'RU', 3, 'unstable'),
(8, 'Brésil', 'BR', 2, 'growing'),
(9, 'Australie', 'AU', 4, 'stable'),
(10, 'Inde', 'IN', 3, 'growing');

INSERT INTO `currencies` (`id`, `country_id`, `name`, `exchange_rate`, `stability`) VALUES
(1, 1, 'Euro', 1.000000, 'stable'),
(2, 2, 'Dollar', 0.920000, 'stable'),
(3, 3, 'Euro', 1.000000, 'stable'),
(4, 4, 'Livre Sterling', 1.150000, 'stable'),
(5, 5, 'Yen', 0.006500, 'stable'),
(6, 6, 'Yuan', 0.130000, 'stable'),
(7, 7, 'Rouble', 0.010000, 'unstable'),
(8, 8, 'Real', 0.170000, 'unstable'),
(9, 9, 'Dollar Australien', 0.610000, 'stable'),
(10, 10, 'Roupie', 0.011000, 'stable');

INSERT INTO `items` (`id`, `name`, `type`, `description`, `rarity`, `effect`) VALUES
(1, 'Ordinateur portable', 'équipement', 'Un ordinateur portable standard pour les communications et le piratage de base.', 'common', 'Permet l\'accès aux systèmes informatiques de niveau 1'),
(2, 'Téléphone chiffré', 'équipement', 'Un téléphone avec des communications entièrement chiffrées.', 'uncommon', 'Communications sécurisées avec les alliés'),
(3, 'Kit de piratage avancé', 'équipement', 'Un ensemble d\'outils spécialisés pour le piratage de systèmes complexes.', 'rare', 'Augmente les chances de réussite lors des infiltrations de système de 25%'),
(4, 'Passe-partout numérique', 'consommable', 'Permet de déverrouiller certains systèmes sans code.', 'epic', 'Déverrouille automatiquement un système de niveau 3 ou inférieur'),
(5, 'Serveur quantique portable', 'équipement', 'Un appareil de calcul ultra-puissant pour les opérations les plus complexes.', 'legendary', 'Permet de tenter une intrusion dans le système central d\'un pays');

COMMIT;