<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMATORS BANK - Administration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        [x-cloak] { display: none !important; }
    </style>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-[#1a1a2e] font-[Inter] text-gray-100 antialiased" x-data="{ sidebarOpen: false }">
    <!-- Mobile Menu Overlay -->
    <div x-show="sidebarOpen" 
         x-cloak
         class="fixed inset-0 z-40 bg-black bg-opacity-50 lg:hidden"
         @click="sidebarOpen = false"></div>

    <!-- Mobile Menu Button -->
    <div class="fixed top-4 left-4 z-50 lg:hidden">
        <button @click="sidebarOpen = !sidebarOpen" 
                class="p-2 rounded-lg bg-[#16213e] text-gray-400 hover:text-white focus:outline-none">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
            </svg>
        </button>
    </div>

    <!-- Sidebar -->
    <aside x-cloak
           :class="{'translate-x-0': sidebarOpen, '-translate-x-full': !sidebarOpen}"
           class="fixed inset-y-0 left-0 z-50 w-64 bg-[#16213e] border-r border-gray-800 transform transition-transform duration-200 ease-in-out lg:translate-x-0 lg:static lg:inset-0">
        <div class="flex flex-col h-full">
            <div class="p-6">
                <div class="flex items-center space-x-3">
                    <svg class="h-8 w-8 text-blue-500" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                              d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <div class="text-lg font-bold">IMATORS BANK</div>
                </div>
            </div>

            <nav class="flex-1 px-4 pb-4">
                <div class="space-y-2">
                    <a href="#dashboard" 
                       class="flex items-center space-x-3 text-white p-3 rounded-lg bg-blue-600/20 hover:bg-blue-600/30 transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                        </svg>
                        <span>Tableau de bord</span>
                    </a>

                    <a href="#transactions" 
                       class="flex items-center space-x-3 text-gray-300 p-3 rounded-lg hover:bg-blue-600/10 transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                        </svg>
                        <span>Transactions</span>
                    </a>

                    <a href="#users" 
                       class="flex items-center space-x-3 text-gray-300 p-3 rounded-lg hover:bg-blue-600/10 transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                        <span>Utilisateurs</span>
                    </a>
                </div>
            </nav>

            <div class="p-4 border-t border-gray-800">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="text-sm font-medium"><?= htmlspecialchars($_SESSION['level']) ?></div>
                        <div class="text-xs text-gray-500"><?= htmlspecialchars($_SESSION['role']) ?></div>
                    </div>
                    <a href="?logout=1" class="text-sm text-red-400 hover:text-red-300 transition-colors">
                        Déconnexion
                    </a>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="lg:pl-64 min-h-screen">
        <!-- Top Bar -->
        <header class="bg-[#16213e] border-b border-gray-800 h-16 fixed top-0 right-0 left-0 lg:left-64 z-30">
            <div class="h-full px-4 lg:px-8 flex items-center justify-between">
                <h1 class="text-xl font-semibold ml-12 lg:ml-0">Tableau de bord</h1>
                <div class="flex items-center space-x-4">
                    <div class="hidden lg:flex items-center space-x-2 text-sm">
                        <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                        <span class="text-gray-400">Système actif</span>
                    </div>
                    <div class="text-sm text-gray-400">
                        <?= date('d/m/Y H:i') ?>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content Area -->
        <main class="pt-16">
            <div class="p-4 lg:p-8 max-w-7xl mx-auto">
                <!-- Stats Grid -->
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6">
                    <!-- Balance Totale -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 p-4 lg:p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-blue-500/10 text-blue-500">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                          d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h2 class="text-gray-400 text-sm">Balance Totale</h2>
                                <p class="text-lg lg:text-xl font-bold text-white"><?= format_number($stats['total_balance']) ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Comptes Bloqués -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 p-4 lg:p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-red-500/10 text-red-500">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                          d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h2 class="text-gray-400 text-sm">Comptes Bloqués</h2>
                                <p class="text-lg lg:text-xl font-bold text-white"><?= $stats['blocked_accounts'] ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Montant Suspect -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 p-4 lg:p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-yellow-500/10 text-yellow-500">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                          d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h2 class="text-gray-400 text-sm">Montant Suspect Total</h2>
                                <p class="text-lg lg:text-xl font-bold text-white"><?= format_number($stats['suspicious_amount']) ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Total Utilisateurs -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 p-4 lg:p-6">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-green-500/10 text-green-500">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                          d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h2 class="text-gray-400 text-sm">Total Utilisateurs</h2>
                                <p class="text-lg lg:text-xl font-bold text-white"><?= $stats['total_users'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tables -->
                <div class="grid grid-cols-1 xl:grid-cols-2 gap-6">
                    <!-- Comptes Clients -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 overflow-hidden">
                        <div class="p-4 lg:p-6 border-b border-gray-800">
                            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center space-y-4 lg:space-y-0">
                                <h2 class="text-xl font-bold">Comptes Clients</h2>
                                <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-2 w-full lg:w-auto">
                                    <input type="text" id="searchClient" placeholder="Rechercher..."
                                           class="px-3 py-1 bg-[#1a1a2e] border border-gray-800 rounded-lg text-sm w-full sm:w-auto">
                                    <select id="filterStatus" 
                                            class="px-3 py-1 bg-[#1a1a2e] border border-gray-800 rounded-lg text-sm w-full sm:w-auto">
                                        <option value="all">Tous les statuts</option>
                                        <option value="active">Actifs</option>
                                        <option value="blocked">Bloqués</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead>
                                    <tr class="text-left text-gray-400 bg-[#1a1a2e]">
                                        <th class="p-4 font-medium">Client</th>
                                        <th class="p-4 font-medium hidden lg:table-cell">Email</th>
                                        <th class="p-4 font-medium text-right">Balance</th>
                                        <th class="p-4 font-medium text-center">Statut</th>
                                        <th class="p-4 font-medium text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-300">
                                    <?php foreach($users as $user): ?>
                                    <tr class="border-b border-gray-800 hover:bg-[#1a1a2e]/50">
                                        <td class="p-4">
                                            <div class="font-medium"><?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?></div>
                                            <div class="text-xs text-gray-500 lg:hidden"><?= htmlspecialchars($user['email']) ?></div>
                                            <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($user['userid']) ?></div>
                                        </td>
                                        <td class="p-4 hidden lg:table-cell"><?= htmlspecialchars($user['email']) ?></td>
                                        <td class="p-4 text-right font-medium"><?= format_number($user['balance']) ?></td>
                                        <td class="p-4 text-center">
                                            <?php if($user['blocked-account'] == 'false'): ?>
                                                <span class="inline-flex items-center px-2 py-1 text-xs rounded-full text-red-400 bg-red-400/10">
                                                    <span class="w-1.5 h-1.5 rounded-full bg-red-400 mr-1.5"></span>
                                                    Bloqué
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2 py-1 text-xs rounded-full text-green-400 bg-green-400/10">
                                                    <span class="w-1.5 h-1.5 rounded-full bg-green-400 mr-1.5"></span>
                                                    Actif
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="p-4 text-center">
                                            <?php if($_SESSION['role'] === 'admin'): ?>
                                            <form method="POST" class="inline-block">
                                                <input type="hidden" name="userid" value="<?= htmlspecialchars($user['userid']) ?>">
                                                <?php if($user['blocked-account'] == 'false'): ?>
                                                    <button type="submit" name="action" value="unblock" 
                                                            class="px-3 py-1 text-xs rounded-lg text-green-400 bg-green-400/10 hover:bg-green-400/20 transition-colors">
                                                        Débloquer
                                                    </button>
                                                <?php else: ?>
                                                    <button type="submit" name="action" value="block"
                                                            onclick="return confirm('Êtes-vous sûr de vouloir bloquer ce compte ?')"
                                                            class="px-3 py-1 text-xs rounded-lg text-red-400 bg-red-400/10 hover:bg-red-400/20 transition-colors">
                                                        Bloquer
                                                    </button>
                                                <?php endif; ?>
                                            </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Transactions Suspectes -->
                    <div class="bg-[#16213e] rounded-xl border border-gray-800 overflow-hidden">
                        <div class="p-4 lg:p-6 border-b border-gray-800">
                            <div class="flex justify-between items-center">
                                <h2 class="text-xl font-bold">Transactions Suspectes</h2>
                                <span class="px-3 py-1 text-sm bg-yellow-400/10 text-yellow-400 rounded-lg">
                                    <?= count($transactions) ?> transactions
                                </span>
                            </div>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead>
                                    <tr class="text-left text-gray-400 bg-[#1a1a2e]">
                                        <th class="p-4 font-medium">ID</th>
                                        <th class="p-4 font-medium hidden lg:table-cell">De</th>
                                        <th class="p-4 font-medium hidden lg:table-cell">Vers</th>
                                        <th class="p-4 font-medium text-right">Montant</th>
                                        <th class="p-4 font-medium text-right">Date</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-300">
                                    <?php foreach($transactions as $trans): ?>
                                    <tr class="border-b border-gray-800 hover:bg-[#1a1a2e]/50">
                                        <td class="p-4">
                                            <div class="font-medium">Transaction #<?= htmlspecialchars($trans['id']) ?></div>
                                            <div class="text-xs text-gray-500 lg:hidden">
                                                De: <?= htmlspecialchars($trans['sender_firstname'] . ' ' . $trans['sender_lastname']) ?>
                                                <br>
                                                Vers: <?= htmlspecialchars($trans['recipient_firstname'] . ' ' . $trans['recipient_lastname']) ?>
                                            </div>
                                        </td>
                                        <td class="p-4 hidden lg:table-cell">
                                            <div class="font-medium"><?= htmlspecialchars($trans['sender_firstname'] . ' ' . $trans['sender_lastname']) ?></div>
                                            <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['sender_id']) ?></div>
                                        </td>
                                        <td class="p-4 hidden lg:table-cell">
                                            <div class="font-medium"><?= htmlspecialchars($trans['recipient_firstname'] . ' ' . $trans['recipient_lastname']) ?></div>
                                            <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['recipient_id']) ?></div>
                                        </td>
                                        <td class="p-4 text-right font-bold text-red-400">
                                            <?= format_number($trans['amount']) ?>
                                        </td>
                                        <td class="p-4 text-right text-gray-500">
                                            <?= time_ago($trans['created_at']) ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
    document.getElementById('searchClient').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });

    document.getElementById('filterStatus').addEventListener('change', function(e) {
        const status = e.target.value;
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (status === 'all') {
                row.style.display = '';
                return;
            }
            
            const isBlocked = row.querySelector('.text-red-400') !== null;
            const isActive = row.querySelector('.text-green-400') !== null;
            
            if (status === 'blocked' && isBlocked) row.style.display = '';
            else if (status === 'active' && isActive) row.style.display = '';
            else row.style.display = 'none';
        });
    });
    </script>
</body>
</html>