<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMATORS BANK - Authentification</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="bg-[#1a1a2e] font-[Inter] min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full">
        <div class="bg-gradient-to-br from-blue-600 to-purple-600 rounded-t-2xl p-8 text-center">
            <div class="flex justify-center mb-4">
                <svg class="h-12 w-12 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                          d="M12 15v2m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 1112 0v1H3v-1z"/>
                </svg>
            </div>
            <h1 class="text-3xl font-bold text-white mb-2">IMATORS BANK</h1>
            <p class="text-blue-100">Système de Surveillance</p>
        </div>
        
        <div class="bg-white rounded-b-2xl shadow-xl p-8">
            <?php if(isset($error)): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                <p class="font-medium">Erreur d'authentification</p>
                <p><?= $error ?></p>
            </div>
            <?php endif; ?>

            <form method="POST" class="space-y-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Code d'autorisation
                    </label>
                    <input type="password" name="auth_code" required
                           class="block w-full px-4 py-3 rounded-lg border border-gray-300 shadow-sm
                                  focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                           placeholder="Entrez votre code">
                </div>

                <button type="submit" name="auth_submit"
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg
                               text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 
                               focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500
                               transition-colors duration-200">
                    Accéder au système
                </button>
            </form>

            <div class="mt-6 text-center">
                <p class="text-xs text-gray-500">
                    Système sécurisé • Accès restreint • <?= date('Y') ?> © IMATORS BANK
                </p>
            </div>
        </div>
    </div>

    <div class="fixed bottom-4 left-4">
        <div class="flex items-center space-x-2 text-white/50 text-sm">
            <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
            <span>Système opérationnel</span>
        </div>
    </div>
</body>
</html>