<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            height: 70px;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 350;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .mega-menu-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(10px);
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
            z-index: 1000;
        }

        .mega-menu-panel {
            position: fixed;
            top: 90px;
            left: 0;
            width: 100%;
            background-color: rgba(10, 10, 10, 0.95);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-20px);
            transition: all 0.3s ease;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 0;
            max-height: 0;
            overflow: hidden;
        }

        .desktop-menu-item.active .mega-menu-overlay,
        .desktop-menu-item:hover .mega-menu-overlay {
            opacity: 1;
            visibility: visible;
        }

        .desktop-menu-item.active .mega-menu-panel,
        .desktop-menu-item:hover .mega-menu-panel {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
            padding: 30px 0;
            max-height: 600px;
        }

        .mega-menu-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            padding: 0 20px;
        }

        .menu-links {
            flex: 1;
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .menu-link {
            display: block;
            padding: 15px;
            border-radius: 12px;
            transition: all 0.2s ease;
            background: rgba(255, 255, 255, 0.05);
        }

        .menu-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }

        .menu-stories {
            width: 300px;
            margin-left: 30px;
            padding-left: 30px;
            border-left: 1px solid rgba(255, 255, 255, 0.1);
        }

        .stories-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .story-item {
            aspect-ratio: 1/1;
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: all 0.3s ease;
        }

        .story-item:hover {
            transform: scale(1.05);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 15px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.8rem;
            opacity: 0.8;
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .menu-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        .mobile-menu-items {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-menu-item:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .mobile-submenu-panel {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1002;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(100%);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu-panel.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-submenu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            gap: 15px;
            backdrop-filter: blur(10px);
        }

        .mobile-submenu-content {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-submenu-link:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .hamburger {
            width: 40px;
            height: 40px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 20px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 10px;
            transition: transform 0.3s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 14px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 24px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .close-button {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .featured-cards-section {
            padding: 20px;
            margin-bottom: 20px;
        }

        .stories-mobile-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .story-mobile-card {
            aspect-ratio: 1/1;
            border-radius: 16px;
            overflow: hidden;
            position: relative;
            transition: all 0.3s ease;
        }

        .story-mobile-content {
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 20px;
            background: linear-gradient(to bottom, transparent 30%, rgba(0, 0, 0, 0.8));
        }

        .mobile-card-title {
            font-size: 1.15rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .mobile-card-description {
            font-size: 0.85rem;
            opacity: 0.9;
            margin-bottom: 10px;
        }

        .mobile-card-button {
            align-self: flex-start;
            padding: 6px 14px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 30px;
            font-size: 0.8rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .mobile-card-button:active {
            transform: scale(0.95);
            background: rgba(255, 255, 255, 0.3);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }

        .header-content {
            height: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo-container img {
                height: 36px;
            }
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light" data-menu="products">
                    Products
                    <div class="mega-menu-overlay"></div>
                    <div class="mega-menu-panel">
                        <div class="mega-menu-container">
                            <div class="menu-links">
                                <a href="https://academ.my" class="menu-link">Academ</a>
                                <a href="/progm" class="menu-link">Progm</a>
                                <a href="https://ohmypanel.com" class="menu-link">OhMyPanel</a>
                                <a href="https://owtfitt.com" class="menu-link">Owtfitt</a>
                                <a href="https://imators.systems/traffic" class="menu-link">TrafficLight</a>
                            </div>
                            <div class="menu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Academ Success</h5>
                                            <p class="story-desc">See how Academ transforms education</p>
                                        </div>
                                    </div>
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">TrafficLight Impact</h5>
                                            <p class="story-desc">Smart traffic solutions</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item" data-menu="developer">
                    Developer Tools
                    <div class="mega-menu-overlay"></div>
                    <div class="mega-menu-panel">
                        <div class="mega-menu-container">
                            <div class="menu-links">
                                <a href="https://imators.systems" class="menu-link">Imators Systems</a>
                                <a href="https://developer.imators.com" class="menu-link">Imators Developer</a>
                                <a href="https://imators.systems/traffic" class="menu-link">TrafficLight</a>
                            </div>
                            <div class="menu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Developer Journey</h5>
                                            <p class="story-desc">Building with Imators tools</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item" data-menu="company">
                    Company
                    <div class="mega-menu-overlay"></div>
                    <div class="mega-menu-panel">
                        <div class="mega-menu-container">
                            <div class="menu-links">
                                <a href="/support" class="menu-link">Support</a>
                                <a href="/contact-us" class="menu-link">Contact us</a>
                                <a href="/about-us" class="menu-link">About Imators</a>
                            </div>
                            <div class="menu-stories">
                                <h4 class="stories-title">Stories</h4>
                                <div class="stories-grid">
                                    <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                                        <div class="story-content">
                                            <h5 class="story-title">Our Journey</h5>
                                            <p class="story-desc">The story of Imators</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <div class="mobile-overlay"></div>

    <div class="mobile-menu">
        <div class="mobile-menu-header">
            <span class="menu-title">Nice to see you.</span>
        </div>

        <div class="featured-cards-section">
            <div class="stories-mobile-grid">
                <div class="story-mobile-card" style="background-color: #8B5CF6;">
                    <div class="story-mobile-content">
                        <div>
                            <h3 class="mobile-card-title">Academ</h3>
                            <p class="mobile-card-description">Saying goodbye to homework overflow</p>
                        </div>
                        <a href="https://academ.my" class="mobile-card-button">Learn more</a>
                    </div>
                </div>
                <div class="story-mobile-card" style="background-color: #FBBF24;">
                    <div class="story-mobile-content">
                        <div>
                            <h3 class="mobile-card-title">OhMyPanel</h3>
                            <p class="mobile-card-description">Quick & easy shopping</p>
                        </div>
                        <a href="https://ohmypanel.com" class="mobile-card-button">Learn more</a>
                    </div>
                </div>
                <div class="story-mobile-card" style="background-color: #404040;">
                    <div class="story-mobile-content">
                        <div>
                            <h3 class="mobile-card-title">Imators Account</h3>
                            <p class="mobile-card-description">Global benefits</p>
                        </div>
                        <a href="https://idsma.imators.com" class="mobile-card-button">Explorer</a>
                    </div>
                </div>
                <div class="story-mobile-card" style="background-color: #3B82F6;">
                    <div class="story-mobile-content">
                        <div>
                            <h3 class="mobile-card-title">TrafficLight</h3>
                            <p class="mobile-card-description">Traffic management</p>
                        </div>
                        <a href="https://imators.systems/traffic" class="mobile-card-button">Discover</a>
                    </div>
                </div>
            </div>
        </div>
  
        <div class="mobile-menu-items">
            <div class="mobile-menu-item" data-submenu="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Products</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://academ.my" class="mobile-submenu-link">Academ</a>
            <a href="/progm" class="mobile-submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
            <a href="https://owtfitt.com" class="mobile-submenu-link">Owtfitt</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="dev-tools-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://imators.systems" class="mobile-submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">Imators Developer</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Company</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="/support" class="mobile-submenu-link">Support</a>
            <a href="/contact-us" class="mobile-submenu-link">Contact us</a>
            <a href="/about-us" class="mobile-submenu-link">About Imators</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileOverlay = document.querySelector('.mobile-overlay');
            const backButtons = document.querySelectorAll('.back-button');
            const menuItems = document.querySelectorAll('.mobile-menu-item');
            const header = document.querySelector('.header');
            const submenus = document.querySelectorAll('.mobile-submenu-panel');
            const desktopMenuItems = document.querySelectorAll('.desktop-menu-item');
            
            let isTransitioning = false;
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeDesktopMenu = null;

            // Desktop menu interactions
            desktopMenuItems.forEach(item => {
                item.addEventListener('mouseenter', function() {
                    this.classList.add('active');
                    activeDesktopMenu = this;
                    document.body.style.overflow = 'hidden';
                });
                
                item.addEventListener('mouseleave', function() {
                    this.classList.remove('active');
                    activeDesktopMenu = null;
                    document.body.style.overflow = '';
                });
            });

            function openMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = 'hidden';
                mobileOverlay.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }

            function closeMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = '';
                mobileOverlay.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
                submenus.forEach(submenu => {
                    submenu.classList.remove('active');
                });
            }

            hamburger.addEventListener('click', () => {
                mobileMenu.classList.contains('active') ? closeMenu() : openMenu();
            });

            backButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const submenuPanel = button.closest('.mobile-submenu-panel');
                    if (submenuPanel) {
                        submenuPanel.classList.remove('active');
                    }
                });
            });

            mobileOverlay.addEventListener('click', closeMenu);

            menuItems.forEach(item => {
                item.addEventListener('click', () => {
                    if (isTransitioning) return;
                    isTransitioning = true;

                    const submenuId = item.getAttribute('data-submenu') + '-submenu';
                    const submenu = document.getElementById(submenuId);

                    if (submenu) {
                        submenu.classList.add('active');
                    }

                    setTimeout(() => {
                        isTransitioning = false;
                    }, 300);
                });
            });

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }

                if (!mobileMenu.classList.contains('active') && !activeDesktopMenu && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }

                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', (e) => {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', (e) => {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeMenu();
                    touchStartY = 0;
                }
            }, { passive: true });

            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    if (mobileMenu.classList.contains('active')) {
                        closeMenu();
                    }
                    
                    desktopMenuItems.forEach(item => {
                        item.classList.remove('active');
                    });
                    
                    document.body.style.overflow = '';
                }
            });
            
            // Story items click handling
            const storyItems = document.querySelectorAll('.story-item');
            storyItems.forEach(item => {
                item.addEventListener('click', () => {
                    window.location.href = '#story-detail';
                });
            });
            
            // Mobile story cards click handling
            const mobileStoryCards = document.querySelectorAll('.story-mobile-card');
            mobileStoryCards.forEach(card => {
                card.addEventListener('click', function() {
                    const link = this.querySelector('a');
                    if (link) {
                        window.location.href = link.getAttribute('href');
                    }
                });
            });
        });
    </script>
</body>
</html>