<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background-color: #000;
            margin: 0;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            height: 70px;
            z-index: 100;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
        }

        .logo img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo img {
                height: 36px;
            }
        }
        
        /* Navigation Menu */
        .nav-menu {
            display: flex;
            gap: 30px;
        }

        @media (max-width: 1023px) {
            .nav-menu {
                display: none;
            }
        }

        .nav-item {
            position: relative;
            padding: 10px;
            cursor: pointer;
            font-weight: 400;
        }

        .nav-item:hover {
            color: rgba(255, 255, 255, 0.7);
        }

        /* Category Panel */
        .category-panel {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            z-index: 200;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }

        .category-panel.active {
            opacity: 1;
            visibility: visible;
        }

        .panel-container {
            position: relative;
            width: 100%;
            max-width: 400px;
            padding: 40px 0;
        }

        .close-panel {
            position: fixed;
            top: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            cursor: pointer;
            transition: background 0.2s ease;
            z-index: 201;
        }

        .close-panel:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .links-list {
            list-style: none;
            padding: 0;
            margin: 0;
            text-align: left;
            width: 200px;
            margin: 0 auto;
        }

        .links-list li {
            margin-bottom: 20px;
        }

        .category-link {
            display: block;
            font-size: 1.2rem;
            font-weight: 500;
            padding: 10px 0;
            transition: all 0.2s ease;
            color: #fff;
        }

        .category-link:hover {
            color: rgba(255, 255, 255, 0.7);
            transform: translateX(10px);
        }

        .account-btn {
            padding: 8px 16px;
            background: #fff;
            color: #000;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        @media (max-width: 1023px) {
            .account-btn {
                display: none;
            }
        }

        .account-btn:hover {
            opacity: 0.9;
        }

        /* Mobile Menu Toggle */
        .menu-toggle {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            position: relative;
        }

        @media (max-width: 1023px) {
            .menu-toggle {
                display: flex;
            }
        }

        .menu-toggle span {
            display: block;
            width: 18px;
            height: 2px;
            background: #fff;
            position: relative;
            transition: all 0.3s ease;
        }

        .menu-toggle span::before,
        .menu-toggle span::after {
            content: '';
            position: absolute;
            width: 18px;
            height: 2px;
            background: #fff;
            transition: all 0.3s ease;
        }

        .menu-toggle span::before {
            top: -6px;
        }

        .menu-toggle span::after {
            top: 6px;
        }

        .menu-toggle.active span {
            background: transparent;
        }

        .menu-toggle.active span::before {
            transform: rotate(45deg);
            top: 0;
        }

        .menu-toggle.active span::after {
            transform: rotate(-45deg);
            top: 0;
        }

        /* Mobile Menu */
        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            z-index: 99;
            transform: translateY(-100%);
            transition: all 0.3s ease;
            visibility: hidden;
            opacity: 0;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
        }

        .mobile-menu.active {
            transform: translateY(0);
            visibility: visible;
            opacity: 1;
        }

        .mobile-nav {
            width: 100%;
            max-width: 300px;
        }

        .mobile-nav-item {
            margin-bottom: 20px;
            padding: 15px;
            font-size: 1.1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .mobile-nav-item:active {
            color: rgba(255, 255, 255, 0.7);
        }
    </style>
</head>
<body class="h-full">
    <!-- Header -->
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="header-container">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>

            <nav class="nav-menu">
                <div class="nav-item" data-category="products">Products</div>
                <div class="nav-item" data-category="developer">Developer Tools</div>
                <div class="nav-item" data-category="company">Company</div>
            </nav>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <div class="menu-toggle">
                    <span></span>
                </div>
            </div>
        </div>
    </header>

    <!-- Products Category Panel -->
    <div class="category-panel" id="products-panel">
        <button class="close-panel">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M18 6L6 18M6 6l12 12" />
            </svg>
        </button>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="https://academ.my" class="category-link">Academ</a></li>
                <li><a href="/progm" class="category-link">Progm</a></li>
                <li><a href="https://ohmypanel.com" class="category-link">OhMyPanel</a></li>
                <li><a href="https://owtfitt.com" class="category-link">Owtfitt</a></li>
                <li><a href="https://imators.systems/traffic" class="category-link">TrafficLight</a></li>
            </ul>
        </div>
    </div>

    <!-- Developer Tools Category Panel -->
    <div class="category-panel" id="developer-panel">
        <button class="close-panel">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M18 6L6 18M6 6l12 12" />
            </svg>
        </button>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="https://imators.systems" class="category-link">Imators Systems</a></li>
                <li><a href="https://developer.imators.com" class="category-link">Imators Developer</a></li>
                <li><a href="https://imators.systems/traffic" class="category-link">TrafficLight</a></li>
            </ul>
        </div>
    </div>

    <!-- Company Category Panel -->
    <div class="category-panel" id="company-panel">
        <button class="close-panel">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M18 6L6 18M6 6l12 12" />
            </svg>
        </button>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="/support" class="category-link">Support</a></li>
                <li><a href="/contact-us" class="category-link">Contact us</a></li>
                <li><a href="/about-us" class="category-link">About Imators</a></li>
            </ul>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-menu">
        <div class="mobile-nav">
            <div class="mobile-nav-item" data-category="products">Products</div>
            <div class="mobile-nav-item" data-category="developer">Developer Tools</div>
            <div class="mobile-nav-item" data-category="company">Company</div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Elements
            const header = document.querySelector('.header');
            const menuToggle = document.querySelector('.menu-toggle');
            const mobileMenu = document.querySelector('.mobile-menu');
            const navItems = document.querySelectorAll('.nav-item');
            const mobileNavItems = document.querySelectorAll('.mobile-nav-item');
            const categoryPanels = document.querySelectorAll('.category-panel');
            const closePanelButtons = document.querySelectorAll('.close-panel');
            
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeCategoryPanel = null;
            
            // Open category panel on click (both desktop and mobile)
            function openCategoryPanel(category) {
                const panel = document.getElementById(category + '-panel');
                
                if (panel) {
                    // Close any open panel first
                    if (activeCategoryPanel && activeCategoryPanel !== panel) {
                        activeCategoryPanel.classList.remove('active');
                    }
                    
                    panel.classList.add('active');
                    activeCategoryPanel = panel;
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                    
                    // Close mobile menu if open
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                    }
                }
            }
            
            // Close category panel
            function closeCategoryPanel() {
                if (activeCategoryPanel) {
                    activeCategoryPanel.classList.remove('active');
                    activeCategoryPanel = null;
                    document.body.style.overflow = ''; // Enable scrolling
                }
            }
            
            // Desktop navigation
            navItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            // Mobile navigation
            mobileNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            // Close panel buttons
            closePanelButtons.forEach(button => {
                button.addEventListener('click', closeCategoryPanel);
            });
            
            // Mobile menu toggle
            menuToggle.addEventListener('click', function() {
                this.classList.toggle('active');
                mobileMenu.classList.toggle('active');
                
                if (mobileMenu.classList.contains('active')) {
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                } else {
                    document.body.style.overflow = ''; // Enable scrolling
                }
            });
            
            // Close with ESC key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    // Close category panel if open
                    if (activeCategoryPanel) {
                        closeCategoryPanel();
                    }
                    
                    // Close mobile menu if open
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                        document.body.style.overflow = '';
                    }
                }
            });
            
            // Handle scroll for transparent header
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                // Hide/show header on scroll
                if (!mobileMenu.classList.contains('active') && !activeCategoryPanel && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });
            
            // Close panel when clicking outside
            categoryPanels.forEach(panel => {
                panel.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeCategoryPanel();
                    }
                });
            });
        });
    </script>
</body>
</html>