<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Post - Forum - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
    </style>
</head>
<body>
    <?php
    session_start();
    include 'src/header.php';
    require_once 'conn/db.php';
    
    $auth_url = "https://idsma.imators.com/login.php?forumconnectionaccount=" . urlencode("https://" . $_SERVER['HTTP_HOST'] . "/forum");
    
    if(!isset($_SESSION['user_id'])) {
        header("Location: " . $auth_url);
        exit;
    }
    
    $user_id = $_SESSION['user_id'];
    $error = '';
    $success = '';
    
    if($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = trim($_POST['title']);
        $content = trim($_POST['content']);
        $category_id = (int) $_POST['category'];
        
        if(empty($title)) {
            $error = "Please enter a title";
        } elseif(empty($content)) {
            $error = "Please enter content for your post";
        } else {
            $post_id = substr(md5(uniqid() . rand()), 0, 12);
            
            $query = "INSERT INTO posts (id, user_id, category_id, title, content) 
                     VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($query);
            
            if($stmt->execute([$post_id, $user_id, $category_id, $title, $content])) {
                $success = "Post created successfully!";
                header("Location: /view?id=" . $post_id);
                exit;
            } else {
                $error = "Failed to create post. Please try again.";
            }
        }
    }
    
    $categories_query = "SELECT id, name FROM categories ORDER BY name";
    $categories_result = $conn->query($categories_query);
    ?>

    <div class="container px-4 mx-auto py-12">
        <div class="mb-6">
            <a href="/forum" class="text-link mb-8 inline-block"><i class="fas fa-arrow-left mr-2"></i> Back to Forum</a>
        </div>
        
        <h1 class="text-4xl font-light mb-6">Create New Post</h1>
        
        <?php if($error): ?>
            <div class="bg-red-500 bg-opacity-20 border border-red-500 text-red-300 px-4 py-3 rounded mb-6">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if($success): ?>
            <div class="bg-green-500 bg-opacity-20 border border-green-500 text-green-300 px-4 py-3 rounded mb-6">
                <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" class="space-y-6">
            <div>
                <label for="title" class="block text-sm font-medium mb-2">Title</label>
                <input 
                    type="text" 
                    id="title" 
                    name="title" 
                    required 
                    class="w-full px-4 py-2 rounded-lg bg-gray-900 border border-gray-800 focus:border-white focus:outline-none"
                    value="<?php echo isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''; ?>"
                >
            </div>
            
            <div>
                <label for="category" class="block text-sm font-medium mb-2">Category</label>
                <select 
                    id="category" 
                    name="category" 
                    required 
                    class="w-full px-4 py-2 rounded-lg bg-gray-900 border border-gray-800 focus:border-white focus:outline-none"
                >
                    <?php while($category = $categories_result->fetch_assoc()): ?>
                        <option 
                            value="<?php echo $category['id']; ?>"
                            <?php echo (isset($_POST['category']) && $_POST['category'] == $category['id']) ? 'selected' : ''; ?>
                        >
                            <?php echo htmlspecialchars($category['name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div>
                <label for="content" class="block text-sm font-medium mb-2">Content</label>
                <textarea 
                    id="content" 
                    name="content" 
                    rows="10" 
                    required 
                    class="w-full px-4 py-2 rounded-lg bg-gray-900 border border-gray-800 focus:border-white focus:outline-none"
                ><?php echo isset($_POST['content']) ? htmlspecialchars($_POST['content']) : ''; ?></textarea>
            </div>
            
            <div class="flex justify-end">
                <button 
                    type="submit" 
                    class="bg-white text-black px-6 py-2 rounded-md hover:bg-gray-200 transition"
                >
                    Create Post
                </button>
            </div>
        </form>
        
        <div class="separator"></div>
        
        <div class="py-6">
            <h2 class="text-2xl font-light mb-4">Posting Guidelines</h2>
            <ul class="space-y-2 text-gray-400">
                <li><i class="fas fa-check text-green-500 mr-2"></i> Be respectful and constructive in your posts</li>
                <li><i class="fas fa-check text-green-500 mr-2"></i> Provide as much relevant information as possible</li>
                <li><i class="fas fa-check text-green-500 mr-2"></i> Format your post for readability</li>
                <li><i class="fas fa-check text-green-500 mr-2"></i> Stay on topic and post in the appropriate category</li>
                <li><i class="fas fa-times text-red-500 mr-2"></i> No spam, advertising, or self-promotion</li>
                <li><i class="fas fa-times text-red-500 mr-2"></i> No offensive or inappropriate content</li>
            </ul>
        </div>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div></footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>