<?php
// Paramètres de connexion à la base de données
$db_host = 'localhost';
$db_user = 'root';
$db_password = '';
$db_name = 'cergies';

// Connexion à la base de données avec PDO
try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_password);
    // Configuration pour afficher les erreurs PDO
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Configuration pour retourner les résultats sous forme de tableau associatif
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données: " . $e->getMessage());
}

// Fonction pour exécuter une requête et retourner les résultats
function db_query($sql, $params = []) {
    global $pdo;
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    } catch (PDOException $e) {
        die("Erreur d'exécution de la requête: " . $e->getMessage());
    }
}

// Fonction pour récupérer toutes les lignes
function db_get_all($sql, $params = []) {
    $stmt = db_query($sql, $params);
    return $stmt->fetchAll();
}

// Fonction pour récupérer une seule ligne
function db_get_one($sql, $params = []) {
    $stmt = db_query($sql, $params);
    return $stmt->fetch();
}

// Fonction pour récupérer une seule valeur
function db_get_value($sql, $params = []) {
    $stmt = db_query($sql, $params);
    return $stmt->fetchColumn();
}

// Fonction pour insérer des données
function db_insert($table, $data) {
    global $pdo;
    $columns = implode(', ', array_keys($data));
    $placeholders = implode(', ', array_fill(0, count($data), '?'));
    
    $sql = "INSERT INTO $table ($columns) VALUES ($placeholders)";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_values($data));
        return $pdo->lastInsertId();
    } catch (PDOException $e) {
        die("Erreur d'insertion: " . $e->getMessage());
    }
}

// Fonction pour mettre à jour des données
function db_update($table, $data, $where, $where_params = []) {
    global $pdo;
    $set = [];
    foreach (array_keys($data) as $column) {
        $set[] = "$column = ?";
    }
    $set_clause = implode(', ', $set);
    
    $sql = "UPDATE $table SET $set_clause WHERE $where";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_merge(array_values($data), $where_params));
        return $stmt->rowCount();
    } catch (PDOException $e) {
        die("Erreur de mise à jour: " . $e->getMessage());
    }
}

// Fonction pour supprimer des données
function db_delete($table, $where, $params = []) {
    global $pdo;
    $sql = "DELETE FROM $table WHERE $where";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->rowCount();
    } catch (PDOException $e) {
        die("Erreur de suppression: " . $e->getMessage());
    }
}
?>