<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
            .bg-custom {
                background-color: var(--bg-dark);
            }
            .button-custom {
                background-color: var(--text-dark);
                color: var(--bg-dark);
            }
            .dot-custom {
                background-color: var(--text-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
            .bg-custom {
                background-color: var(--bg-light);
            }
            .button-custom {
                background-color: var(--text-light);
                color: var(--bg-light);
            }
            .dot-custom {
                background-color: var(--text-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        @keyframes fadeIn {
            from {opacity: 0;transform: translateY(10px);}
            to {opacity: 1;transform: translateY(0);}
        }

        .fade-in {
            opacity: 0;
            animation: fadeIn 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }

        .delay-1 {animation-delay: 0.2s;}
        .delay-2 {animation-delay: 0.4s;}
        .delay-3 {animation-delay: 0.6s;}
        .delay-4 {animation-delay: 0.8s;}

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        @media (min-width: 640px) {
            .main-container {
                padding: 0 2rem;
            }
        }

        section {
            border-bottom: 1px solid currentColor;
            padding: 4rem 0;
        }

        @media (min-width: 768px) {
            section {
                padding: 6rem 0;
            }
        }

        .hover-scale {
            transition: transform 0.3s ease;
        }

        .hover-scale:hover {
            transform: scale(1.02);
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 2.5rem;
            }
            h2 {
                font-size: 2rem;
            }
            .header-content {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 fade-in sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    -> MENU <-
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4 fade-in delay-1">
                    Just another day
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6 fade-in delay-2">
                    To fascinate, discover and put a smile on your face
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12 fade-in delay-3">
                    For me, every day makes us learn something or makes us enjoy everyday life. My goal has always been to share, observe and appreciate the moment day by day
                </p>
                <a href="https://forchange.me" class="button-custom px-8 py-3 rounded-full text-sm font-light tracking-wide fade-in delay-4 hover:opacity-90 transition-opacity inline-block">
                    Contact me on Discord
                </a>
            </div>
        </section>

        <section id="about" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">ABOUT ME</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16">
                <div class="space-y-6">
                    <p class="text-lg font-light leading-relaxed">
                        I'm a web developer and entrepreneur based in Europe. My journey in tech started with a simple curiosity about how websites work, and it has evolved into a passion for creating digital experiences that matter.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        As the CEO of Imators, I lead a team dedicated to developing technology that enhances daily life without compromising human connection. We believe in innovation that serves people, not the other way around.
                    </p>
                </div>
                <div class="space-y-6">
                    <p class="text-lg font-light leading-relaxed">
                        With three years of development experience, I've honed my skills while maintaining a positive and sharing-oriented mindset. I'm known for my contagious joy and ability to make others laugh, believing that happiness and professional excellence go hand in hand.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        I approach both work and life with enthusiasm and a genuine desire to share experiences. My minimalist philosophy focuses on what really matters : smiling every day and always expressing my good humour and enthusiasm.
                    </p>
                    
                                   <p class="italic text-lg font-light leading-relaxed">
                       Oh! And this is just for you: the code languages that make my daily life a happiness on a computer : 
                    </p>
                </div>
            </div>
        
        <div class="skills-badges">
    <div class="badge">HTML</div>
    <div class="badge">PHP</div>
    <div class="badge">JavaScript</div>
    <div class="badge">CSS</div>
    <div class="badge">Java</div>
    <div class="badge">Swift</div>
    <div class="badge">C#</div>
    <div class="badge">Python</div>
    <div class="badge">LUA</div>        
</section>

<style>
    .skills-badges {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin: 20px 0;
    }
    
    .badge {
        background-color: #333;
        color: white;
        font-weight: bold;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
    }
    
    .badge:nth-child(1) {
        background-color: #e34c26;
    }
    
    .badge:nth-child(2) {
        background-color: #777bb3;
    }
    
    .badge:nth-child(3) {
        background-color: #f7df1e;
        color: black;
    }
    
    .badge:nth-child(4) {
        background-color: #264de4;
    }
    
    .badge:nth-child(5) {
        background-color: #fcb103;
    }
    
    .badge:nth-child(6) {
        background-color: #fc5a03;
    }
    
    .badge:nth-child(7) {
        background-color: #03bafc;
    }
    
    .badge:nth-child(8) {
        background-color: #fce803;
        color : black;
    }

    .badge:nth-child(9) {
        background-color:rgb(3, 28, 252);
        color : white;
    }
</style>

        <section id="music" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">MY FAVORITE ALBUMS</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
                <div class="hover-scale">
                    <div class="aspect-square overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://media.pitchfork.com/photos/6662e6122ce1ce711b18e944/master/w_1280%2Cc_limit/Sabrina-Carpenter-Short-n-Sweet.jpg" 
                             class="w-full h-full object-cover" alt="Short n Sweet album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Short n' Sweet</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://music.apple.com/uk/album/short-n-sweet/1750307020" class="text-sm hover:underline">Listen on Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale">
                    <div class="aspect-square overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b273d0bbd3ea2ec554f17a6603cc" 
                             class="w-full h-full object-cover" alt="Silk Sonic album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">An Evening with Silk Sonic</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://music.apple.com/album/short-n-sweet/1728313338" class="text-sm hover:underline">Listen on Apple Music</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="media" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">MY FAVORITE SERIES & MOVIES</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
            <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://m.media-amazon.com/images/S/pv-target-images/aab0322a11698c77fe0dc30131b2ffdba59a73d3544a0b25cf5cb7d20e029f84.jpg
" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">The Gorge</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/the-gorge/umc.cmc.26o403koqo2klixc0jtqy6tmc" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
            
            
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://seriesonweb.com/wp-content/uploads/2024/04/Sugar.jpg" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Sugar</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/show/sugar/umc.cmc.4r6q7tdquewehwvb3rzl0k3dtm" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
                
   
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://preview.redd.it/fly-me-to-the-moon-2024-textless-v0-y4htoeerwezc1.jpeg?auto=webp&s=841eca3463d5408f09090df6a2a7e645eee100f9" 
                             class="w-full h-full object-cover" alt="To The Moon">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">To The Moon</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/to-the-moon/umc.cmc.7bwrikjdeik56bk49vlr7c1h6" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://resize.elle.fr/original/var/plain_site/storage/images/loisirs/series/ces-films-et-series-a-regarder-si-vous-avez-aime-lupin-dans-l-ombre-d-arsene/94289862-3-fre-FR/7-films-et-series-a-regarder-si-vous-avez-aime-Lupin-dans-l-ombre-d-Arsene.jpg" 
                             class="w-full h-full object-cover" alt="Lupin">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Lupin</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="#" class="text-sm hover:underline">Watch on Netflix</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
        <p>AppleTV is a brand belonging to Apple Inc. All rights reserved. Netflix is a membership of Netflix Inc. All rights reserved</p>
        <p>The images used are for illustrative purposes and not to pretend to be the producing companies or actors represented on them. These images are even seen to promote the stated content.</p>
    </footer>
</body>
</html>