<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <title>ISE Engine</title>
   <script src="https://cdn.tailwindcss.com"></script>
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200..900;1,200..900&family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <style>
        .urbanist {
            font-family: "Urbanist", serif;
        }

        .crypted-word {
            font-family: "Source Code Pro", monospace;
            font-optical-sizing: auto;
            font-weight: <weight>;
            font-style: normal;
        }

        .error-notification {
            animation: slideIn 0.3s ease-out;
        }

        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
    </style>
</head>
<body class="urbanist bg-white">
   <header class="w-full px-8 py-6 flex justify-between items-center">
       <div class="text-xl">I_SE</div>
       <button id="menu-toggle" class="md:hidden">
           <i class="fas fa-bars text-xl"></i>
       </button>
       <nav class="md:flex space-x-8">
           <a href="https://idsma.imators.com/ise-login.php" class="hover:opacity-60">Try the engine</a>
       </nav>
   </header>

   <div id="mobile-nav" class="hidden px-8 py-4 md:hidden">
       <div class="flex flex-col space-y-4">
           <a href="https://idsma.imators.com/ise-login.php" class="hover:opacity-60">Try the Engine</a>
       </div>
   </div>

   @if(session('error'))
       <div id="error-notification" class="error-notification fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 max-w-sm">
           <div class="flex items-center justify-between">
               <span class="text-sm">{{ session('error') }}</span>
               <button onclick="closeError()" class="ml-4 text-white hover:text-gray-200">
                   <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                       <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                   </svg>
               </button>
           </div>
       </div>
   @endif

   <main class="crypted-word flex items-center justify-center min-h-screen">
       <div class="text-center">
           <div class="encrypted-text text-3xl opacity-0">##11&&&&</div>
       </div>
   </main>

   <script>
       document.getElementById('menu-toggle').addEventListener('click', () => {
           document.getElementById('mobile-nav').classList.toggle('hidden');
       });

       const phrase = 'Search, find and be a human, not a ai.<br>With ISE, write error-free texts, with correct information, to present a document that is 99% reliable.';
       const element = document.querySelector('.encrypted-text');

       function decrypt(element, text) {
           const chars = '##1à&_&&@#$%';
           let steps = 0;
           const maxSteps = 20;
           
           const interval = setInterval(() => {
               let result = '';
               for (let i = 0; i < text.length; i++) {
                   if (i < (text.length * steps / maxSteps)) {
                       result += text[i];
                   } else {
                       result += chars[Math.floor(Math.random() * chars.length)];
                   }
               }
               element.textContent = result;
               steps++;
               
               if (steps > maxSteps) {
                   clearInterval(interval);
                   element.textContent = text;
               }
           }, 100);
       }

       function closeError() {
           const errorDiv = document.getElementById('error-notification');
           if (errorDiv) {
               errorDiv.style.animation = 'slideOut 0.3s ease-in forwards';
               setTimeout(() => errorDiv.remove(), 300);
           }
       }

       setTimeout(() => {
           element.style.opacity = '1';
           element.style.transition = 'opacity 0.5s';
           setTimeout(() => {
               decrypt(element, phrase);
           }, 500);
       }, 500);

       setTimeout(() => {
           const errorDiv = document.getElementById('error-notification');
           if (errorDiv) {
               closeError();
           }
       }, 5000);
   </script>

   <style>
       @keyframes slideOut {
           from { transform: translateX(0); opacity: 1; }
           to { transform: translateX(100%); opacity: 0; }
       }
   </style>
</body>
</html>