<?php
session_start();
require_once 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $code = $_POST['code'] ?? '';
    
    $database = new Database();
    $conn = $database->getConnection();
    
    $stmt = $conn->prepare("SELECT * FROM users WHERE code = :code");
    $stmt->bindParam(':code', $code);
    $stmt->execute();
    
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && verify_code($code, $user['code_hash'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        header("Location: dashboard.php");
        exit();
    } else {
        $error = "Code invalide";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Peerkinton - Connexion</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class="bg-black text-white flex items-center justify-center min-h-screen">
    <div class="w-full max-w-md">
        <form method="post" class="bg-black p-8 rounded-lg">
            <h2 class="text-2xl mb-6 text-center">Peerkinton</h2>
            <?php if(isset($error)): ?>
                <p class="text-red-500 mb-4"><?php echo $error; ?></p>
            <?php endif; ?>
            <input type="text" name="code" required 
                class="w-full p-3 bg-gray-900 text-white rounded mb-4" 
                placeholder="Code de connexion (12 chiffres)">
            <button type="submit" 
                class="w-full bg-white text-black p-3 rounded hover:bg-gray-200">
                Se connecter
            </button>
        </form>
    </div>
</body>
</html>