<?php
require_once 'auth_check.php';
require_once 'db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Systems</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
    .loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

.loading-spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

        body {
            font-family: 'Poppins', sans-serif;
        }
        .success-notification {
            animation: fadeOut 3s forwards;
            animation-delay: 2s;
        }
        @keyframes fadeOut {
            from {opacity: 1;}
            to {opacity: 0; display: none;}
        }
        .search-highlight {
            background-color: rgba(255, 255, 0, 0.2);
            padding: 0.1em;
            border-radius: 2px;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white min-h-screen transition-colors duration-200 p-4 md:p-6 lg:p-8">
<div class="max-w-[1400px] mx-auto">
    <?php if(isset($_GET['success'])): ?>
    <div class="success-notification fixed top-4 right-4 bg-green-500 dark:bg-green-600 text-white px-6 py-3 rounded-lg shadow-lg z-50">
        <div class="flex items-center space-x-2">
            <i class="fas fa-check-circle"></i>
            <span>Operation completed successfully!</span>
        </div>
    </div>
    <?php endif; ?>

    <?php if(isset($_GET['error'])): ?>
    <div class="error-notification fixed top-4 right-4 bg-red-500 dark:bg-red-600 text-white px-6 py-3 rounded-lg shadow-lg z-50">
        <div class="flex items-center space-x-2">
            <i class="fas fa-exclamation-circle"></i>
            <span>An error occurred during the operation.</span>
        </div>
    </div>
    <?php endif; ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex flex-col lg:flex-row items-center justify-between mb-8 space-y-4 lg:space-y-0">
        <div class="flex items-center justify-between w-full lg:w-auto">
            <div class="flex items-center space-x-4">
                <img src="https://cdn.imators.com/logo.png" alt="Logo" class="h-10 lg:h-12 w-auto">
                <div>
                    <h1 class="text-2xl lg:text-3xl font-bold">Imators Systems</h1>
                    <p class="text-sm text-gray-600 dark:text-gray-400">High-security administrative dashboard dedicated to Imators</p>
                </div>
            </div>
            <?php if(isset($_SESSION['user_id'])): ?>
                <div class="flex lg:hidden relative" id="profile-menu">
                    <button class="flex items-center space-x-3 p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">
                        <div class="w-10 h-10 rounded-full overflow-hidden bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                            <?php if (!empty($_SESSION['profile_picture'])): ?>
                                <img src="<?= htmlspecialchars($_SESSION['profile_picture']) ?>" 
                                     alt="Profile" 
                                     class="w-full h-full object-cover"
                                     onerror="this.onerror=null; this.src='https://cdn.imators.com/default-avatar.png';">
                            <?php else: ?>
                                <i class="fas fa-user text-gray-400 text-xl"></i>
                            <?php endif; ?>
                        </div>
                        <i class="fas fa-chevron-down text-xs text-gray-400"></i>
                    </button>

                    <div class="absolute right-0 mt-2 w-64 bg-white dark:bg-gray-800 rounded-lg shadow-lg py-2 hidden z-50" 
                         id="profile-dropdown">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                            <p class="text-sm font-medium"><?= htmlspecialchars($_SESSION['username']) ?></p>
                            <p class="text-xs text-gray-500 dark:text-gray-400"><?= htmlspecialchars($_SESSION['email']) ?></p>
                        </div>
                        
                        <div class="py-2">
                            <a href="#" id="view-profile" class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-user-circle w-5"></i>
                                <span>View Profile</span>
                            </a>
                            <a href="https://idsma.imators.com" class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-cog w-5"></i>
                                <span>Settings</span>
                            </a>
                        </div>

                        <div class="border-t border-gray-200 dark:border-gray-700"></div>

                        <div class="py-2">
                            <a href="logout.php" class="flex items-center px-4 py-2 text-sm text-red-600 dark:text-red-400 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-sign-out-alt w-5"></i>
                                <span>Sign Out</span>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="flex flex-col lg:flex-row items-center space-y-4 lg:space-y-0 lg:space-x-4 w-full lg:w-auto">
            <div class="flex items-center space-x-4 w-full lg:w-auto">
                <button id="theme-toggle" class="p-2 rounded-lg bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors">
                    <i class="fas fa-sun dark:hidden"></i>
                    <i class="fas fa-moon hidden dark:block"></i>
                </button>

                <div class="relative w-full lg:w-96">
                    <input type="text" id="global-search" placeholder="Search users or documents..." 
                        class="w-full px-4 py-2 pl-10 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg
                               focus:outline-none focus:ring-2 focus:ring-gray-400 dark:focus:ring-gray-500">
                    <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                </div>
            </div>

            <?php if(isset($_SESSION['user_id'])): ?>
                <div class="hidden lg:flex relative" id="profile-menu-desktop">
                    <button class="flex items-center space-x-3 p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">
                        <div class="w-10 h-10 rounded-full overflow-hidden bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                            <?php if (!empty($_SESSION['profile_picture'])): ?>
                                <img src="<?= htmlspecialchars($_SESSION['profile_picture']) ?>" 
                                     alt="Profile" 
                                     class="w-full h-full object-cover"
                                     onerror="this.onerror=null; this.src='https://cdn.imators.com/default-avatar.png';">
                            <?php else: ?>
                                <i class="fas fa-user text-gray-400 text-xl"></i>
                            <?php endif; ?>
                        </div>
                        <div class="text-left">
                            <p class="text-sm font-medium"><?= htmlspecialchars($_SESSION['username']) ?></p>
                            <p class="text-xs text-gray-500 dark:text-gray-400"><?= htmlspecialchars($_SESSION['role_imators']) ?></p>
                        </div>
                        <i class="fas fa-chevron-down text-xs text-gray-400"></i>
                    </button>

                    <div class="absolute right-0 mt-2 w-64 bg-white dark:bg-gray-800 rounded-lg shadow-lg py-2 hidden z-50" 
                         id="profile-dropdown-desktop">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                            <p class="text-sm font-medium"><?= htmlspecialchars($_SESSION['username']) ?></p>
                            <p class="text-xs text-gray-500 dark:text-gray-400"><?= htmlspecialchars($_SESSION['email']) ?></p>
                        </div>
                        
                        <div class="py-2">
                            <a href="#" id="view-profile" class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-user-circle w-5"></i>
                                <span>View Profile</span>
                            </a>
                            <a href="https://idsma.imators.com" class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-cog w-5"></i>
                                <span>Settings</span>
                            </a>
                        </div>

                        <div class="border-t border-gray-200 dark:border-gray-700"></div>

                        <div class="py-2">
                            <a href="logout.php" class="flex items-center px-4 py-2 text-sm text-red-600 dark:text-red-400 hover:bg-gray-100 dark:hover:bg-gray-700">
                                <i class="fas fa-sign-out-alt w-5"></i>
                                <span>Sign Out</span>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Ajouter le modal de profil -->
<div id="profile-modal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden items-center justify-center z-50">
    <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-2xl mx-4 shadow-xl">
        <div class="p-6">
<div class="space-y-4">
    <div class="flex justify-between items-start">
        <h2 class="text-xl font-bold flex items-center space-x-2">
            <i class="fas fa-user-circle text-gray-600 dark:text-gray-400"></i>
            <span>My Imators Profile</span>
        </h2>
        <button class="close-profile-modal text-gray-400 hover:text-gray-600 dark:hover:text-gray-200 transition-colors ml-4">
            <i class="fas fa-times text-xl"></i>
        </button>
    </div>
    
    <p class="text-sm text-gray-600 dark:text-gray-400 max-w-3xl mt-4">
        This is the information related to your Imators account. For the modified render you on idsma.imators.com. 
        It is strongly not recommended to send you test tickets between your Dashboard account and professional.
    </p>
</div>

            <div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Photo de profil -->
                <div class="md:col-span-1">
                    <div class="flex flex-col items-center space-y-4">
                        <div class="w-32 h-32 rounded-full overflow-hidden bg-gray-200 dark:bg-gray-700">
                            <?php if (!empty($_SESSION['profile_picture'])): ?>
                                <img src="<?= htmlspecialchars($_SESSION['profile_picture']) ?>" 
                                     alt="Profile Picture" 
                                     class="w-full h-full object-cover"
                                     onerror="this.onerror=null; this.src='https://cdn.imators.com/default-avatar.png';">
                            <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="fas fa-user text-gray-400 text-4xl"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Informations du profil -->
                <div class="md:col-span-2">
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Username</label>
                            <p class="mt-1 text-lg"><?= htmlspecialchars($_SESSION['username']) ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Email</label>
                            <p class="mt-1 text-lg"><?= htmlspecialchars($_SESSION['email']) ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Role</label>
                            <p class="mt-1 text-lg"><?= htmlspecialchars($_SESSION['role_imators']) ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ajouter ce JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', () => {
    // Éléments du menu mobile
    const profileMenu = document.getElementById('profile-menu');
    const profileDropdown = document.getElementById('profile-dropdown');
    
    // Éléments du menu desktop
    const profileMenuDesktop = document.getElementById('profile-menu-desktop');
    const profileDropdownDesktop = document.getElementById('profile-dropdown-desktop');
    
    // Éléments communs
    const profileModal = document.getElementById('profile-modal');
    const viewProfileBtns = document.querySelectorAll('#view-profile');
    const closeProfileModalBtns = document.querySelectorAll('.close-profile-modal');

    // Fonction de toggle pour les menus déroulants
    const setupMenuToggle = (menuBtn, dropdown) => {
        if (menuBtn) {
            const toggleDropdown = (e) => {
                e.stopPropagation();
                dropdown.classList.toggle('hidden');
            };

            menuBtn.addEventListener('click', toggleDropdown);
        }
    };

    // Configuration des menus mobile et desktop
    setupMenuToggle(profileMenu, profileDropdown);
    setupMenuToggle(profileMenuDesktop, profileDropdownDesktop);

    // Fermer les menus si on clique ailleurs
    document.addEventListener('click', (e) => {
        if (profileMenu && !profileMenu.contains(e.target)) {
            profileDropdown.classList.add('hidden');
        }
        if (profileMenuDesktop && !profileMenuDesktop.contains(e.target)) {
            profileDropdownDesktop.classList.add('hidden');
        }
    });

    // Gestion du modal de profil
    viewProfileBtns.forEach(btn => {
        if (btn) {
            btn.addEventListener('click', (e) => {
                e.preventDefault();
                profileModal.classList.remove('hidden');
                profileModal.classList.add('flex');
                // Fermer les deux dropdowns
                profileDropdown.classList.add('hidden');
                profileDropdownDesktop.classList.add('hidden');
            });
        }
    });

    // Gestion de la fermeture du modal
    closeProfileModalBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            profileModal.classList.add('hidden');
            profileModal.classList.remove('flex');
        });
    });

    // Fermer le modal si on clique en dehors
    if (profileModal) {
        profileModal.addEventListener('click', (e) => {
            if (e.target === profileModal) {
                profileModal.classList.add('hidden');
                profileModal.classList.remove('flex');
            }
        });
    }
});
</script>
    </div>

        <div class="mb-8 overflow-x-auto">
            <nav class="border-b border-gray-200 dark:border-gray-700 min-w-max">
                <div class="flex space-x-8">
                    <button class="user-tab px-4 py-3 font-medium border-b-2 border-black dark:border-white flex items-center space-x-2" data-tab="users">
                        <i class="fas fa-users"></i>
                        <span>Users</span>
                    </button>
                    <button class="doc-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="documents">
                        <i class="fas fa-file-alt"></i>
                        <span>Documents</span>
                    </button>
                    <button class="sites-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="sites">
                        <i class="fas fa-globe"></i>
                        <span>Websites</span>
                    </button>
                    <button class="tickets-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="tickets">
                        <i class="fas fa-ticket-alt"></i>
                        <span>Tickets</span>
                    </button>
                                        <button class="email-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="email">
                        <i class="fas fa-envelope"></i>
                        <span>Email</span>
                    </button>
                    <button class="inbox-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="inbox">
                        <i class="fas fa-inbox"></i>
                        <span>Inbox</span>
                    </button>
                    <button class="file-tab px-4 py-3 font-medium border-b-2 border-transparent hover:text-gray-600 dark:hover:text-gray-300 flex items-center space-x-2" data-tab="file">
                        <i class="fas fa-folder"></i>
                        <span>File</span>
                    </button>
                </div>
            </nav>
        </div>

        <div id="inbox-content" class="tab-content hidden">
    <div class="grid grid-cols-1 lg:grid-cols-[300px,1fr] gap-4">

        <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
            <h2 class="text-xl font-medium mb-6 flex items-center space-x-2">
                <i class="fas fa-cog text-gray-600 dark:text-gray-400"></i>
                <span>Email Configuration</span>
            </h2>

            <form id="email-config-form" class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Email Service</label>
                    <select id="email-service" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                        <option value="gmail">Gmail</option>
                        <option value="outlook">Outlook</option>
                        <option value="yahoo">Yahoo</option>
                        <option value="custom">Custom IMAP</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Email Address</label>
                    <input type="email" id="email-address" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Password/App Password</label>
                    <input type="password" id="email-password" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                </div>

                <div id="custom-settings" class="space-y-4 hidden">
                    <div>
                        <label class="block text-sm font-medium mb-2">IMAP Server</label>
                        <input type="text" id="imap-server" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">IMAP Port</label>
                        <input type="number" id="imap-port" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">SMTP Server</label>
                        <input type="text" id="smtp-server" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">SMTP Port</label>
                        <input type="number" id="smtp-port" class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                    </div>
                </div>

                <button type="submit" class="w-full px-4 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors flex items-center justify-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Save Configuration</span>
                </button>
            </form>
        </div>

        <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-medium flex items-center space-x-2">
                    <i class="fas fa-envelope text-gray-600 dark:text-gray-400"></i>
                    <span>Inbox</span>
                </h2>
                <button id="refresh-inbox" class="px-4 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors flex items-center space-x-2">
                    <i class="fas fa-sync-alt"></i>
                    <span>Refresh</span>
                </button>
            </div>

            <div id="emails-list" class="space-y-2 h-[calc(100vh-300px)] overflow-y-auto">

            </div>
        </div>
    </div>
</div>


        
        <div id="tickets-content" class="tab-content hidden">
    <div class="grid grid-cols-1 lg:grid-cols-[350px,1fr] gap-4">
        <!-- Liste des tickets -->
        <div class="bg-gray-100 dark:bg-gray-800 rounded-lg overflow-hidden">
            <div class="p-4 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-medium flex items-center space-x-2">
                    <i class="fas fa-ticket-alt text-gray-600 dark:text-gray-400"></i>
                    <span>Support Tickets</span>
                </h2>
            </div>
            <div class="h-[calc(100vh-300px)] overflow-y-auto" id="tickets-list">

            </div>
        </div>

        <div class="bg-gray-100 dark:bg-gray-800 rounded-lg overflow-hidden" id="conversation-view">
            <div class="p-4 border-b border-gray-200 dark:border-gray-700 flex justify-between items-center">
                <div>
                    <h3 class="text-xl font-medium" id="selected-ticket-subject">Select a ticket</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400" id="selected-ticket-id"></p>
                </div>
                <select id="ticket-status" class="px-3 py-1 rounded-full text-sm border bg-white dark:bg-gray-800 hidden">
                    <option value="open">Open</option>
                    <option value="in_progress">In Progress</option>
                    <option value="resolved">Resolved</option>
                    <option value="closed">Closed</option>
                </select>
            </div>
            <div class="h-[calc(100vh-400px)] overflow-y-auto p-4 space-y-4" id="conversation-messages">
                <p class="text-center text-gray-500 dark:text-gray-400">Select a ticket to view the conversation</p>
            </div>
            <div class="p-4 border-t border-gray-200 dark:border-gray-700" id="reply-form">
                <div class="flex space-x-2">
                    <input type="text" id="reply-message" 
                           class="flex-1 px-4 py-2 rounded-lg border bg-white dark:bg-gray-800 
                                  focus:outline-none focus:ring-2 focus:ring-gray-400 dark:focus:ring-gray-500"
                           placeholder="Type your response..." disabled>
                    <button id="send-reply" disabled
                            class="px-4 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg 
                                   hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors 
                                   disabled:opacity-50 disabled:cursor-not-allowed
                                   flex items-center space-x-2">
                        <i class="fas fa-paper-plane"></i>
                        <span>Send</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // Variables globales pour les tickets
    let selectedTicketId = null;
    let ticketsUpdateInterval = null;

    // Fonction pour formater la date
    function formatDate(dateString) {
        const options = { 
            year: 'numeric', 
            month: 'short', 
            day: 'numeric',
            hour: '2-digit', 
            minute: '2-digit'
        };
        return new Date(dateString).toLocaleDateString('fr-FR', options);
    }

    // Fonction pour charger les tickets
    async function loadTickets() {
        try {
            const response = await fetch('get_tickets.php');
            const tickets = await response.json();
            
            const ticketsList = document.getElementById('tickets-list');
ticketsList.innerHTML = tickets.map(ticket => `
    <div class="ticket-item cursor-pointer p-4 border-b border-gray-200 dark:border-gray-700 
                hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors
                ${selectedTicketId === ticket.id ? 'bg-gray-200 dark:bg-gray-700' : ''}"
         data-ticket-id="${ticket.id}">
        <div class="flex justify-between items-start">
            <div class="flex-grow">
                <h3 class="font-medium">${ticket.subject}</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    ${ticket.description.substring(0, 100)}...
                </p>
            </div>
            <div class="flex flex-col items-end ml-4">
                <span class="px-2 py-1 text-xs rounded-full text-white ${getStatusColor(ticket.status)}">
                    ${ticket.status}
                </span>
                ${ticket.tackby ? `
                    <span class="mt-2 text-xs bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 px-2 py-1 rounded-full">
                        ${ticket.taken_by_username}
                    </span>
                ` : ''}
            </div>
        </div>
        <div class="mt-2 text-xs text-gray-500 flex items-center justify-between">
            <div>
                <i class="fas fa-user"></i>
                User #${ticket.user_id} · ${formatDate(ticket.created_at)}
            </div>
            ${ticket.taken_at ? `
                <div>
                    <i class="fas fa-clock"></i>
                    Taken ${formatDate(ticket.taken_at)}
                </div>
            ` : ''}
        </div>
    </div>
`).join('');

            // Réattacher les événements de clic
            attachTicketClickEvents();

            // Si un ticket est sélectionné, mettre à jour sa conversation
            if (selectedTicketId) {
                const selectedTicket = tickets.find(t => t.id === selectedTicketId);
                if (selectedTicket) {
                    updateConversationView(selectedTicket);
                }
            }
        } catch (error) {
            console.error('Error loading tickets:', error);
            showNotification('Failed to load tickets', 'error');
        }
    }

    // Fonction pour attacher les événements de clic aux tickets
    function attachTicketClickEvents() {
        document.querySelectorAll('.ticket-item').forEach(item => {
            item.addEventListener('click', async () => {
                const ticketId = parseInt(item.dataset.ticketId);
                selectedTicketId = ticketId;
                
                // Mettre à jour la sélection visuelle
                document.querySelectorAll('.ticket-item').forEach(t => 
                    t.classList.remove('bg-gray-200', 'dark:bg-gray-700'));
                item.classList.add('bg-gray-200', 'dark:bg-gray-700');

                try {
                    const response = await fetch('get_tickets.php');
                    const tickets = await response.json();
                    const ticket = tickets.find(t => t.id === ticketId);
                    if (ticket) {
                        updateConversationView(ticket);
                    }
                } catch (error) {
                    console.error('Error loading ticket:', error);
                    showNotification('Failed to load ticket details', 'error');
                }
            });
        });
    }

    // Fonction pour mettre à jour la vue de conversation
    function updateConversationView(ticket) {
        const subject = document.getElementById('selected-ticket-subject');
        const ticketId = document.getElementById('selected-ticket-id');
        const messages = document.getElementById('conversation-messages');
        const status = document.getElementById('ticket-status');
        const replyInput = document.getElementById('reply-message');
        const sendButton = document.getElementById('send-reply');

        subject.textContent = ticket.subject;
        ticketId.textContent = `Ticket #${ticket.id}`;
        status.value = ticket.status;
        status.classList.remove('hidden');
        replyInput.disabled = false;
        sendButton.disabled = false;

        // Construire la conversation
        messages.innerHTML = `
            <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-lg">
                <div class="flex items-center gap-2 mb-2">
                    <i class="fas fa-user"></i>
                    <span class="font-medium">User #${ticket.user_id}</span>
                    <span class="text-xs text-gray-500">${formatDate(ticket.created_at)}</span>
                </div>
                <p>${ticket.description}</p>
            </div>
            ${ticket.responses ? ticket.responses.map(response => `
                <div class="p-4 rounded-lg ${response.is_staff ? 
                    'bg-blue-100 dark:bg-blue-900 ml-8' : 
                    'bg-gray-200 dark:bg-gray-700 mr-8'}">
                    <div class="flex items-center gap-2 mb-2">
                        <i class="fas fa-user"></i>
                        <span class="font-medium">
                            ${response.is_staff ? 'Staff' : `User #${response.user_id}`}
                        </span>
                        <span class="text-xs text-gray-500">
                            ${formatDate(response.created_at)}
                        </span>
                    </div>
                    <p>${response.response}</p>
                </div>
            `).join('') : ''}
        `;

        // Scroll to bottom
        messages.scrollTop = messages.scrollHeight;
    }

    // Fonction pour obtenir la couleur du statut
    function getStatusColor(status) {
        const colors = {
            'open': 'bg-yellow-500',
            'in_progress': 'bg-blue-500',
            'resolved': 'bg-green-500',
            'closed': 'bg-gray-500'
        };
        return colors[status] || 'bg-gray-500';
    }

    // Gérer le changement de statut
    document.getElementById('ticket-status').addEventListener('change', async (e) => {
        if (!selectedTicketId) return;

        try {
            const response = await fetch('update_ticket_status.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    ticketId: selectedTicketId,
                    status: e.target.value
                })
            });

            if (!response.ok) throw new Error('Failed to update status');

            showNotification('Status updated successfully', 'success');
            loadTickets();
        } catch (error) {
            console.error('Error updating status:', error);
            showNotification('Failed to update status', 'error');
        }
    });

    // Gérer l'envoi de réponse
    document.getElementById('reply-message').addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            document.getElementById('send-reply').click();
        }
    });

    document.getElementById('send-reply').addEventListener('click', async () => {
        if (!selectedTicketId) return;

        const messageInput = document.getElementById('reply-message');
        const message = messageInput.value.trim();
        
        if (!message) return;

        try {
            const response = await fetch('add_response.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    ticketId: selectedTicketId,
                    message: message,
                    isStaff: true
                })
            });

            if (!response.ok) throw new Error('Failed to send response');

            messageInput.value = '';
            showNotification('Response sent successfully', 'success');
            loadTickets();
        } catch (error) {
            console.error('Error sending response:', error);
            showNotification('Failed to send response', 'error');
        }
    });

    // Fonction pour afficher les notifications
    function showNotification(message, type = 'success') {
        const notification = document.createElement('div');
        notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg shadow-lg z-50 ${
            type === 'success' ? 'bg-green-500' : 'bg-red-500'
        } text-white`;
        
        notification.innerHTML = `
            <div class="flex items-center space-x-2">
                <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'}"></i>
                <span>${message}</span>
            </div>
        `;
        
        document.body.appendChild(notification);
        setTimeout(() => notification.remove(), 3000);
    }

    // Charger les tickets initialement
    loadTickets();

    // Mettre en place la mise à jour automatique
    ticketsUpdateInterval = setInterval(loadTickets, 30000); // Toutes les 30 secondes

    // Nettoyer l'intervalle quand on change d'onglet
    document.querySelectorAll('[data-tab]').forEach(tab => {
        tab.addEventListener('click', () => {
            if (tab.dataset.tab !== 'tickets') {
                clearInterval(ticketsUpdateInterval);
            } else {
                loadTickets();
                ticketsUpdateInterval = setInterval(loadTickets, 30000);
            }
        });
    });
});
</script>
        
        <div id="email-content" class="tab-content hidden">
    <div class="grid grid-cols-1 gap-6">
        <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
            <h2 class="text-xl font-medium mb-6 flex items-center space-x-2">
                <i class="fas fa-paper-plane text-gray-600 dark:text-gray-400"></i>
                <span>Send Email</span>
            </h2>

            <!-- Status du serveur email -->
            <div id="email-server-status" class="mb-6">
                <div class="flex items-center space-x-2">
                    <div class="animate-spin rounded-full h-4 w-4 border-2 border-gray-500 border-t-black dark:border-t-white"></div>
                    <span>Checking email server status...</span>
                </div>
            </div>

            <form id="send-email-form" class="space-y-6">
                <!-- Sélection du destinataire -->
                <div>
                    <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                        <i class="fas fa-user text-gray-500 dark:text-gray-400"></i>
                        <span>Recipient</span>
                    </label>
                    <select id="email-recipient" name="recipient" required
                            class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 
                                   border border-gray-200 dark:border-gray-600
                                   focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white">
                        <option value="">Select a recipient</option>
                        <?php
                        $db1 = getDB1Connection();
                        $query = $db1->query("SELECT id, username, email FROM utilisateurs ORDER BY username");
                        while($user = $query->fetch(PDO::FETCH_ASSOC)) {
                            echo "<option value='" . htmlspecialchars($user['id']) . "' 
                                        data-email='" . htmlspecialchars($user['email']) . "'
                                        data-username='" . htmlspecialchars($user['username']) . "'>
                                    " . htmlspecialchars($user['username']) . " (" . htmlspecialchars($user['email']) . ")
                                  </option>";
                        }
                        ?>
                    </select>
                </div>

                <!-- Sujet de l'email -->
                <div>
                    <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                        <i class="fas fa-heading text-gray-500 dark:text-gray-400"></i>
                        <span>Subject</span>
                    </label>
                    <input type="text" id="email-subject" name="subject" required
                           placeholder="Enter email subject"
                           class="w-full px-4 py-2 rounded-lg bg-white dark:bg-gray-700 
                                  border border-gray-200 dark:border-gray-600
                                  focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white">
                </div>

                <!-- Éditeur de contenu -->
                <div>
                    <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                        <i class="fas fa-pen-fancy text-gray-500 dark:text-gray-400"></i>
                        <span>Content</span>
                    </label>
                    <div class="border border-gray-200 dark:border-gray-600 rounded-lg overflow-hidden">
                        <div class="bg-white dark:bg-gray-700 border-b border-gray-200 dark:border-gray-600 p-2 flex space-x-2">
                            <button type="button" data-format="bold" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded">
                                <i class="fas fa-bold"></i>
                            </button>
                            <button type="button" data-format="italic" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded">
                                <i class="fas fa-italic"></i>
                            </button>
                            <button type="button" data-format="underline" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded">
                                <i class="fas fa-underline"></i>
                            </button>
                            <div class="w-px bg-gray-200 dark:bg-gray-600"></div>
                            <button type="button" data-format="link" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded">
                                <i class="fas fa-link"></i>
                            </button>
                        </div>
                        <div id="email-editor" contenteditable="true"
                             class="min-h-[200px] p-4 bg-white dark:bg-gray-700 focus:outline-none"
                             placeholder="Compose your email here... Use {username} to automatically insert recipient's name"></div>
                    </div>
                </div>

                <!-- Preview -->
                <div class="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                    <h3 class="text-sm font-medium mb-4 flex items-center space-x-2">
                        <i class="fas fa-eye text-gray-500 dark:text-gray-400"></i>
                        <span>Preview</span>
                    </h3>
                    <div id="email-preview" class="bg-white dark:bg-gray-900 rounded-lg p-6">
                        <!-- Le preview sera injecté ici par JavaScript -->
                    </div>
                </div>

                <!-- Boutons d'action -->
                <div class="flex justify-end space-x-3">
                    <button type="button" id="refresh-preview"
                            class="flex items-center space-x-2 px-4 py-2 border border-gray-200 dark:border-gray-600 
                                   rounded-lg text-gray-700 dark:text-gray-300 
                                   hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                        <i class="fas fa-sync-alt"></i>
                        <span>Refresh Preview</span>
                    </button>
                    <button type="submit"
                            class="flex items-center space-x-2 px-4 py-2 bg-black dark:bg-white text-white dark:text-black 
                                   rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors">
                        <i class="fas fa-paper-plane"></i>
                        <span>Send Email</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
        
     <div id="users-content" class="tab-content">
    <div class="mb-6">
        <div class="flex justify-between items-center">
            <p class="text-sm text-gray-600 dark:text-gray-400" id="users-count">Loading users...</p>
        </div>
    </div>
    <div id="users-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <?php
        $db1 = getDB1Connection();
        $query = $db1->query("SELECT * FROM utilisateurs ORDER BY username");
        while($user = $query->fetch(PDO::FETCH_ASSOC)) {
        ?>
            <div class="user-card bg-gray-100 dark:bg-gray-800 p-6 rounded-lg cursor-pointer hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors"
                 data-user-id="<?= $user['id'] ? htmlspecialchars($user['id']) : '' ?>"
                 data-email="<?= $user['email'] ? htmlspecialchars($user['email']) : '' ?>"
                 data-username="<?= $user['username'] ? htmlspecialchars($user['username']) : '' ?>"
                 data-note="<?= $user['note'] ? htmlspecialchars($user['note']) : '' ?>"
                 data-searchable="<?= htmlspecialchars(
                     ($user['username'] ? $user['username'] : '') . ' ' . 
                     ($user['email'] ? $user['email'] : '') . ' ' . 
                     ($user['note'] ? $user['note'] : '')
                 ) ?>">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="flex items-center space-x-2">
                            <i class="fas fa-user text-gray-500 dark:text-gray-400"></i>
                            <h3 class="font-medium text-lg username"><?= $user['username'] ? htmlspecialchars($user['username']) : '' ?></h3>
                        </div>
                        <div class="flex items-center space-x-2 mt-1">
                            <i class="fas fa-envelope text-gray-500 dark:text-gray-400"></i>
                            <p class="text-sm text-gray-600 dark:text-gray-400 email"><?= $user['email'] ? htmlspecialchars($user['email']) : '' ?></p>
                        </div>
                    </div>
                    <button class="text-xs px-3 py-1 bg-gray-200 dark:bg-gray-700 rounded-full hover:bg-gray-300 dark:hover:bg-gray-600 transition-colors flex items-center space-x-1">
                        <i class="fas fa-edit"></i>
                        <span>Edit</span>
                    </button>
                </div>
                <div class="mt-4">
                    <div class="flex items-start space-x-2">
                        <i class="fas fa-sticky-note text-gray-500 dark:text-gray-400 mt-1"></i>
                        <p class="text-sm text-gray-600 dark:text-gray-400 note">
                            <?= $user['note'] ? htmlspecialchars($user['note']) : 'No note' ?>
                        </p>
                    </div>
                </div>
            </div>
        <?php
        }
        ?>
    </div>
</div>

        <div id="documents-content" class="tab-content hidden">
            <div class="grid grid-cols-1 gap-6">
                <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
                    <h2 class="text-xl font-medium mb-4 flex items-center space-x-2">
                        <i class="fas fa-cloud-upload-alt text-gray-600 dark:text-gray-400"></i>
                        <span>Upload Document</span>
                    </h2>
                    <form action="upload_document.php" method="post" enctype="multipart/form-data" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                                <i class="fas fa-file-pdf text-gray-600 dark:text-gray-400"></i>
                                <span>Select PDF File</span>
                            </label>
                            <input type="file" name="pdf_file" accept=".pdf" 
                                   class="block w-full text-sm text-gray-600 dark:text-gray-400
                                          file:mr-4 file:py-2 file:px-4 file:rounded-full 
                                          file:border-0 file:text-sm file:font-medium
                                          file:bg-gray-200 file:dark:bg-gray-700 
                                          file:text-gray-700 file:dark:text-gray-300
                                          hover:file:bg-gray-300 hover:file:dark:bg-gray-600
                                          transition-all">
                        </div>
                        <button type="submit" 
                                class="flex items-center space-x-2 px-4 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg
                                       hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors">
                            <i class="fas fa-upload"></i>
                            <span>Upload</span>
                        </button>
                    </form>
                </div>

                <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
                    <h2 class="text-xl font-medium mb-4 flex items-center space-x-2">
                        <i class="fas fa-file-alt text-gray-600 dark:text-gray-400"></i>
                        <span>Document List</span>
                    </h2>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-4" id="documents-count">Loading documents...</p>
                    <div id="documents-list" class="space-y-2">
                        <?php
                        $db2 = getDB2Connection();
                        $query = $db2->query("SELECT * FROM documents ORDER BY created_at DESC");
                        while($doc = $query->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                            <div class="document-item flex items-center justify-between p-4 bg-white dark:bg-gray-900 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors"
                                 data-searchable="<?= htmlspecialchars(basename($doc['pdf-link'])) ?>">
                                <div class="flex items-center space-x-3">
                                    <i class="fas fa-file-pdf text-red-500"></i>
                                    <a href="<?= htmlspecialchars($doc['pdf-link']) ?>" target="_blank"
                                       class="text-blue-600 dark:text-blue-400 hover:underline document-name">
                                        <?= htmlspecialchars(basename($doc['pdf-link'])) ?>
                                    </a>
                                </div>
                                <div class="flex items-center space-x-2 text-gray-500 dark:text-gray-400">
                                    <i class="far fa-clock"></i>
                                    <span class="text-xs">
                                        <?= date('Y-m-d H:i', strtotime($doc['created_at'])) ?>
                                    </span>
                                </div>
                            </div>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

<div id="sites-content" class="tab-content hidden">
            <div class="grid grid-cols-1 gap-6">
                <div class="bg-gray-100 dark:bg-gray-800 p-6 rounded-lg">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-xl font-medium flex items-center space-x-2">
                            <i class="fas fa-globe text-gray-600 dark:text-gray-400"></i>
                            <span>Website Monitoring</span>
                        </h2>
                        <button id="refresh-sites" 
                                class="flex items-center space-x-2 px-4 py-2 bg-black dark:bg-white text-white dark:text-black rounded-lg
                                       hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors">
                            <i class="fas fa-sync-alt"></i>
                            <span>Refresh</span>
                        </button>
                    </div>
                    <div id="sites-list" class="space-y-4"></div>
                </div>
            </div>
        </div>

        <div id="user-modal" class="hidden fixed inset-0 bg-black/50 dark:bg-black/70 backdrop-blur-sm flex items-center justify-center z-50">
            <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md mx-4 shadow-xl">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-xl font-bold flex items-center space-x-2">
                            <i class="fas fa-user-edit text-gray-600 dark:text-gray-400"></i>
                            <span>Edit User</span>
                        </h2>
                        <button id="close-modal" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200 transition-colors">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>

                    <form id="edit-user-form" class="space-y-4">
                        <input type="hidden" id="user-id" name="user-id">
                        
                        <div>
                            <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                                <i class="fas fa-envelope text-gray-500 dark:text-gray-400"></i>
                                <span>Email</span>
                            </label>
                            <input type="email" id="email" name="email" 
                                   class="w-full px-4 py-2 rounded-lg bg-gray-100 dark:bg-gray-700 
                                          border border-gray-200 dark:border-gray-600
                                          focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                                <i class="fas fa-user text-gray-500 dark:text-gray-400"></i>
                                <span>Username</span>
                            </label>
                            <input type="text" id="username" name="username" 
                                   class="w-full px-4 py-2 rounded-lg bg-gray-100 dark:bg-gray-700 
                                          border border-gray-200 dark:border-gray-600
                                          focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                                <i class="fas fa-key text-gray-500 dark:text-gray-400"></i>
                                <span>New Password</span>
                            </label>
                            <input type="password" id="password" name="password"
                                   placeholder="Leave empty to keep current password" 
                                   class="w-full px-4 py-2 rounded-lg bg-gray-100 dark:bg-gray-700 
                                          border border-gray-200 dark:border-gray-600
                                          focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2 flex items-center space-x-2">
                                <i class="fas fa-sticky-note text-gray-500 dark:text-gray-400"></i>
                                <span>Note</span>
                            </label>
                            <textarea id="note" name="note" rows="3" 
                                      class="w-full px-4 py-2 rounded-lg bg-gray-100 dark:bg-gray-700 
                                             border border-gray-200 dark:border-gray-600
                                             focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white"></textarea>
                        </div>

                        <div class="space-y-4 border-t border-gray-200 dark:border-gray-700 pt-4 mt-4">
    <div>
        <label class="flex items-center space-x-2">
            <input type="checkbox" id="employee-mode" name="employee-mode" class="rounded text-black dark:text-white">
            <span class="text-sm font-medium">Activer le mode employé</span>
        </label>
    </div>

    <div id="employee-settings" class="space-y-4 hidden">
        <div>
            <label class="block text-sm font-medium mb-2">Rôle Imators</label>
            <select id="roleinimators" name="roleinimators" class="w-full px-4 py-2 rounded-lg bg-gray-100 dark:bg-gray-700 border border-gray-200 dark:border-gray-600">
                <option value="">Sélectionner un rôle</option>
                <option value="CEO">CEO</option>
                <option value="ADMIN_SECTOR">ADMIN_SECTOR</option>
                <option value="STAFF">STAFF</option>
                <option value="MODERATOR">MODERATOR</option>
            </select>
        </div>

        <div>
            <label class="block text-sm font-medium mb-2">Permissions des onglets</label>
            <div class="space-y-2">
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="users" class="rounded text-black dark:text-white permission-checkbox">
                    <span class="text-sm">Users</span>
                </label>
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="documents" class="rounded text-black dark:text-white permission-checkbox">
                    <span class="text-sm">Documents</span>
                </label>
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="websites" class="rounded text-black dark:text-white permission-checkbox">
                    <span class="text-sm">Websites</span>
                </label>
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="tickets" class="rounded text-black dark:text-white permission-checkbox">
                    <span class="text-sm">Tickets</span>
                </label>
                <label class="flex items-center space-x-2">
                    <input type="checkbox" name="permissions[]" value="email" class="rounded text-black dark:text-white permission-checkbox">
                    <span class="text-sm">Email</span>
                </label>
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium mb-2">Photo de profil</label>
            <div class="flex items-center space-x-4">
                <div class="w-20 h-20 rounded-full overflow-hidden bg-gray-200 dark:bg-gray-700">
                    <img id="preview-profile-picture" src="https://cdn.imators.com/default-avatar.png" 
                         alt="Profile Preview" class="w-full h-full object-cover">
                </div>
                <input type="file" id="profile-picture" name="profile_picture" 
                       accept="image/*" class="text-sm text-gray-500 dark:text-gray-400">
            </div>
        </div>
    </div>
</div>

                        <div class="flex justify-between space-x-3 pt-4">
    <button type="button" id="delete-user-btn"
            class="flex items-center space-x-2 px-4 py-2 bg-red-500 hover:bg-red-600 text-white 
                   rounded-lg transition-colors">
        <i class="fas fa-trash"></i>
        <span>Delete User</span>
    </button>
    <div class="flex space-x-3">
        <button type="button" 
                class="flex items-center space-x-2 px-4 py-2 border border-gray-200 dark:border-gray-600 
                       rounded-lg text-gray-700 dark:text-gray-300 
                       hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors close-modal">
            <i class="fas fa-times"></i>
            <span>Cancel</span>
        </button>
        <button type="submit" 
                class="flex items-center space-x-2 px-4 py-2 bg-black dark:bg-white text-white dark:text-black 
                       rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors">
            <i class="fas fa-save"></i>
            <span>Save</span>
        </button>
    </div>
</div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    </div>

    <footer class="bg-white text-black dark:bg-black dark:text-white">
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>


<script>
    document.addEventListener('DOMContentLoaded', () => {
    const employeeModeCheckbox = document.getElementById('employee-mode');
    const employeeSettings = document.getElementById('employee-settings');
    const roleSelect = document.getElementById('roleinimators');
    const permissionCheckboxes = document.querySelectorAll('.permission-checkbox');
    const profilePictureInput = document.getElementById('profile-picture');
    const profilePicturePreview = document.getElementById('preview-profile-picture');

    employeeModeCheckbox.addEventListener('change', () => {
        employeeSettings.classList.toggle('hidden', !employeeModeCheckbox.checked);
        if (employeeModeCheckbox.checked) {
            document.querySelector('input[name="role"]').value = "1";
        } else {
            document.querySelector('input[name="role"]').value = "0";
            roleSelect.value = "";
            permissionCheckboxes.forEach(checkbox => checkbox.checked = false);
        }
    });

    roleSelect.addEventListener('change', () => {
        const role = roleSelect.value;
        if (role === 'CEO' || role === 'ADMIN_SECTOR') {
            permissionCheckboxes.forEach(checkbox => {
                checkbox.checked = true;
                checkbox.disabled = true;
            });
        } else {
            permissionCheckboxes.forEach(checkbox => {
                checkbox.disabled = false;
            });
        }
    });

    profilePictureInput.addEventListener('change', (e) => {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = (e) => {
                profilePicturePreview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });

    document.getElementById('edit-user-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        const form = e.target;
        const formData = new FormData(form);

        const permissions = [];
        permissionCheckboxes.forEach(checkbox => {
            if (checkbox.checked) {
                permissions.push(checkbox.value);
            }
        });
        formData.append('permissions', JSON.stringify(permissions));

        const profilePicture = profilePictureInput.files[0];
        if (profilePicture) {
            formData.append('profile_picture', profilePicture);
        }

        const submitButton = form.querySelector('button[type="submit"]');
        const originalContent = submitButton.innerHTML;

        submitButton.disabled = true;
        submitButton.innerHTML = `
            <div class="flex items-center space-x-2">
                <div class="animate-spin rounded-full h-4 w-4 border-2 border-gray-500 border-t-white"></div>
                <span>Saving...</span>
            </div>
        `;

        try {
            const response = await fetch('update_user.php', {
                method: 'POST',
                body: formData
            });

            const result = await response.json();
            if(result.success) {
                const modal = document.getElementById('user-modal');
                modal.classList.add('hidden');
                window.location.href = '?success=1';
            } else {
                throw new Error(result.message || 'Update failed');
            }
        } catch(error) {
            console.error('Error:', error);
            const notification = document.createElement('div');
            notification.className = 'error-notification fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 flex items-center space-x-2';
            notification.innerHTML = `
                <i class="fas fa-exclamation-circle"></i>
                <span>${error.message}</span>
            `;
            document.body.appendChild(notification);
            setTimeout(() => notification.remove(), 5000);
        } finally {
            submitButton.disabled = false;
            submitButton.innerHTML = originalContent;
        }
    });

    function loadUserData(userId) {
        fetch(`get_user_data.php?id=${userId}`)
            .then(response => response.json())
            .then(data => {
                employeeModeCheckbox.checked = data.role === "1";
                employeeSettings.classList.toggle('hidden', data.role !== "1");
                roleSelect.value = data.roleinimators || "";

                if (data.permissions) {
                    const userPermissions = JSON.parse(data.permissions);
                    permissionCheckboxes.forEach(checkbox => {
                        checkbox.checked = userPermissions.includes(checkbox.value);
                    });
                }

                if (data.profile_picture) {
                    profilePicturePreview.src = data.profile_picture;
                } else {
                    profilePicturePreview.src = 'https://cdn.imators.com/default-avatar.png';
                }
            })
            .catch(error => console.error('Error:', error));
    }

    document.querySelectorAll('.user-card').forEach(card => {
        card.addEventListener('click', () => {
            const userId = card.dataset.userId;
            loadUserData(userId);
        });
    });
});
</script>
        
<script>
document.addEventListener('DOMContentLoaded', () => {
    const searchInput = document.getElementById('global-search');
    const userCards = document.querySelectorAll('.user-card');
    const documentItems = document.querySelectorAll('.document-item');
    const usersCount = document.getElementById('users-count');
    const documentsCount = document.getElementById('documents-count');
    const modal = document.getElementById('user-modal');
    const closeButtons = document.querySelectorAll('.close-modal, #close-modal');
    const tabs = document.querySelectorAll('[data-tab]');
    const contents = document.querySelectorAll('.tab-content');
    const themeToggle = document.getElementById('theme-toggle');

    function initTheme() {
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    }

    themeToggle.addEventListener('click', () => {
        document.documentElement.classList.toggle('dark');
        localStorage.theme = document.documentElement.classList.contains('dark') ? 'dark' : 'light';
    });

    function updateCounts() {
        const visibleUsers = document.querySelectorAll('.user-card:not(.hidden)').length;
        const visibleDocs = document.querySelectorAll('.document-item:not(.hidden)').length;
        usersCount.textContent = `Showing ${visibleUsers} user${visibleUsers !== 1 ? 's' : ''}`;
        documentsCount.textContent = `Showing ${visibleDocs} document${visibleDocs !== 1 ? 's' : ''}`;
    }

    function highlightText(element, searchText) {
        const originalText = element.textContent;
        if (searchText && originalText.toLowerCase().includes(searchText.toLowerCase())) {
            const regex = new RegExp(`(${searchText})`, 'gi');
            element.innerHTML = originalText.replace(regex, '<mark class="search-highlight">$1</mark>');
        } else {
            element.textContent = originalText;
        }
    }

    function loadSites() {
        const sitesList = document.getElementById('sites-list');
        sitesList.innerHTML = `
            <div class="flex justify-center items-center p-8">
                <div class="animate-spin rounded-full h-8 w-8 border-2 border-gray-500 border-t-black dark:border-t-white"></div>
            </div>
        `;

        fetch('check_sites.php')
            .then(response => response.json())
            .then(data => {
                sitesList.innerHTML = '';
                if (data && data.results) {
                    data.results.forEach(site => {
                        const div = document.createElement('div');
                        div.className = 'flex items-center justify-between p-4 bg-white dark:bg-gray-900 rounded-lg';
                        
                        const statusClass = site.status ? 'text-green-500' : 'text-red-500';
                        const statusIcon = site.status ? 'fa-check-circle' : 'fa-exclamation-circle';
                        const statusText = site.status ? '' : '';
                        
                        div.innerHTML = `
                            <div class="flex items-center space-x-3">
                                <i class="fas fa-globe text-gray-500 dark:text-gray-400"></i>
                                <a href="${site.url}" target="_blank" class="hover:underline">${site.url}</a>
                            </div>
                            <div class="flex items-center space-x-4">
                                <div class="flex items-center space-x-1 ${statusClass}">
                                    <i class="fas ${statusIcon}"></i>
                                    <span>${statusText}</span>
                                </div>
                                <span class="text-xs text-gray-500 dark:text-gray-400">
                                    <i class="far fa-clock mr-1"></i>${site.timestamp || ''}
                                </span>
                            </div>
                        `;
                        
                        sitesList.appendChild(div);
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                sitesList.innerHTML = `
                    <div class="bg-red-100 dark:bg-red-900 border-l-4 border-red-500 text-red-700 dark:text-red-300 p-4 rounded">
                        <div class="flex items-center space-x-2">
                            <i class="fas fa-exclamation-circle"></i>
                            <span>Unable to load sites. Please try again later.</span>
                        </div>
                    </div>
                `;
            });
    }

    searchInput.addEventListener('input', (e) => {
        const searchText = e.target.value.toLowerCase();

        userCards.forEach(card => {
            const searchableText = card.dataset.searchable.toLowerCase();
            const visible = searchableText.includes(searchText);
            card.classList.toggle('hidden', !visible);

            if (visible) {
                card.querySelectorAll('.username, .email, .note').forEach(element => {
                    highlightText(element, searchText);
                });
            }
        });

        documentItems.forEach(item => {
            const searchableText = item.dataset.searchable.toLowerCase();
            const visible = searchableText.includes(searchText);
            item.classList.toggle('hidden', !visible);

            if (visible) {
                highlightText(item.querySelector('.document-name'), searchText);
            }
        });

        updateCounts();
    });

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            tabs.forEach(t => {
                t.classList.remove('border-black', 'dark:border-white');
                t.classList.add('border-transparent');
            });
            
            tab.classList.remove('border-transparent');
            tab.classList.add('border-black', 'dark:border-white');
            
            contents.forEach(content => content.classList.add('hidden'));
            document.getElementById(`${tab.dataset.tab}-content`).classList.remove('hidden');

            if (tab.dataset.tab === 'sites') {
                loadSites();
            }
        });
    });

    userCards.forEach(card => {
        card.addEventListener('click', () => {
            modal.classList.remove('hidden');
            document.getElementById('user-id').value = card.dataset.userId;
            document.getElementById('email').value = card.dataset.email;
            document.getElementById('username').value = card.dataset.username;
            document.getElementById('note').value = card.dataset.note;
        });
    });

    closeButtons.forEach(button => {
        button.addEventListener('click', () => {
            modal.classList.add('hidden');
        });
    });

    document.getElementById('edit-user-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        const form = e.target;
        const submitButton = form.querySelector('button[type="submit"]');
        const originalContent = submitButton.innerHTML;
        
        submitButton.disabled = true;
        submitButton.innerHTML = `
            <div class="flex items-center space-x-2">
                <div class="animate-spin rounded-full h-4 w-4 border-2 border-gray-500 border-t-white"></div>
                <span>Saving...</span>
            </div>
        `;

        try {
            const formData = new FormData(form);
            const response = await fetch('update_user.php', {
                method: 'POST',
                body: formData
            });
            
            const result = await response.json();
            if(result.success) {
                modal.classList.add('hidden');
                window.location.href = '?success=1';
            } else {
                throw new Error('Update failed');
            }
        } catch(error) {
            console.error('Error:', error);
            window.location.href = '?error=1';
        } finally {
            submitButton.disabled = false;
            submitButton.innerHTML = originalContent;
        }
    });

    document.getElementById('delete-user-btn').addEventListener('click', async () => {
        if (confirm('Are you sure you want to delete this user? This action cannot be undone.')) {
            const userId = document.getElementById('user-id').value;
            const button = document.getElementById('delete-user-btn');
            const originalContent = button.innerHTML;
            
            button.disabled = true;
            button.innerHTML = `
                <div class="flex items-center space-x-2">
                    <div class="animate-spin rounded-full h-4 w-4 border-2 border-gray-500 border-t-white"></div>
                    <span>Deleting...</span>
                </div>
            `;

            try {
                const response = await fetch('delete_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `user_id=${userId}`
                });
                
                const result = await response.json();
                if(result.success) {
                    modal.classList.add('hidden');
                    window.location.href = '?success=1';
                } else {
                    throw new Error('Delete failed');
                }
            } catch(error) {
                console.error('Error:', error);
                window.location.href = '?error=1';
            }
        }
    });

    async function checkEmailServer() {
        const statusDiv = document.getElementById('email-server-status');
        try {
            const response = await fetch('check_email_server.php');
            const data = await response.json();
            
            if (data.success) {
                statusDiv.innerHTML = `
                    <div class="flex items-center space-x-2 text-green-500">
                        <i class="fas fa-check-circle"></i>
                        <span>${data.message}</span>
                    </div>
                `;
            } else {
                throw new Error(data.message);
            }
        } catch (error) {
            statusDiv.innerHTML = `
                <div class="flex items-center space-x-2 text-red-500">
                    <i class="fas fa-exclamation-circle"></i>
                    <span>Email server error: ${error.message}</span>
                </div>
            `;
        }
    }

    const editor = document.getElementById('email-editor');
    const formatButtons = document.querySelectorAll('[data-format]');
    
    formatButtons.forEach(button => {
        button.addEventListener('click', () => {
            const format = button.dataset.format;
            
            if (format === 'link') {
                const url = prompt('Enter URL:');
                if (url) {
                    document.execCommand('createLink', false, url);
                }
            } else {
                document.execCommand(format, false, null);
            }
            
            updatePreview();
        });
    });

    function updatePreview() {
        const preview = document.getElementById('email-preview');
        const recipient = document.getElementById('email-recipient');
        const selectedOption = recipient.options[recipient.selectedIndex];
        const username = selectedOption ? selectedOption.dataset.username : '{username}';
        
        let content = editor.innerHTML;
        content = content.replace(/{username}/g, username);
        
        preview.innerHTML = `
            <div class="prose dark:prose-invert max-w-none">
                ${content}
            </div>
            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                <p class="text-sm text-gray-600 dark:text-gray-400 text-center">
                    This email was sent by an official Imators team member.<br>
                    © ${new Date().getFullYear()} Imators. All rights reserved.
                </p>
            </div>
        `;
    }

    document.getElementById('send-email-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        const form = e.target;
        const submitButton = form.querySelector('button[type="submit"]');
        const originalContent = submitButton.innerHTML;
        
        submitButton.disabled = true;
        submitButton.innerHTML = `
            <div class="flex items-center space-x-2">
                <div class="animate-spin rounded-full h-4 w-4 border-2 border-gray-500 border-t-white"></div>
                <span>Sending...</span>
            </div>
        `;

        try {
            const recipient = document.getElementById('email-recipient');
            const subject = document.getElementById('email-subject');
            const content = document.getElementById('email-editor');

            const formData = new FormData();
            formData.append('recipient_id', recipient.value);
            formData.append('subject', subject.value);
            formData.append('content', content.innerHTML);

            const response = await fetch('send_email.php', {
                method: 'POST',
                body: formData
            });

            const result = await response.json();
            if (result.success) {
                form.reset();
                editor.innerHTML = '';
                updatePreview();
                
                const notification = document.createElement('div');
                notification.className = 'success-notification fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 flex items-center space-x-2';
                notification.innerHTML = `
                    <i class="fas fa-check-circle"></i>
                    <span>Email sent successfully!</span>
                `;
                document.body.appendChild(notification);
                
                setTimeout(() => notification.remove(), 5000);
            } else {
                throw new Error(result.error || 'Failed to send email');
            }
        } catch (error) {
            console.error('Error:', error);
            const notification = document.createElement('div');
            notification.className = 'error-notification fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 flex items-center space-x-2';
            notification.innerHTML = `
                <i class="fas fa-exclamation-circle"></i>
                <span>${error.message}</span>
            `;
            document.body.appendChild(notification);
            setTimeout(() => notification.remove(), 5000);
        } finally {
            submitButton.disabled = false;
            submitButton.innerHTML = originalContent;
        }
    });

    document.getElementById('refresh-preview').addEventListener('click', updatePreview);
    document.getElementById('refresh-sites').addEventListener('click', loadSites);
    
    initTheme();
    updateCounts();
    checkEmailServer();
    updatePreview();
    
    editor.addEventListener('input', updatePreview);
    document.getElementById('email-recipient').addEventListener('change', updatePreview);
});


document.addEventListener('DOMContentLoaded', () => {
    const sendReplyBtn = document.getElementById('send-reply');
    const messageInput = document.getElementById('reply-message');
    
    messageInput.addEventListener('keypress', (e) => {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            sendReplyBtn.click();
        }
    });

    sendReplyBtn.addEventListener('click', async () => {
        if (!selectedTicketId) return;

        const message = messageInput.value.trim();
        if (!message) return;

        const originalContent = sendReplyBtn.innerHTML;
        messageInput.disabled = true;
        sendReplyBtn.disabled = true;
        sendReplyBtn.innerHTML = `
            <div class="flex items-center space-x-2">
                <div class="animate-spin rounded-full h-4 w-4 border-2 border-white border-t-transparent"></div>
                <span>Sending...</span>
            </div>
        `;

        try {
            const response = await fetch('add_response.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    ticketId: selectedTicketId,
                    message: message
                })
            });

            const data = await response.json();
            
            if (data.success) {
                const messages = document.getElementById('conversation-messages');
                
                const newMessage = `
                    <div class="p-4 rounded-lg bg-blue-100 dark:bg-blue-900 ml-8 animate-fade-in">
                        <div class="flex items-center gap-2 mb-2">
                            <i class="fas fa-user"></i>
                            <span class="font-medium">${data.response.username}</span>
                            <span class="text-xs text-gray-500">
                                ${new Date(data.response.created_at).toLocaleString('fr-FR', {
                                    year: 'numeric',
                                    month: 'short',
                                    day: 'numeric',
                                    hour: '2-digit',
                                    minute: '2-digit'
                                })}
                            </span>
                        </div>
                        <p>${message}</p>
                    </div>
                `;
                
                messages.insertAdjacentHTML('beforeend', newMessage);
                messages.scrollTop = messages.scrollHeight;
                messageInput.value = '';
                
                showNotification('Response sent successfully', 'success');
                
                setTimeout(() => {
                    loadTickets();
                }, 500);
            } else {
                throw new Error(data.message || 'Failed to send response');
            }
        } catch (error) {
            console.error('Error:', error);
            showNotification(error.message || 'Failed to send response', 'error');
        } finally {
            messageInput.disabled = false;
            sendReplyBtn.disabled = false;
            sendReplyBtn.innerHTML = originalContent;
        }
    });
});

// Ajout du style pour l'animation
const style = document.createElement('style');
style.textContent = `
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in {
        animation: fade-in 0.3s ease-out forwards;
    }
`;
document.head.appendChild(style);

// Mise à jour de la fonction updateConversationView pour l'affichage des dates
function formatDate(dateString) {
    return new Date(dateString).toLocaleString('fr-FR', {
        year: 'numeric',
        month: 'short',
        day: 'numeric',
        hour: '2-digit',
        minute: '2-digit'
    });
}

function updateConversationView(ticket) {
    const messages = document.getElementById('conversation-messages');
    
    messages.innerHTML = `
        <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-lg">
            <div class="flex items-center gap-2 mb-2">
                <i class="fas fa-user"></i>
                <span class="font-medium">${ticket.creator_username}</span>
                <span class="text-xs text-gray-500">${formatDate(ticket.created_at)}</span>
            </div>
            <p>${ticket.description}</p>
        </div>
        ${ticket.responses.map(response => `
            <div class="p-4 rounded-lg ${response.is_staff ? 
                'bg-blue-100 dark:bg-blue-900 ml-8' : 
                'bg-gray-200 dark:bg-gray-700 mr-8'}">
                <div class="flex items-center gap-2 mb-2">
                    <i class="fas fa-user"></i>
                    <span class="font-medium">${response.username}</span>
                    <span class="text-xs text-gray-500">${formatDate(response.created_at)}</span>
                </div>
                <p>${response.response}</p>
            </div>
        `).join('')}
    `;
    
    messages.scrollTop = messages.scrollHeight;
}
    </script>
</body>
</html>


        
