<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$envFile = __DIR__ . '/../.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
            list($key, $value) = explode('=', $line, 2);
            $value = trim($value, '"');
            $_ENV[$key] = $value;
        }
    }
}

function generateJWT($teamId, $serviceId, $keyId, $privateKey) {
    $header = json_encode(['alg' => 'ES256', 'kid' => $keyId, 'id' => "$teamId.$serviceId"]);
    $payload = json_encode([
        'iss' => $teamId,
        'iat' => time(),
        'exp' => time() + 3600,
        'sub' => $serviceId
    ]);
    
    $headerEncoded = rtrim(strtr(base64_encode($header), '+/', '-_'), '=');
    $payloadEncoded = rtrim(strtr(base64_encode($payload), '+/', '-_'), '=');
    
    return "$headerEncoded.$payloadEncoded.signature";
}

try {
    $jwt = generateJWT($_ENV['APPLE_TEAM_ID'], $_ENV['APPLE_SERVICE_ID'], $_ENV['APPLE_KEY_ID'], $_ENV['APPLE_PRIVATE_KEY']);
    
    $latitude = 50.7976;
    $longitude = 4.3447;
    $url = "https://weatherkit.apple.com/api/v1/weather/$latitude/$longitude?dataSets=currentWeather&timezone=Europe/Brussels";
    
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => [
                "Authorization: Bearer $jwt",
                'Content-Type: application/json'
            ]
        ]
    ]);
    
    $response = file_get_contents($url, false, $context);
    $data = json_decode($response, true);
    
    if ($data && isset($data['currentWeather']['temperature'])) {
        $temperature = round($data['currentWeather']['temperature']);
        echo json_encode(['success' => true, 'temperature' => $temperature]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Données météo non disponibles']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>