<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

require_login();

$user = get_user_info($_SESSION['user_id']);
$current_tab = isset($_GET['tab']) ? $_GET['tab'] : 'messages';

$error = null;
$success = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'send_message') {
        $receiver_id = $_POST['receiver_id'] ?? '';
        $content = trim($_POST['content'] ?? '');
        
        if (empty($receiver_id)) {
            $error = "Le destinataire est requis.";
        } elseif (empty($content)) {
            $error = "Le message ne peut pas être vide.";
        } elseif ($receiver_id == $_SESSION['user_id']) {
            $error = "Tu ne peux pas t'envoyer un message à toi-même.";
        } else {
            $message_id = send_message($_SESSION['user_id'], $receiver_id, $content);
            
            if ($message_id) {
                $success = "Message envoyé avec succès.";
            } else {
                $error = "Erreur lors de l'envoi du message.";
            }
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'alliance_response') {
        $alliance_id = $_POST['alliance_id'] ?? '';
        $response = $_POST['response'] ?? '';
        
        if (empty($alliance_id) || empty($response)) {
            $error = "Informations manquantes.";
        } else {
            $status = ($response === 'accept') ? 'active' : 'rejected';
            
            $updated = db_update(
                'alliances',
                ['status' => $status],
                'id = ? AND user2_id = ?',
                [$alliance_id, $_SESSION['user_id']]
            );
            
            if ($updated) {
                $success = ($response === 'accept') ? "Alliance acceptée." : "Alliance rejetée.";
            } else {
                $error = "Erreur lors du traitement de la demande d'alliance.";
            }
        }
    }
}

$received_messages = db_get_all(
    "SELECT c.*, u.username as sender_username
     FROM communications c
     JOIN users u ON c.sender_id = u.id
     WHERE c.receiver_id = ?
     ORDER BY c.created_at DESC
     LIMIT 50",
    [$_SESSION['user_id']]
);

$sent_messages = db_get_all(
    "SELECT c.*, u.username as receiver_username
     FROM communications c
     JOIN users u ON c.receiver_id = u.id
     WHERE c.sender_id = ?
     ORDER BY c.created_at DESC
     LIMIT 50",
    [$_SESSION['user_id']]
);

$alliances = db_get_all(
    "SELECT a.*, 
        CASE
            WHEN a.user1_id = ? THEN u2.username
            ELSE u1.username
        END as ally_username,
        CASE
            WHEN a.user1_id = ? THEN u2.id
            ELSE u1.id
        END as ally_id
     FROM alliances a
     JOIN users u1 ON a.user1_id = u1.id
     JOIN users u2 ON a.user2_id = u2.id
     WHERE (a.user1_id = ? OR a.user2_id = ?)
     ORDER BY a.created_at DESC",
    [$_SESSION['user_id'], $_SESSION['user_id'], $_SESSION['user_id'], $_SESSION['user_id']]
);

$pending_alliances = array_filter($alliances, function($a) {
    return $a['status'] === 'pending' && $a['user2_id'] === $_SESSION['user_id'];
});

$active_alliances = array_filter($alliances, function($a) {
    return $a['status'] === 'active';
});

$allies = db_get_all(
    "SELECT u.id, u.username, u.level, u.last_active
     FROM users u
     JOIN alliances a ON (a.user1_id = u.id OR a.user2_id = u.id)
     WHERE a.status = 'active'
     AND (
         (a.user1_id = ? AND a.user2_id = u.id)
         OR
         (a.user2_id = ? AND a.user1_id = u.id)
     )
     ORDER BY u.username",
    [$_SESSION['user_id'], $_SESSION['user_id']]
);

$nearby_users = [];
if ($user['last_position_lat'] && $user['last_position_lng']) {
    $nearby_users = get_nearby_users(
        $user['last_position_lat'],
        $user['last_position_lng'],
        10,
        $_SESSION['user_id']
    );
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Communications | Cergies</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: white;
        }
        .card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        .tab-active {
            border-bottom: 2px solid #3B82F6;
            color: #3B82F6;
        }
        .message-bubble-received {
            background-color: #F3F4F6;
            border-radius: 18px 18px 18px 4px;
        }
        .message-bubble-sent {
            background-color: #DBEAFE;
            border-radius: 18px 18px 4px 18px;
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <header class="bg-gray-900 text-white">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center">
                <h1 class="text-2xl font-bold">CERGIES</h1>
            </div>
            <nav>
                <ul class="flex space-x-6">
                    <li><a href="index.php" class="hover:text-blue-300">Accueil</a></li>
                    <li><a href="map.php" class="hover:text-blue-300">Carte</a></li>
                    <li><a href="communication.php" class="hover:text-blue-300 font-semibold">Communications</a></li>
                    <li><a href="system.php" class="hover:text-blue-300">Système</a></li>
                    <li><a href="inventory.php" class="hover:text-blue-300">Inventaire</a></li>
                    <li><a href="missions.php" class="hover:text-blue-300">Missions</a></li>
                    <?php if ($user['level'] >= 10): ?>
                        <li><a href="unions.php" class="hover:text-blue-300">Unions</a></li>
                    <?php endif; ?>
                    <li><a href="profile.php" class="hover:text-blue-300">Profil</a></li>
                    <li><a href="logout.php" class="hover:text-red-300">Déconnexion</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <main class="container mx-auto px-4 py-8">
        <h2 class="text-2xl font-bold mb-6">Communications</h2>
        
        <?php if (isset($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if (isset($success)): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($pending_alliances)): ?>
            <div class="card p-4 mb-6">
                <h3 class="text-lg font-semibold mb-2">Demandes d'alliance en attente</h3>
                <div class="space-y-3">
                    <?php foreach($pending_alliances as $alliance): ?>
                        <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                            <div>
                                <p class="font-medium"><?php echo htmlspecialchars($alliance['ally_username']); ?> souhaite former une alliance avec toi</p>
                                <p class="text-sm text-gray-500">Demande envoyée le <?php echo format_datetime($alliance['created_at']); ?></p>
                            </div>
                            <div class="flex space-x-2">
                                <form method="POST" action="communication.php?tab=<?php echo $current_tab; ?>" class="inline-block">
                                    <input type="hidden" name="action" value="alliance_response">
                                    <input type="hidden" name="alliance_id" value="<?php echo $alliance['id']; ?>">
                                    <input type="hidden" name="response" value="accept">
                                    <button type="submit" class="bg-green-600 hover:bg-green-700 text-white py-1 px-3 rounded">Accepter</button>
                                </form>
                                <form method="POST" action="communication.php?tab=<?php echo $current_tab; ?>" class="inline-block">
                                    <input type="hidden" name="action" value="alliance_response">
                                    <input type="hidden" name="alliance_id" value="<?php echo $alliance['id']; ?>">
                                    <input type="hidden" name="response" value="reject">
                                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white py-1 px-3 rounded">Rejeter</button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>