<?php
require_once 'config.php';

if(!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$video_id = $_GET['id'] ?? null;
if(!$video_id) {
    header('Location: profile.php');
    exit;
}

// Check if video belongs to user
$stmt = $pdo->prepare("SELECT * FROM content WHERE id = ? AND author_id = ?");
$stmt->execute([$video_id, $_SESSION['user_id']]);
$video = $stmt->fetch();

if(!$video) {
    header('Location: profile.php');
    exit;
}

if(isset($_POST['update_video'])) {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $tags = $_POST['tags'];
    $time = $_POST['time'];
    $url_video = $_POST['url_video'];
    $picture_cover = $_POST['picture_cover'];
    
    $stmt = $pdo->prepare("UPDATE content SET name = ?, description = ?, tags = ?, time = ?, url_video = ?, picture_cover = ? WHERE id = ? AND author_id = ?");
    
    try {
        $stmt->execute([$name, $description, $tags, $time, $url_video, $picture_cover, $video_id, $_SESSION['user_id']]);
        header('Location: profile.php');
        exit;
    } catch(PDOException $e) {
        $error = "Error updating video";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Video - ForMore</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-black to-blue-900 min-h-screen text-white p-8">
    <nav class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold">ForMore</h1>
        <a href="profile.php" class="text-blue-400 hover:text-blue-300">Back to Profile</a>
    </nav>

    <div class="max-w-2xl mx-auto">
        <form method="POST" class="bg-gray-800 rounded-lg p-6">
            <?php if(isset($error)): ?>
                <div class="bg-red-500 text-white p-3 rounded mb-4"><?= $error ?></div>
            <?php endif; ?>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Video Title</label>
                <input type="text" name="name" value="<?= htmlspecialchars($video['name']) ?>" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Video URL</label>
                <input type="url" name="url_video" value="<?= htmlspecialchars($video['url_video']) ?>" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Cover Image URL</label>
                <input type="url" name="picture_cover" value="<?= htmlspecialchars($video['picture_cover']) ?>" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Duration (e.g. "5:30")</label>
                <input type="text" name="time" value="<?= htmlspecialchars($video['time']) ?>" required pattern="[0-9]+:[0-9]+" 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Tags (comma separated)</label>
                <input type="text" name="tags" value="<?= htmlspecialchars($video['tags']) ?>" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-6">
                <label class="block text-gray-300 text-sm font-bold mb-2">Description</label>
                <textarea name="description" required rows="4" 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"><?= htmlspecialchars($video['description']) ?></textarea>
            </div>

            <div class="flex gap-4">
                <button type="submit" name="update_video" 
                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline flex-grow">
                    Update Video
                </button>
                <a href="profile.php" 
                    class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline text-center">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</body>
</html>